/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.os.Parcel;
import android.os.Parcelable;

public class SliceSpec
implements Parcelable {
    private final String mType;
    private final int mRevision;
    public static final Parcelable.Creator<SliceSpec> CREATOR = new Parcelable.Creator<SliceSpec>(){

        @Override
        public SliceSpec createFromParcel(Parcel source) {
            return new SliceSpec(source);
        }

        public SliceSpec[] newArray(int size) {
            return new SliceSpec[size];
        }
    };

    public SliceSpec(String type, int revision) {
        this.mType = type;
        this.mRevision = revision;
    }

    public SliceSpec(Parcel source) {
        this.mType = source.readString();
        this.mRevision = source.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mType);
        dest.writeInt(this.mRevision);
    }

    public String getType() {
        return this.mType;
    }

    public int getRevision() {
        return this.mRevision;
    }

    public boolean canRender(SliceSpec candidate) {
        if (!this.mType.equals(candidate.mType)) {
            return false;
        }
        return this.mRevision >= candidate.mRevision;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SliceSpec)) {
            return false;
        }
        SliceSpec other = (SliceSpec)obj;
        return this.mType.equals(other.mType) && this.mRevision == other.mRevision;
    }

    public String toString() {
        return String.format("SliceSpec{%s,%d}", this.mType, this.mRevision);
    }
}

