/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.app.servertransaction.ObjectPoolItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class ObjectPool {
    private static final Object sPoolSync = new Object();
    private static final Map<Class, ArrayList<? extends ObjectPoolItem>> sPoolMap = new HashMap<Class, ArrayList<? extends ObjectPoolItem>>();
    private static final int MAX_POOL_SIZE = 50;

    ObjectPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ObjectPoolItem> T obtain(Class<T> itemClass) {
        Object object = sPoolSync;
        synchronized (object) {
            ArrayList<? extends ObjectPoolItem> itemPool = sPoolMap.get(itemClass);
            if (itemPool != null && !itemPool.isEmpty()) {
                return (T)itemPool.remove(itemPool.size() - 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ObjectPoolItem> void recycle(T item) {
        Object object = sPoolSync;
        synchronized (object) {
            ArrayList<ObjectPoolItem> itemPool = sPoolMap.get(item.getClass());
            if (itemPool == null) {
                itemPool = new ArrayList();
                sPoolMap.put(item.getClass(), itemPool);
            }
            int size = itemPool.size();
            for (int i = 0; i < size; ++i) {
                if (itemPool.get(i) != item) continue;
                throw new IllegalStateException("Trying to recycle already recycled item");
            }
            if (size < 50) {
                itemPool.add(item);
            }
        }
    }
}

