/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.ActivityTaskManager;
import android.app.IActivityTaskManager;
import android.app.PendingIntent;
import android.app.TaskStackListener;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Region;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.hardware.input.InputManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.IWindowManager;
import android.view.KeyEvent;
import android.view.SurfaceControl;
import android.view.SurfaceHolder;
import android.view.SurfaceSession;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.inputmethod.InputMethodManager;
import dalvik.system.CloseGuard;
import java.util.List;

public class ActivityView
extends ViewGroup {
    private static final String DISPLAY_NAME = "ActivityViewVirtualDisplay";
    private static final String TAG = "ActivityView";
    private VirtualDisplay mVirtualDisplay;
    private final SurfaceView mSurfaceView;
    private SurfaceControl mRootSurfaceControl;
    private final SurfaceCallback mSurfaceCallback;
    private StateCallback mActivityViewCallback;
    private IActivityTaskManager mActivityTaskManager;
    private final int[] mLocationInWindow = new int[2];
    private final Region mTapExcludeRegion = new Region();
    private TaskStackListener mTaskStackListener;
    private final CloseGuard mGuard = CloseGuard.get();
    private boolean mOpened;
    private final SurfaceControl.Transaction mTmpTransaction = new SurfaceControl.Transaction();
    private final boolean mSingleTaskInstance;
    private Insets mForwardedInsets;

    public ActivityView(Context context) {
        this(context, null);
    }

    public ActivityView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ActivityView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, false);
    }

    public ActivityView(Context context, AttributeSet attrs, int defStyle, boolean singleTaskInstance) {
        super(context, attrs, defStyle);
        this.mSingleTaskInstance = singleTaskInstance;
        this.mActivityTaskManager = ActivityTaskManager.getService();
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceCallback = new SurfaceCallback();
        this.mSurfaceView.getHolder().addCallback(this.mSurfaceCallback);
        this.addView(this.mSurfaceView);
        this.mOpened = true;
        this.mGuard.open("release");
    }

    public void setCallback(StateCallback callback) {
        this.mActivityViewCallback = callback;
        if (this.mVirtualDisplay != null && this.mActivityViewCallback != null) {
            this.mActivityViewCallback.onActivityViewReady(this);
        }
    }

    public void setCornerRadius(float cornerRadius) {
        this.mSurfaceView.setCornerRadius(cornerRadius);
    }

    public void startActivity(Intent intent) {
        ActivityOptions options = this.prepareActivityOptions();
        this.getContext().startActivity(intent, options.toBundle());
    }

    public void startActivity(Intent intent, UserHandle user) {
        ActivityOptions options = this.prepareActivityOptions();
        this.getContext().startActivityAsUser(intent, options.toBundle(), user);
    }

    public void startActivity(PendingIntent pendingIntent) {
        ActivityOptions options = this.prepareActivityOptions();
        try {
            pendingIntent.send(null, 0, null, null, null, null, options.toBundle());
        }
        catch (PendingIntent.CanceledException e) {
            throw new RuntimeException(e);
        }
    }

    public void startActivity(PendingIntent pendingIntent, ActivityOptions options) {
        options.setLaunchDisplayId(this.mVirtualDisplay.getDisplay().getDisplayId());
        try {
            pendingIntent.send(null, 0, null, null, null, null, options.toBundle());
        }
        catch (PendingIntent.CanceledException e) {
            throw new RuntimeException(e);
        }
    }

    private ActivityOptions prepareActivityOptions() {
        if (this.mVirtualDisplay == null) {
            throw new IllegalStateException("Trying to start activity before ActivityView is ready.");
        }
        ActivityOptions options = ActivityOptions.makeBasic();
        options.setLaunchDisplayId(this.mVirtualDisplay.getDisplay().getDisplayId());
        return options;
    }

    public void release() {
        if (this.mVirtualDisplay == null) {
            throw new IllegalStateException("Trying to release container that is not initialized.");
        }
        this.performRelease();
    }

    public void onLocationChanged() {
        this.updateLocationAndTapExcludeRegion();
    }

    private void clearActivityViewGeometryForIme() {
        if (this.mVirtualDisplay == null) {
            return;
        }
        int displayId = this.mVirtualDisplay.getDisplay().getDisplayId();
        this.mContext.getSystemService(InputMethodManager.class).reportActivityView(displayId, null);
    }

    @Override
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mSurfaceView.layout(0, 0, r - l, b - t);
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        this.updateLocationAndTapExcludeRegion();
        return super.gatherTransparentRegion(region);
    }

    private void updateLocationAndTapExcludeRegion() {
        if (this.mVirtualDisplay == null || !this.isAttachedToWindow()) {
            return;
        }
        try {
            int x = this.mLocationInWindow[0];
            int y = this.mLocationInWindow[1];
            this.getLocationInWindow(this.mLocationInWindow);
            if (x != this.mLocationInWindow[0] || y != this.mLocationInWindow[1]) {
                x = this.mLocationInWindow[0];
                y = this.mLocationInWindow[1];
                int displayId = this.mVirtualDisplay.getDisplay().getDisplayId();
                WindowManagerGlobal.getWindowSession().updateDisplayContentLocation(this.getWindow(), x, y, displayId);
                Matrix matrix = new Matrix();
                matrix.set(this.getMatrix());
                matrix.postTranslate(x, y);
                this.mContext.getSystemService(InputMethodManager.class).reportActivityView(displayId, matrix);
            }
            this.updateTapExcludeRegion(x, y);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private void updateTapExcludeRegion(int x, int y) throws RemoteException {
        if (!this.canReceivePointerEvents()) {
            this.cleanTapExcludeRegion();
            return;
        }
        this.mTapExcludeRegion.set(x, y, x + this.getWidth(), y + this.getHeight());
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.subtractObscuredTouchableRegion(this.mTapExcludeRegion, this);
        }
        WindowManagerGlobal.getWindowSession().updateTapExcludeRegion(this.getWindow(), this.hashCode(), this.mTapExcludeRegion);
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mSurfaceView.setVisibility(visibility);
    }

    public int getVirtualDisplayId() {
        if (this.mVirtualDisplay != null) {
            return this.mVirtualDisplay.getDisplay().getDisplayId();
        }
        return -1;
    }

    public void performBackPress() {
        if (this.mVirtualDisplay == null) {
            return;
        }
        int displayId = this.mVirtualDisplay.getDisplay().getDisplayId();
        InputManager im = InputManager.getInstance();
        im.injectInputEvent(ActivityView.createKeyEvent(0, 4, displayId), 0);
        im.injectInputEvent(ActivityView.createKeyEvent(1, 4, displayId), 0);
    }

    private static KeyEvent createKeyEvent(int action, int code, int displayId) {
        long when = SystemClock.uptimeMillis();
        KeyEvent ev = new KeyEvent(when, when, action, code, 0, 0, -1, 0, 72, 257);
        ev.setDisplayId(displayId);
        return ev;
    }

    private void initVirtualDisplay(SurfaceSession surfaceSession) {
        if (this.mVirtualDisplay != null) {
            throw new IllegalStateException("Trying to initialize for the second time.");
        }
        int width = this.mSurfaceView.getWidth();
        int height = this.mSurfaceView.getHeight();
        DisplayManager displayManager = this.mContext.getSystemService(DisplayManager.class);
        this.mVirtualDisplay = displayManager.createVirtualDisplay("ActivityViewVirtualDisplay@" + System.identityHashCode(this), width, height, this.getBaseDisplayDensity(), null, 265);
        if (this.mVirtualDisplay == null) {
            Log.e(TAG, "Failed to initialize ActivityView");
            return;
        }
        int displayId = this.mVirtualDisplay.getDisplay().getDisplayId();
        IWindowManager wm = WindowManagerGlobal.getWindowManagerService();
        this.mRootSurfaceControl = new SurfaceControl.Builder(surfaceSession).setContainerLayer().setParent(this.mSurfaceView.getSurfaceControl()).setName(DISPLAY_NAME).build();
        try {
            WindowManagerGlobal.getWindowSession().reparentDisplayContent(this.getWindow(), this.mRootSurfaceControl, displayId);
            wm.dontOverrideDisplayInfo(displayId);
            if (this.mSingleTaskInstance) {
                this.mActivityTaskManager.setDisplayToSingleTaskInstance(displayId);
            }
            wm.setForwardedInsets(displayId, this.mForwardedInsets);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
        this.mTmpTransaction.show(this.mRootSurfaceControl).apply();
        this.mTaskStackListener = new TaskStackListenerImpl();
        try {
            this.mActivityTaskManager.registerTaskStackListener(this.mTaskStackListener);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to register task stack listener", e);
        }
    }

    private void performRelease() {
        boolean displayReleased;
        if (!this.mOpened) {
            return;
        }
        this.mSurfaceView.getHolder().removeCallback(this.mSurfaceCallback);
        this.cleanTapExcludeRegion();
        if (this.mTaskStackListener != null) {
            try {
                this.mActivityTaskManager.unregisterTaskStackListener(this.mTaskStackListener);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to unregister task stack listener", e);
            }
            this.mTaskStackListener = null;
        }
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
            this.mVirtualDisplay = null;
            displayReleased = true;
        } else {
            displayReleased = false;
        }
        if (displayReleased && this.mActivityViewCallback != null) {
            this.mActivityViewCallback.onActivityViewDestroyed(this);
        }
        this.mGuard.close();
        this.mOpened = false;
    }

    private void cleanTapExcludeRegion() {
        if (!this.isAttachedToWindow() || this.mTapExcludeRegion.isEmpty()) {
            return;
        }
        try {
            WindowManagerGlobal.getWindowSession().updateTapExcludeRegion(this.getWindow(), this.hashCode(), null);
            this.mTapExcludeRegion.setEmpty();
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private int getBaseDisplayDensity() {
        WindowManager wm = this.mContext.getSystemService(WindowManager.class);
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        return metrics.densityDpi;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
                this.performRelease();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void setForwardedInsets(Insets insets) {
        this.mForwardedInsets = insets;
        if (this.mVirtualDisplay == null) {
            return;
        }
        try {
            IWindowManager wm = WindowManagerGlobal.getWindowManagerService();
            wm.setForwardedInsets(this.mVirtualDisplay.getDisplay().getDisplayId(), this.mForwardedInsets);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private class TaskStackListenerImpl
    extends TaskStackListener {
        private TaskStackListenerImpl() {
        }

        @Override
        public void onTaskDescriptionChanged(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
            if (ActivityView.this.mVirtualDisplay == null || taskInfo.displayId != ActivityView.this.mVirtualDisplay.getDisplay().getDisplayId()) {
                return;
            }
            ActivityManager.StackInfo stackInfo = this.getTopMostStackInfo();
            if (stackInfo == null) {
                return;
            }
            if (taskInfo.taskId == stackInfo.taskIds[stackInfo.taskIds.length - 1]) {
                ActivityView.this.mSurfaceView.setResizeBackgroundColor(taskInfo.taskDescription.getBackgroundColor());
            }
        }

        @Override
        public void onTaskMovedToFront(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
            if (ActivityView.this.mActivityViewCallback == null || ActivityView.this.mVirtualDisplay == null || taskInfo.displayId != ActivityView.this.mVirtualDisplay.getDisplay().getDisplayId()) {
                return;
            }
            ActivityManager.StackInfo stackInfo = this.getTopMostStackInfo();
            if (stackInfo != null && taskInfo.taskId == stackInfo.taskIds[stackInfo.taskIds.length - 1]) {
                ActivityView.this.mActivityViewCallback.onTaskMovedToFront(taskInfo.taskId);
            }
        }

        @Override
        public void onTaskCreated(int taskId, ComponentName componentName) throws RemoteException {
            if (ActivityView.this.mActivityViewCallback == null || ActivityView.this.mVirtualDisplay == null) {
                return;
            }
            ActivityManager.StackInfo stackInfo = this.getTopMostStackInfo();
            if (stackInfo != null && taskId == stackInfo.taskIds[stackInfo.taskIds.length - 1]) {
                ActivityView.this.mActivityViewCallback.onTaskCreated(taskId, componentName);
            }
        }

        @Override
        public void onTaskRemovalStarted(ActivityManager.RunningTaskInfo taskInfo) throws RemoteException {
            if (ActivityView.this.mActivityViewCallback == null || ActivityView.this.mVirtualDisplay == null || taskInfo.displayId != ActivityView.this.mVirtualDisplay.getDisplay().getDisplayId()) {
                return;
            }
            ActivityView.this.mActivityViewCallback.onTaskRemovalStarted(taskInfo.taskId);
        }

        private ActivityManager.StackInfo getTopMostStackInfo() throws RemoteException {
            int displayId = ActivityView.this.mVirtualDisplay.getDisplay().getDisplayId();
            List<ActivityManager.StackInfo> stackInfoList = ActivityView.this.mActivityTaskManager.getAllStackInfos();
            int stackCount = stackInfoList.size();
            for (int i = 0; i < stackCount; ++i) {
                ActivityManager.StackInfo stackInfo = stackInfoList.get(i);
                if (stackInfo.displayId != displayId) continue;
                return stackInfo;
            }
            return null;
        }
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private SurfaceCallback() {
        }

        @Override
        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            if (ActivityView.this.mVirtualDisplay == null) {
                ActivityView.this.initVirtualDisplay(new SurfaceSession());
                if (ActivityView.this.mVirtualDisplay != null && ActivityView.this.mActivityViewCallback != null) {
                    ActivityView.this.mActivityViewCallback.onActivityViewReady(ActivityView.this);
                }
            } else {
                ActivityView.this.mTmpTransaction.reparent(ActivityView.this.mRootSurfaceControl, ActivityView.this.mSurfaceView.getSurfaceControl()).apply();
            }
            if (ActivityView.this.mVirtualDisplay != null) {
                ActivityView.this.mVirtualDisplay.setDisplayState(true);
            }
            ActivityView.this.updateLocationAndTapExcludeRegion();
        }

        @Override
        public void surfaceChanged(SurfaceHolder surfaceHolder, int format, int width, int height) {
            if (ActivityView.this.mVirtualDisplay != null) {
                ActivityView.this.mVirtualDisplay.resize(width, height, ActivityView.this.getBaseDisplayDensity());
            }
            ActivityView.this.updateLocationAndTapExcludeRegion();
        }

        @Override
        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            if (ActivityView.this.mVirtualDisplay != null) {
                ActivityView.this.mVirtualDisplay.setDisplayState(false);
            }
            ActivityView.this.clearActivityViewGeometryForIme();
            ActivityView.this.cleanTapExcludeRegion();
        }
    }

    public static abstract class StateCallback {
        public abstract void onActivityViewReady(ActivityView var1);

        public abstract void onActivityViewDestroyed(ActivityView var1);

        public void onTaskCreated(int taskId, ComponentName componentName) {
        }

        public void onTaskMovedToFront(int taskId) {
        }

        public void onTaskRemovalStarted(int taskId) {
        }
    }
}

