/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.TypeConverter;

public abstract class BidirectionalTypeConverter<T, V>
extends TypeConverter<T, V> {
    private BidirectionalTypeConverter mInvertedConverter;

    public BidirectionalTypeConverter(Class<T> fromClass, Class<V> toClass) {
        super(fromClass, toClass);
    }

    public abstract T convertBack(V var1);

    public BidirectionalTypeConverter<V, T> invert() {
        if (this.mInvertedConverter == null) {
            this.mInvertedConverter = new InvertedConverter(this);
        }
        return this.mInvertedConverter;
    }

    private static class InvertedConverter<From, To>
    extends BidirectionalTypeConverter<From, To> {
        private BidirectionalTypeConverter<To, From> mConverter;

        public InvertedConverter(BidirectionalTypeConverter<To, From> converter) {
            super(converter.getTargetType(), converter.getSourceType());
            this.mConverter = converter;
        }

        @Override
        public From convertBack(To value) {
            return (From)this.mConverter.convert(value);
        }

        @Override
        public To convert(From value) {
            return this.mConverter.convertBack(value);
        }
    }
}

