/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.console;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.BooleanFunction;
import com.intellij.ws.http.request.cookies.CookieStorageInvalidFileException;
import com.intellij.ws.http.request.cookies.HttpRequestCookiesStorage;
import com.intellij.ws.http.request.run.HttpRequestUpdateManager;
import com.intellij.ws.http.request.run.console.HttpClientMessagePrinter;
import com.intellij.ws.rest.client.RestClientBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpResponsePresentation {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.run.console.HttpResponsePresentation");

    public abstract boolean canBeReformatted();

    public abstract void print(@NotNull Project var1, @NotNull HttpClientMessagePrinter var2, @Nullable String var3, @NotNull FileType var4, @NotNull BooleanFunction<? super FileType> var5);

    @NotNull
    public static HttpResponsePresentation createErrorResponse(@NotNull String text) {
        if (text == null) {
            HttpResponsePresentation.$$$reportNull$$$0(0);
        }
        return new HttpErrorResponsePresentation(text);
    }

    @NotNull
    public static HttpResponsePresentation createResponse(@Nullable String header, @NotNull String response, @NotNull String status, boolean inplace, boolean withCookieJar) {
        if (response == null) {
            HttpResponsePresentation.$$$reportNull$$$0(1);
        }
        if (status == null) {
            HttpResponsePresentation.$$$reportNull$$$0(2);
        }
        return inplace ? new HttpInplaceSucceedResponsePresentation(header, response, status, withCookieJar) : new HttpSucceedResponsePresentation(header, status, withCookieJar);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/run/console/HttpResponsePresentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createErrorResponse";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createResponse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class HttpErrorResponsePresentation
    extends HttpResponsePresentation {
        private final String myText;

        private HttpErrorResponsePresentation(@NotNull String text) {
            if (text == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @Override
        public boolean canBeReformatted() {
            return false;
        }

        @Override
        public void print(@NotNull Project project, @NotNull HttpClientMessagePrinter printer, @Nullable String pathToResponse, @NotNull FileType fileType, @NotNull BooleanFunction<? super FileType> isValid) {
            if (project == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(1);
            }
            if (printer == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(2);
            }
            if (fileType == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(3);
            }
            if (isValid == null) {
                HttpErrorResponsePresentation.$$$reportNull$$$0(4);
            }
            printer.print(this.myText, ConsoleViewContentType.ERROR_OUTPUT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isValid";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/run/console/HttpResponsePresentation$HttpErrorResponsePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class HttpInplaceSucceedResponsePresentation
    extends HttpSucceedResponsePresentation {
        private final String myResponse;

        private HttpInplaceSucceedResponsePresentation(String header, String response, String status, boolean withCookieJar) {
            super(header, status, withCookieJar);
            this.myResponse = response;
        }

        @Override
        public boolean canBeReformatted() {
            return true;
        }

        @Override
        public void print(@NotNull Project project, @NotNull HttpClientMessagePrinter printer, @Nullable String pathToResponse, @NotNull FileType fileType, @NotNull BooleanFunction<? super FileType> isValid) {
            if (project == null) {
                HttpInplaceSucceedResponsePresentation.$$$reportNull$$$0(0);
            }
            if (printer == null) {
                HttpInplaceSucceedResponsePresentation.$$$reportNull$$$0(1);
            }
            if (fileType == null) {
                HttpInplaceSucceedResponsePresentation.$$$reportNull$$$0(2);
            }
            if (isValid == null) {
                HttpInplaceSucceedResponsePresentation.$$$reportNull$$$0(3);
            }
            this.printHeader(printer);
            if (fileType != PlainTextFileType.INSTANCE && StringUtil.isNotEmpty((String)this.myResponse)) {
                String fileName = "DUMMY__." + fileType.getDefaultExtension();
                PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, fileType, (CharSequence)this.myResponse, System.currentTimeMillis(), true);
                ReformatCodeProcessor processor = new ReformatCodeProcessor(file2, false);
                HttpRequestUpdateManager.runUpdateAwareAction(project, () -> processor.runWithoutProgress());
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (isValid.fun((Object)fileType)) {
                        printer.printAsFileType(file2.getText(), fileType);
                        printer.print("\n\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                        this.printStatus(printer);
                        this.printCookieStorage(project, printer);
                    } else {
                        LOG.info("File formatted as " + fileType.getName() + " but another type is active");
                    }
                });
            } else {
                printer.print(this.myResponse, ConsoleViewContentType.NORMAL_OUTPUT);
                printer.print("\n\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                this.printStatus(printer);
                this.printCookieStorage(project, printer);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "printer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "isValid";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ws/http/request/run/console/HttpResponsePresentation$HttpInplaceSucceedResponsePresentation";
            objectArray[2] = "print";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpSucceedResponsePresentation
    extends HttpResponsePresentation {
        private final String myHeader;
        private final String myStatus;
        private final boolean myWithCookieJar;

        private HttpSucceedResponsePresentation(String header, String status, boolean withCookieJar) {
            this.myHeader = header;
            this.myStatus = status;
            this.myWithCookieJar = withCookieJar;
        }

        @Override
        public boolean canBeReformatted() {
            return false;
        }

        @Override
        public void print(@NotNull Project project, @NotNull HttpClientMessagePrinter printer, @Nullable String pathToResponse, @NotNull FileType fileType, @NotNull BooleanFunction<? super FileType> isValid) {
            if (project == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(0);
            }
            if (printer == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(1);
            }
            if (fileType == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(2);
            }
            if (isValid == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(3);
            }
            this.printHeader(printer);
            if (StringUtil.isNotEmpty((String)pathToResponse)) {
                printer.print("> " + pathToResponse, ConsoleViewContentType.NORMAL_OUTPUT);
            } else {
                printer.print(RestClientBundle.message("rest.client.request.response.body.empty", new Object[0]), ConsoleViewContentType.NORMAL_OUTPUT);
            }
            printer.print("\n\n", ConsoleViewContentType.NORMAL_OUTPUT);
            this.printStatus(printer);
            this.printCookieStorage(project, printer);
        }

        protected void printCookieStorage(@NotNull Project project, @NotNull HttpClientMessagePrinter printer) {
            if (project == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(4);
            }
            if (printer == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(5);
            }
            if (!this.myWithCookieJar) {
                return;
            }
            HttpRequestCookiesStorage storage = HttpRequestCookiesStorage.getInstance(project);
            try {
                if (storage.hasCookies()) {
                    printer.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                    printer.print(RestClientBundle.message("http.request.cookie.jar.cookie.preserved", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
                    printer.print("\n> " + HttpRequestCookiesStorage.getDefaultCookieFilePath(project) + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }
            catch (CookieStorageInvalidFileException e) {
                printer.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                printer.print(RestClientBundle.message("http.request.cookie.jar.cookie.preserved.failed", e.getMessage()), ConsoleViewContentType.ERROR_OUTPUT);
                printer.print("\n> " + HttpRequestCookiesStorage.getDefaultCookieFilePath(project) + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
        }

        protected void printHeader(@NotNull HttpClientMessagePrinter printer) {
            if (printer == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(6);
            }
            if (StringUtil.isNotEmpty((String)this.myHeader)) {
                printer.print(this.myHeader, ConsoleViewContentType.SYSTEM_OUTPUT);
                printer.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        }

        protected void printStatus(@NotNull HttpClientMessagePrinter printer) {
            if (printer == null) {
                HttpSucceedResponsePresentation.$$$reportNull$$$0(7);
            }
            printer.print(this.myStatus + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isValid";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/run/console/HttpResponsePresentation$HttpSucceedResponsePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "printCookieStorage";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "printHeader";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "printStatus";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

