/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.console;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactoryImpl;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ValueKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ThrowableRunnable;
import com.intellij.ws.http.request.HttpClientDataKeys;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.environment.HttpRequestIndex;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.http.request.run.HttpRequestActionsProvider;
import com.intellij.ws.http.request.run.HttpRequestExecutorExtensionFactory;
import com.intellij.ws.http.request.run.console.HttpRequestErrorFileFilter;
import com.intellij.ws.http.request.run.console.HttpRequestErrorFixFilter;
import com.intellij.ws.rest.client.RestClientBundle;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0007\f\r\u000e\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter;", "Lcom/intellij/execution/filters/Filter;", "()V", "addEnvFileOption", "", "addVariableToEnvOption", "runWithEnvOption", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "", "AddToExistingEnvConsoleClickAction", "Companion", "ConsoleClickAction", "CreateNewEnvFileConsoleClickAction", "QuickFixProvider", "RunWithEnvAction", "VariablePosition", "intellij.restClient"})
public final class HttpRequestErrorFixFilter
implements Filter {
    private final String addEnvFileOption = "1. " + RestClientBundle.message("http.client.request.error.message.add.env.file.quickfix", new Object[0]);
    private final String addVariableToEnvOption = "2. " + RestClientBundle.message("http.client.request.error.message.add.to.env.quickfix", new Object[0]);
    private final String runWithEnvOption = "3. " + RestClientBundle.message("http.client.request.error.message.run.with.env.quickfix", new Object[0]);
    private static final String variableSeparator = "'";
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Filter.Result result2;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int begin = entireLength - line.length();
        String string = line;
        boolean bl = false;
        QuickFixProvider provider = new QuickFixProvider(begin, ((Object)StringsKt.trimEnd((CharSequence)string)).toString());
        string = provider.getCurrentLine();
        if (Intrinsics.areEqual((Object)string, (Object)this.addEnvFileOption)) {
            String string2 = RestClientBundle.message("http.client.request.error.message.add.env.file.quickfix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RestClientBundle.message\u2026e.add.env.file.quickfix\")");
            result2 = provider.addQuickFix(string2, 2, (Function1<? super Integer, ? extends HyperlinkInfo>)((Function1)applyFilter.1.INSTANCE));
        } else if (Intrinsics.areEqual((Object)string, (Object)this.addVariableToEnvOption)) {
            String string3 = RestClientBundle.message("http.client.request.error.message.add.to.env.quickfix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"RestClientBundle.message\u2026age.add.to.env.quickfix\")");
            result2 = provider.addQuickFix(string3, 3, (Function1<? super Integer, ? extends HyperlinkInfo>)((Function1)applyFilter.2.INSTANCE));
        } else if (Intrinsics.areEqual((Object)string, (Object)this.runWithEnvOption)) {
            String string4 = RestClientBundle.message("http.client.request.error.message.run.with.env.quickfix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"RestClientBundle.message\u2026e.run.with.env.quickfix\")");
            result2 = provider.addQuickFix(string4, 4, (Function1<? super Integer, ? extends HyperlinkInfo>)((Function1)applyFilter.3.INSTANCE));
        } else {
            result2 = null;
        }
        return result2;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(HttpRequestErrorFixFilter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$QuickFixProvider;", "", "lineBegin", "", "currentLine", "", "(ILjava/lang/String;)V", "getCurrentLine", "()Ljava/lang/String;", "addQuickFix", "Lcom/intellij/execution/filters/Filter$Result;", "message", "lineOffset", "quickFixFactory", "Lkotlin/Function1;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "intellij.restClient"})
    private static final class QuickFixProvider {
        private final int lineBegin;
        @NotNull
        private final String currentLine;

        @NotNull
        public final Filter.Result addQuickFix(@Nls @NotNull String message2, int lineOffset, @NotNull Function1<? super Integer, ? extends HyperlinkInfo> quickFixFactory) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter(quickFixFactory, (String)"quickFixFactory");
            int startIndex = StringsKt.indexOf$default((CharSequence)this.currentLine, (String)message2, (int)0, (boolean)false, (int)6, null);
            return new Filter.Result(this.lineBegin + startIndex, this.lineBegin + startIndex + message2.length(), (HyperlinkInfo)quickFixFactory.invoke((Object)lineOffset));
        }

        @NotNull
        public final String getCurrentLine() {
            return this.currentLine;
        }

        public QuickFixProvider(int lineBegin, @NotNull String currentLine) {
            Intrinsics.checkNotNullParameter((Object)currentLine, (String)"currentLine");
            this.lineBegin = lineBegin;
            this.currentLine = currentLine;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u001a\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$ConsoleClickAction;", "Lcom/intellij/execution/filters/HyperlinkInfoBase;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "navigate", "hyperlinkLocationPoint", "Lcom/intellij/ui/awt/RelativePoint;", "intellij.restClient"})
    private static abstract class ConsoleClickAction
    extends HyperlinkInfoBase {
        public abstract void execute(@NotNull Project var1, @NotNull Editor var2, int var3);

        public void navigate(@NotNull Project project, @Nullable RelativePoint hyperlinkLocationPoint) {
            Editor editor;
            block3: {
                Editor editor2;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (hyperlinkLocationPoint == null) {
                    LOG.warn("hyperlink location is null");
                    return;
                }
                EditorFactory editorFactory = EditorFactory.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
                Editor[] editorArray = editorFactory.getAllEditors();
                Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"EditorFactory.getInstance().allEditors");
                Editor[] editorArray2 = editorArray;
                boolean bl = false;
                Editor[] editorArray3 = editorArray2;
                boolean bl2 = false;
                Editor[] editorArray4 = editorArray3;
                int n = editorArray4.length;
                for (int i = 0; i < n; ++i) {
                    Editor editor3;
                    Editor it = editor3 = editorArray4[i];
                    boolean bl3 = false;
                    Editor editor4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)editor4, (String)"it");
                    if (!Intrinsics.areEqual((Object)editor4.getContentComponent(), (Object)hyperlinkLocationPoint.getOriginalComponent())) continue;
                    editor2 = editor3;
                    break block3;
                }
                editor2 = editor = null;
            }
            if (editor == null) {
                LOG.warn("Cannot find editor");
                return;
            }
            VisualPosition visualPosition = editor.xyToVisualPosition(hyperlinkLocationPoint.getOriginalPoint());
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"editor.xyToVisualPositio\u2026ationPoint.originalPoint)");
            VisualPosition visualPosition2 = visualPosition;
            LogicalPosition logicalPosition = editor.visualToLogicalPosition(visualPosition2);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"editor.visualToLogicalPosition(visualPosition)");
            LogicalPosition logicalPosition2 = logicalPosition;
            int offset = editor.logicalPositionToOffset(logicalPosition2);
            this.execute(project, editor, offset);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$CreateNewEnvFileConsoleClickAction;", "Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$ConsoleClickAction;", "lineOffset", "", "(I)V", "actionId", "", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "intellij.restClient"})
    private static final class CreateNewEnvFileConsoleClickAction
    extends ConsoleClickAction {
        private final String actionId;
        private final int lineOffset;

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(@NotNull Project project, @NotNull Editor editor, int offset) {
            void errorInfo;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            int fileInfoLineNumber = editor.getDocument().getLineNumber(offset) - this.lineOffset;
            Pair pair = Companion.getVariablePositionAndFileFromEditor(editor, fileInfoLineNumber, project);
            if (pair == null) {
                return;
            }
            Pair pair2 = pair;
            VariablePosition variablePosition = (VariablePosition)pair2.component1();
            VirtualFile virtualFile = (VirtualFile)pair2.component2();
            AnAction action = ActionManager.getInstance().getAction(this.actionId);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance(\u2026Context(editor.component)");
            DataContext dataContext2 = dataContext;
            AnActionEvent anActionEvent2 = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)new DataContext(virtualFile, (VariablePosition)errorInfo, dataContext2){
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ VariablePosition $errorInfo;
                final /* synthetic */ DataContext $dataContext;

                @Nullable
                public final Object getData(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object object = ValueKey.match((String)it).ifEq((ValueKey)LangDataKeys.VIRTUAL_FILE).then((Object)this.$virtualFile).ifEq((ValueKey)HttpClientDataKeys.ENV_VARIABLE_DEFAULT_NAME).then((Object)this.$errorInfo.getVariableName()).orNull();
                    if (object == null) {
                        object = this.$dataContext.getData(it);
                    }
                    return object;
                }
                {
                    this.$virtualFile = virtualFile;
                    this.$errorInfo = variablePosition;
                    this.$dataContext = dataContext;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent2, (String)"AnActionEvent.createFrom\u2026ntext.getData(it)\n      }");
            AnActionEvent event2 = anActionEvent2;
            action.actionPerformed(event2);
        }

        public CreateNewEnvFileConsoleClickAction(int lineOffset) {
            this.lineOffset = lineOffset;
            this.actionId = "HTTPClientNewEnvironmentFile";
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$AddToExistingEnvConsoleClickAction;", "Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$ConsoleClickAction;", "lineOffset", "", "(I)V", "addVariable", "", "project", "Lcom/intellij/openapi/project/Project;", "envName", "", "variableName", "context", "Lcom/intellij/psi/PsiFile;", "changeValue", "envObject", "Lcom/intellij/json/psi/JsonObject;", "jsonStringLiteral", "Lcom/intellij/json/psi/JsonStringLiteral;", "editor", "Lcom/intellij/openapi/editor/Editor;", "execute", "offset", "getEnvironments", "", "Companion", "intellij.restClient"})
    private static final class AddToExistingEnvConsoleClickAction
    extends ConsoleClickAction {
        private final int lineOffset;
        private static final String VARIABLE_VALUE = "value";
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(@NotNull Project project, @NotNull Editor editor, int offset) {
            void errorInfo;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            int fileInfoLineNumber = editor.getDocument().getLineNumber(offset) - this.lineOffset;
            Pair pair = Companion.getVariablePositionAndFileFromEditor(editor, fileInfoLineNumber, project);
            if (pair == null) {
                return;
            }
            Pair pair2 = pair;
            VariablePosition variablePosition = (VariablePosition)pair2.component1();
            VirtualFile virtualFile = (VirtualFile)pair2.component2();
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (psiFile == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026le(virtualFile) ?: return");
            PsiFile psiFile2 = psiFile;
            List<String> list = this.getEnvironments(project, editor, psiFile2, errorInfo.getVariableName());
            boolean bl = false;
            boolean bl2 = false;
            List<String> it = list;
            boolean bl3 = false;
            Collection collection = it;
            boolean bl4 = false;
            List<String> list2 = !collection.isEmpty() ? list : null;
            if (list2 == null) {
                return;
            }
            List<String> allEnvironments = list2;
            if (allEnvironments.size() == 1) {
                this.addVariable(project, (String)CollectionsKt.first(allEnvironments), errorInfo.getVariableName(), psiFile2);
                return;
            }
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(this, project, (VariablePosition)errorInfo, psiFile2, allEnvironments, RestClientBundle.message("rest.client.request.execute.environment.popup.header", new Object[0]), allEnvironments){
                final /* synthetic */ AddToExistingEnvConsoleClickAction this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ VariablePosition $errorInfo;
                final /* synthetic */ PsiFile $psiFile;
                final /* synthetic */ List $allEnvironments;

                @Nullable
                public PopupStep<?> onChosen(@NotNull String selectedValue, boolean finalChoice) {
                    Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                    return this.doFinalStep(new Runnable(this, selectedValue){
                        final /* synthetic */ execute.1 this$0;
                        final /* synthetic */ String $selectedValue;

                        public final void run() {
                            AddToExistingEnvConsoleClickAction.access$addVariable(this.this$0.this$0, this.this$0.$project, this.$selectedValue, this.this$0.$errorInfo.getVariableName(), this.this$0.$psiFile);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$selectedValue = string;
                        }
                    });
                }
                {
                    this.this$0 = this$0;
                    this.$project = $captured_local_variable$1;
                    this.$errorInfo = $captured_local_variable$2;
                    this.$psiFile = $captured_local_variable$3;
                    this.$allEnvironments = $captured_local_variable$4;
                    super($super_call_param$5, $super_call_param$6);
                }
            }).showInBestPositionFor(editor);
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getEnvironments(Project project, Editor editor, PsiFile context, String variableName) {
            void $this$filterTo$iv$iv;
            Collection<String> collection = HttpRequestIndex.getAllEnvironments(project, context);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"HttpRequestIndex.getAllE\u2026onments(project, context)");
            Collection<String> allEnvironments = collection;
            if (allEnvironments.isEmpty()) {
                String string = RestClientBundle.message("http.client.request.error.message.add.to.env.no.env.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026add.to.env.no.env.error\")");
                Companion.showMessage(editor, string);
                return CollectionsKt.emptyList();
            }
            Iterable $this$filter$iv = allEnvironments;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String env = (String)element$iv$iv;
                boolean bl = false;
                if (!HttpRequestIndex.getAllVariables(project, env, context).noneMatch(new Predicate<String>(project, context, variableName){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ PsiFile $context$inlined;
                    final /* synthetic */ String $variableName$inlined;
                    {
                        this.$project$inlined = project;
                        this.$context$inlined = psiFile;
                        this.$variableName$inlined = string;
                    }

                    public final boolean test(String it) {
                        return Intrinsics.areEqual((Object)it, (Object)this.$variableName$inlined);
                    }
                })) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredEnvironments = (List)destination$iv$iv;
            if (filteredEnvironments.isEmpty()) {
                String string = RestClientBundle.message("http.client.request.error.message.add.to.env.already.has.var.error", variableName);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026var.error\", variableName)");
                Companion.showMessage(editor, string);
                return CollectionsKt.emptyList();
            }
            return filteredEnvironments;
        }

        private final void addVariable(Project project, String envName, String variableName, PsiFile context) {
            JsonObject jsonObject;
            VirtualFile envFile;
            block11: {
                block10: {
                    boolean bl;
                    VirtualFile virtualFile;
                    block9: {
                        block8: {
                            Collection<VirtualFile> collection = HttpRequestIndex.getEnvironmentFiles(project, envName, context);
                            Intrinsics.checkNotNullExpressionValue(collection, (String)"HttpRequestIndex.getEnvi\u2026roject, envName, context)");
                            virtualFile = (VirtualFile)CollectionsKt.firstOrNull((Iterable)collection);
                            if (virtualFile == null) break block8;
                            VirtualFile virtualFile2 = virtualFile;
                            boolean bl2 = false;
                            bl = false;
                            VirtualFile it = virtualFile2;
                            boolean bl3 = false;
                            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(it);
                            if (!(psiFile instanceof JsonFile)) {
                                psiFile = null;
                            }
                            if ((virtualFile = (JsonFile)psiFile) != null) break block9;
                        }
                        return;
                    }
                    envFile = virtualFile;
                    jsonObject = JsonUtil.getTopLevelObject((JsonFile)envFile);
                    if (jsonObject == null) break block10;
                    JsonObject jsonObject2 = jsonObject;
                    bl = false;
                    boolean bl4 = false;
                    JsonObject it = jsonObject2;
                    boolean bl5 = false;
                    jsonObject = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)it, (String)envName, JsonObject.class);
                    if (jsonObject != null) break block11;
                }
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"JsonUtil.getTopLevelObje\u2026java) }\n        ?: return");
            JsonObject envObject = jsonObject;
            OpenFileAction.openFile((VirtualFile)envFile.getVirtualFile(), (Project)project);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
            Editor editor = fileEditorManager.getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"FileEditorManager.getIns\u2026ectedTextEditor ?: return");
            Editor editor2 = editor;
            WriteCommandAction.writeCommandAction((Project)project).withName(RestClientBundle.message("http.client.request.error.message.add.to.env.quickfix", new Object[0])).run(new ThrowableRunnable(this, project, variableName, envObject, editor2){
                final /* synthetic */ AddToExistingEnvConsoleClickAction this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $variableName;
                final /* synthetic */ JsonObject $envObject;
                final /* synthetic */ Editor $editor;

                public final void run() {
                    JsonElementGenerator jsonElementGenerator = new JsonElementGenerator(this.$project);
                    boolean bl = false;
                    boolean bl2 = false;
                    JsonElementGenerator $this$with = jsonElementGenerator;
                    boolean bl3 = false;
                    JsonStringLiteral jsonStringLiteral = $this$with.createStringLiteral("value");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonStringLiteral, (String)"createStringLiteral(VARIABLE_VALUE)");
                    JsonProperty jsonProperty = $this$with.createProperty(this.$variableName, jsonStringLiteral.getText());
                    Intrinsics.checkNotNullExpressionValue((Object)jsonProperty, (String)"createProperty(variableN\u2026ral(VARIABLE_VALUE).text)");
                    JsonProperty property = jsonProperty;
                    List list = this.$envObject.getPropertyList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"envObject.propertyList");
                    Collection collection = list;
                    boolean bl4 = false;
                    if (!collection.isEmpty()) {
                        PsiElement psiElement = $this$with.createComma();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createComma()");
                        PsiElement comma = psiElement;
                        PsiElement psiElement2 = this.$envObject.getLastChild();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"envObject.lastChild");
                        PsiElement psiElement3 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)psiElement2.getPrevSibling());
                        if (Intrinsics.areEqual((Object)(psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null), (Object)PsiTreeUtilKt.getElementType((PsiElement)comma)) ^ true) {
                            this.$envObject.addBefore(comma, this.$envObject.getLastChild());
                        }
                    }
                    PsiElement psiElement = this.$envObject.addBefore((PsiElement)property, this.$envObject.getLastChild());
                    if (psiElement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.json.psi.JsonProperty");
                    }
                    JsonProperty addedProperty = (JsonProperty)psiElement;
                    PsiDocumentManager.getInstance((Project)this.$project).doPostponedOperationsAndUnblockDocument(this.$editor.getDocument());
                    JsonValue jsonValue = addedProperty.getValue();
                    if (jsonValue == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.json.psi.JsonStringLiteral");
                    }
                    JsonStringLiteral jsonStringLiteral2 = (JsonStringLiteral)jsonValue;
                    AddToExistingEnvConsoleClickAction.access$changeValue(this.this$0, this.$envObject, jsonStringLiteral2, this.$editor);
                }
                {
                    this.this$0 = addToExistingEnvConsoleClickAction;
                    this.$project = project;
                    this.$variableName = string;
                    this.$envObject = jsonObject;
                    this.$editor = editor;
                }
            });
        }

        private final void changeValue(JsonObject envObject, JsonStringLiteral jsonStringLiteral, Editor editor) {
            TemplateBuilder templateBuilder = TemplateBuilderFactoryImpl.getInstance().createTemplateBuilder((PsiElement)envObject);
            templateBuilder.replaceElement((PsiElement)jsonStringLiteral, new TextRange(1, jsonStringLiteral.getTextLength() - 1), VARIABLE_VALUE);
            templateBuilder.run(editor, true);
        }

        public AddToExistingEnvConsoleClickAction(int lineOffset) {
            this.lineOffset = lineOffset;
        }

        public static final /* synthetic */ void access$addVariable(AddToExistingEnvConsoleClickAction $this, Project project, String envName, String variableName, PsiFile context) {
            $this.addVariable(project, envName, variableName, context);
        }

        public static final /* synthetic */ void access$changeValue(AddToExistingEnvConsoleClickAction $this, JsonObject envObject, JsonStringLiteral jsonStringLiteral, Editor editor) {
            $this.changeValue(envObject, jsonStringLiteral, editor);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$AddToExistingEnvConsoleClickAction$Companion;", "", "()V", "VARIABLE_VALUE", "", "intellij.restClient"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$RunWithEnvAction;", "Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$ConsoleClickAction;", "lineOffset", "", "(I)V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "intellij.restClient"})
    private static final class RunWithEnvAction
    extends ConsoleClickAction {
        private final int lineOffset;

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(@NotNull Project project, @NotNull Editor editor, int offset) {
            void $this$filterTo$iv$iv;
            Object it;
            Object object;
            void errorInfo;
            PsiFile psiFile;
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    int fileInfoLineNumber = editor.getDocument().getLineNumber(offset) - this.lineOffset;
                    Pair pair = Companion.getVariablePositionAndFileFromEditor(editor, fileInfoLineNumber, project);
                    if (pair == null) {
                        return;
                    }
                    Pair pair2 = pair;
                    VariablePosition variablePosition = (VariablePosition)pair2.component1();
                    VirtualFile virtualFile = (VirtualFile)pair2.component2();
                    PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (psiFile2 == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"PsiManager.getInstance(p\u2026le(virtualFile) ?: return");
                    psiFile = psiFile2;
                    Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                    if (document == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026cument(psiFile) ?: return");
                    Document document2 = document;
                    int requestOffset = document2.getLineStartOffset(errorInfo.getPosition().getDocumentLine()) + errorInfo.getPosition().getDocumentColumn();
                    object = psiFile.findElementAt(requestOffset);
                    if (object == null) break block8;
                    PsiElement psiElement = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    it = psiElement;
                    boolean bl3 = false;
                    object = (HttpRequestBlock)PsiTreeUtil.getParentOfType((PsiElement)it, HttpRequestBlock.class);
                    if (object != null) break block9;
                }
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"psiFile.findElementAt(re\u2026                ?: return");
            Object httpRequestBlock = object;
            Collection<String> collection = HttpRequestIndex.getAllEnvironments(project, psiFile);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"HttpRequestIndex.getAllE\u2026onments(project, psiFile)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String env = (String)element$iv$iv;
                boolean bl = false;
                if (!HttpRequestIndex.getAllVariables(project, env, psiFile).anyMatch(new Predicate<String>(project, psiFile, (VariablePosition)errorInfo){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ PsiFile $psiFile$inlined;
                    final /* synthetic */ VariablePosition $errorInfo$inlined;
                    {
                        this.$project$inlined = project;
                        this.$psiFile$inlined = psiFile;
                        this.$errorInfo$inlined = variablePosition;
                    }

                    public final boolean test(String it) {
                        return Intrinsics.areEqual((Object)it, (Object)this.$errorInfo$inlined.getVariableName());
                    }
                })) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List environments = (List)destination$iv$iv;
            if (environments.isEmpty()) {
                String string = RestClientBundle.message("http.client.request.error.message.run.with.env.no.env.error", errorInfo.getVariableName());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026, errorInfo.variableName)");
                Companion.showMessage(editor, string);
                return;
            }
            List<AnAction> list = HttpRequestActionsProvider.wrapToActionOrGroup(HttpRequestActionsProvider.getRunWithEnvActionsProvider(), HttpRequestExecutorExtensionFactory.getRunExtension()).provideActions(httpRequestBlock.getRequest(), environments);
            Intrinsics.checkNotNullExpressionValue(list, (String)"HttpRequestActionsProvid\u2026ck.request, environments)");
            AnAction runAction = (AnAction)CollectionsKt.first(list);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance(\u2026Context(editor.component)");
            DataContext dataContext2 = dataContext;
            AnActionEvent anActionEvent2 = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)new DataContext((HttpRequestBlock)httpRequestBlock, dataContext2){
                final /* synthetic */ HttpRequestBlock $httpRequestBlock;
                final /* synthetic */ DataContext $dataContext;

                @Nullable
                public final Object getData(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Object object = ValueKey.match((String)it).ifEq((ValueKey)LangDataKeys.PSI_ELEMENT_ARRAY).then((Object)new HttpRequest[]{this.$httpRequestBlock.getRequest()}).orNull();
                    if (object == null) {
                        object = this.$dataContext.getData(it);
                    }
                    return object;
                }
                {
                    this.$httpRequestBlock = httpRequestBlock;
                    this.$dataContext = dataContext;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent2, (String)"AnActionEvent.createFrom\u2026ntext.getData(it)\n      }");
            AnActionEvent anActionEvent3 = anActionEvent2;
            HttpRequestEnvironment.setDefaultEnvName(project, null);
            runAction.actionPerformed(anActionEvent3);
        }

        public RunWithEnvAction(int lineOffset) {
            this.lineOffset = lineOffset;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$VariablePosition;", "", "position", "Lcom/intellij/execution/filters/FileHyperlinkRawData;", "variableName", "", "(Lcom/intellij/execution/filters/FileHyperlinkRawData;Ljava/lang/String;)V", "getPosition", "()Lcom/intellij/execution/filters/FileHyperlinkRawData;", "getVariableName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.restClient"})
    private static final class VariablePosition {
        @NotNull
        private final FileHyperlinkRawData position;
        @NotNull
        private final String variableName;

        @NotNull
        public final FileHyperlinkRawData getPosition() {
            return this.position;
        }

        @NotNull
        public final String getVariableName() {
            return this.variableName;
        }

        public VariablePosition(@NotNull FileHyperlinkRawData position, @NotNull String variableName) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
            this.position = position;
            this.variableName = variableName;
        }

        @NotNull
        public final FileHyperlinkRawData component1() {
            return this.position;
        }

        @NotNull
        public final String component2() {
            return this.variableName;
        }

        @NotNull
        public final VariablePosition copy(@NotNull FileHyperlinkRawData position, @NotNull String variableName) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
            return new VariablePosition(position, variableName);
        }

        public static /* synthetic */ VariablePosition copy$default(VariablePosition variablePosition, FileHyperlinkRawData fileHyperlinkRawData, String string, int n, Object object) {
            if ((n & 1) != 0) {
                fileHyperlinkRawData = variablePosition.position;
            }
            if ((n & 2) != 0) {
                string = variablePosition.variableName;
            }
            return variablePosition.copy(fileHyperlinkRawData, string);
        }

        @NotNull
        public String toString() {
            return "VariablePosition(position=" + this.position + ", variableName=" + this.variableName + ")";
        }

        public int hashCode() {
            FileHyperlinkRawData fileHyperlinkRawData = this.position;
            String string = this.variableName;
            return (fileHyperlinkRawData != null ? fileHyperlinkRawData.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof VariablePosition)) break block3;
                    VariablePosition variablePosition = (VariablePosition)object;
                    if (!Intrinsics.areEqual((Object)this.position, (Object)variablePosition.position) || !Intrinsics.areEqual((Object)this.variableName, (Object)variablePosition.variableName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u0015\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "variableSeparator", "", "getVariablePositionAndFileFromEditor", "Lkotlin/Pair;", "Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFixFilter$VariablePosition;", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "lineNumber", "", "project", "Lcom/intellij/openapi/project/Project;", "getVariablePositionFromEditor", "showMessage", "", "message", "intellij.restClient"})
    public static final class Companion {
        private final VariablePosition getVariablePositionFromEditor(Editor editor, int lineNumber, Project project) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            String fileInfoLine = ((Object)document.getCharsSequence().subSequence(editor.getDocument().getLineStartOffset(lineNumber), editor.getDocument().getLineEndOffset(lineNumber))).toString();
            HttpRequestErrorFileFilter.ErrorInformation errorInformation = HttpRequestErrorFileFilter.Companion.getInstance(project).getErrorInformation(fileInfoLine);
            if (errorInformation == null) {
                return null;
            }
            HttpRequestErrorFileFilter.ErrorInformation errorInformation2 = errorInformation;
            String variableName = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)errorInformation2.getMessage(), (String)HttpRequestErrorFixFilter.variableSeparator, null, (int)2, null), (String)HttpRequestErrorFixFilter.variableSeparator, null, (int)2, null);
            return new VariablePosition(errorInformation2.getPosition(), variableName);
        }

        private final Pair<VariablePosition, VirtualFile> getVariablePositionAndFileFromEditor(Editor editor, int lineNumber, Project project) {
            VariablePosition variablePosition = this.getVariablePositionFromEditor(editor, lineNumber, project);
            if (variablePosition == null) {
                return null;
            }
            VariablePosition errorInfo = variablePosition;
            VirtualFile virtualFile = LocalFileFinder.findFile((String)errorInfo.getPosition().getFilePath());
            if (virtualFile == null) {
                virtualFile = TempFileSystem.getInstance().refreshAndFindFileByPath(errorInfo.getPosition().getFilePath());
            }
            if (virtualFile == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileFinder.findFile\u2026           ?: return null");
            VirtualFile virtualFile2 = virtualFile;
            return TuplesKt.to((Object)errorInfo, (Object)virtualFile2);
        }

        private final void showMessage(Editor editor, @NlsContexts.HintText String message2) {
            JComponent jComponent = HintUtil.createInformationLabel((String)message2);
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"HintUtil.createInformationLabel(message)");
            JComponent label = jComponent;
            Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.getInformationColor()).createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"JBPopupFactory.getInstan\u2026\n        .createBalloon()");
            Balloon balloon2 = balloon;
            RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
            Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"JBPopupFactory.getInstan\u2026BestPopupLocation(editor)");
            RelativePoint point = relativePoint;
            balloon2.show(point, Balloon.Position.above);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

