/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.console;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0003\u000e\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter;", "Lcom/intellij/execution/filters/AbstractFileHyperlinkFilter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "pathPatternInfo", "Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter$PathPatternInfo;", "getErrorInformation", "Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformation;", "line", "", "parse", "", "Lcom/intellij/execution/filters/FileHyperlinkRawData;", "Companion", "ErrorInformation", "PathPatternInfo", "intellij.restClient"})
public final class HttpRequestErrorFileFilter
extends AbstractFileHyperlinkFilter {
    private final PathPatternInfo pathPatternInfo;
    private static final long REG_EXP_TIMEOUT = 100L;
    private static final String BASE_DIR;
    public static final Companion Companion;

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        ErrorInformation errorInformation = this.getErrorInformation(line);
        return CollectionsKt.listOfNotNull((Object)(errorInformation != null ? errorInformation.getPosition() : null));
    }

    @Nullable
    public final ErrorInformation getErrorInformation(@NotNull String line) {
        MatchResult matcher;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        try {
            matcher = this.pathPatternInfo.getPattern().matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)100L));
            if (!((Matcher)matcher).find()) {
                return null;
            }
            matcher = ((Matcher)matcher).toMatchResult();
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        MatchResult matchResult = matcher;
        if (matchResult.group(this.pathPatternInfo.getPositionGroup()) == null) {
            return null;
        }
        int pathBegin = matchResult.start(this.pathPatternInfo.getPositionGroup());
        int pathEnd = matchResult.end(this.pathPatternInfo.getPositionGroup());
        String path = matchResult.group(this.pathPatternInfo.getPathGroup());
        Object object = matchResult.group(this.pathPatternInfo.getLineGroup());
        Integer linePosition = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? Integer.valueOf((Integer)object - 1) : null;
        Object object2 = matchResult.group(this.pathPatternInfo.getColumnGroup());
        Integer columnPosition = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? Integer.valueOf((Integer)object2 - 1) : null;
        String message2 = matchResult.group(this.pathPatternInfo.getMessageGroup());
        if (path == null || linePosition == null || columnPosition == null || message2 == null) {
            return null;
        }
        return new ErrorInformation(new FileHyperlinkRawData(path, linePosition.intValue(), columnPosition.intValue(), pathBegin, pathEnd), message2);
    }

    public HttpRequestErrorFileFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, BASE_DIR);
        this.pathPatternInfo = PathPatternInfo.Companion.createPattern();
    }

    static {
        Companion = new Companion(null);
    }

    @JvmStatic
    @NotNull
    public static final HttpRequestErrorFileFilter getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformation;", "", "position", "Lcom/intellij/execution/filters/FileHyperlinkRawData;", "message", "", "(Lcom/intellij/execution/filters/FileHyperlinkRawData;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "getPosition", "()Lcom/intellij/execution/filters/FileHyperlinkRawData;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.restClient"})
    public static final class ErrorInformation {
        @NotNull
        private final FileHyperlinkRawData position;
        @NotNull
        private final String message;

        @NotNull
        public final FileHyperlinkRawData getPosition() {
            return this.position;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public ErrorInformation(@NotNull FileHyperlinkRawData position, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            this.position = position;
            this.message = message2;
        }

        @NotNull
        public final FileHyperlinkRawData component1() {
            return this.position;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final ErrorInformation copy(@NotNull FileHyperlinkRawData position, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            return new ErrorInformation(position, message2);
        }

        public static /* synthetic */ ErrorInformation copy$default(ErrorInformation errorInformation, FileHyperlinkRawData fileHyperlinkRawData, String string, int n, Object object) {
            if ((n & 1) != 0) {
                fileHyperlinkRawData = errorInformation.position;
            }
            if ((n & 2) != 0) {
                string = errorInformation.message;
            }
            return errorInformation.copy(fileHyperlinkRawData, string);
        }

        @NotNull
        public String toString() {
            return "ErrorInformation(position=" + this.position + ", message=" + this.message + ")";
        }

        public int hashCode() {
            FileHyperlinkRawData fileHyperlinkRawData = this.position;
            String string = this.message;
            return (fileHyperlinkRawData != null ? fileHyperlinkRawData.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ErrorInformation)) break block3;
                    ErrorInformation errorInformation = (ErrorInformation)object;
                    if (!Intrinsics.areEqual((Object)this.position, (Object)errorInformation.position) || !Intrinsics.areEqual((Object)this.message, (Object)errorInformation.message)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006!"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter$PathPatternInfo;", "", "pattern", "Ljava/util/regex/Pattern;", "messageGroup", "", "positionGroup", "pathGroup", "lineGroup", "columnGroup", "(Ljava/util/regex/Pattern;IIIII)V", "getColumnGroup", "()I", "getLineGroup", "getMessageGroup", "getPathGroup", "getPattern", "()Ljava/util/regex/Pattern;", "getPositionGroup", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.restClient"})
    public static final class PathPatternInfo {
        @NotNull
        private final Pattern pattern;
        private final int messageGroup;
        private final int positionGroup;
        private final int pathGroup;
        private final int lineGroup;
        private final int columnGroup;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        public final int getMessageGroup() {
            return this.messageGroup;
        }

        public final int getPositionGroup() {
            return this.positionGroup;
        }

        public final int getPathGroup() {
            return this.pathGroup;
        }

        public final int getLineGroup() {
            return this.lineGroup;
        }

        public final int getColumnGroup() {
            return this.columnGroup;
        }

        public PathPatternInfo(@NotNull Pattern pattern, int messageGroup, int positionGroup, int pathGroup, int lineGroup, int columnGroup) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
            this.messageGroup = messageGroup;
            this.positionGroup = positionGroup;
            this.pathGroup = pathGroup;
            this.lineGroup = lineGroup;
            this.columnGroup = columnGroup;
        }

        public /* synthetic */ PathPatternInfo(Pattern pattern, int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n6 & 8) != 0) {
                n3 = n2 + 1;
            }
            if ((n6 & 0x10) != 0) {
                n4 = n2 + 3;
            }
            if ((n6 & 0x20) != 0) {
                n5 = n2 + 4;
            }
            this(pattern, n, n2, n3, n4, n5);
        }

        @NotNull
        public final Pattern component1() {
            return this.pattern;
        }

        public final int component2() {
            return this.messageGroup;
        }

        public final int component3() {
            return this.positionGroup;
        }

        public final int component4() {
            return this.pathGroup;
        }

        public final int component5() {
            return this.lineGroup;
        }

        public final int component6() {
            return this.columnGroup;
        }

        @NotNull
        public final PathPatternInfo copy(@NotNull Pattern pattern, int messageGroup, int positionGroup, int pathGroup, int lineGroup, int columnGroup) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return new PathPatternInfo(pattern, messageGroup, positionGroup, pathGroup, lineGroup, columnGroup);
        }

        public static /* synthetic */ PathPatternInfo copy$default(PathPatternInfo pathPatternInfo, Pattern pattern, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 1) != 0) {
                pattern = pathPatternInfo.pattern;
            }
            if ((n6 & 2) != 0) {
                n = pathPatternInfo.messageGroup;
            }
            if ((n6 & 4) != 0) {
                n2 = pathPatternInfo.positionGroup;
            }
            if ((n6 & 8) != 0) {
                n3 = pathPatternInfo.pathGroup;
            }
            if ((n6 & 0x10) != 0) {
                n4 = pathPatternInfo.lineGroup;
            }
            if ((n6 & 0x20) != 0) {
                n5 = pathPatternInfo.columnGroup;
            }
            return pathPatternInfo.copy(pattern, n, n2, n3, n4, n5);
        }

        @NotNull
        public String toString() {
            return "PathPatternInfo(pattern=" + this.pattern + ", messageGroup=" + this.messageGroup + ", positionGroup=" + this.positionGroup + ", pathGroup=" + this.pathGroup + ", lineGroup=" + this.lineGroup + ", columnGroup=" + this.columnGroup + ")";
        }

        public int hashCode() {
            Pattern pattern = this.pattern;
            return (((((pattern != null ? pattern.hashCode() : 0) * 31 + Integer.hashCode(this.messageGroup)) * 31 + Integer.hashCode(this.positionGroup)) * 31 + Integer.hashCode(this.pathGroup)) * 31 + Integer.hashCode(this.lineGroup)) * 31 + Integer.hashCode(this.columnGroup);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PathPatternInfo)) break block3;
                    PathPatternInfo pathPatternInfo = (PathPatternInfo)object;
                    if (!Intrinsics.areEqual((Object)this.pattern, (Object)pathPatternInfo.pattern) || this.messageGroup != pathPatternInfo.messageGroup || this.positionGroup != pathPatternInfo.positionGroup || this.pathGroup != pathPatternInfo.pathGroup || this.lineGroup != pathPatternInfo.lineGroup || this.columnGroup != pathPatternInfo.columnGroup) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter$PathPatternInfo$Companion;", "", "()V", "createPattern", "Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter$PathPatternInfo;", "intellij.restClient"})
        public static final class Companion {
            @NotNull
            public final PathPatternInfo createPattern() {
                PathPatternInfo pathPatternInfo;
                String descriptionPattern = "(.+)";
                String pathPattern = "(((\\w:)?[^:]+):(\\d+):(\\d+))";
                String string = RestClientBundle.message("http.client.request.error.message.begin", descriptionPattern, pathPattern);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026tionPattern, pathPattern)");
                String resultPattern = string;
                if (StringsKt.indexOf$default((CharSequence)resultPattern, (String)descriptionPattern, (int)0, (boolean)false, (int)6, null) < StringsKt.indexOf$default((CharSequence)resultPattern, (String)pathPattern, (int)0, (boolean)false, (int)6, null)) {
                    String string2 = resultPattern;
                    int n = 0;
                    boolean bl = false;
                    Pattern pattern = Pattern.compile(string2, n);
                    Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"java.util.regex.Pattern.compile(this, flags)");
                    pathPatternInfo = new PathPatternInfo(pattern, 1, 2, 0, 0, 0, 56, null);
                } else {
                    String string3 = resultPattern;
                    int n = 0;
                    boolean bl = false;
                    Pattern pattern = Pattern.compile(string3, n);
                    Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"java.util.regex.Pattern.compile(this, flags)");
                    pathPatternInfo = new PathPatternInfo(pattern, 6, 1, 0, 0, 0, 56, null);
                }
                return pathPatternInfo;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter$Companion;", "", "()V", "BASE_DIR", "", "REG_EXP_TIMEOUT", "", "getInstance", "Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.restClient"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final HttpRequestErrorFileFilter getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(HttpRequestErrorFileFilter.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (HttpRequestErrorFileFilter)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

