/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.environment.HttpRequestEnvironmentInputFilter;
import com.intellij.ws.http.request.run.HttpRequestHistoryManager;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HttpRequestIgnoredFileProvider
implements IgnoredFileProvider {
    public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
        if (project == null) {
            HttpRequestIgnoredFileProvider.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            HttpRequestIgnoredFileProvider.$$$reportNull$$$0(1);
        }
        return HttpRequestEnvironmentInputFilter.isPrivateEnvFile(filePath.getName()) || HttpRequestIgnoredFileProvider.isHttpRequestsDirOrInsideIt(filePath, project);
    }

    private static boolean isHttpRequestsDirOrInsideIt(@NotNull FilePath path, @NotNull Project project) {
        if (path == null) {
            HttpRequestIgnoredFileProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            HttpRequestIgnoredFileProvider.$$$reportNull$$$0(3);
        }
        String httpRequestsDirPath = (String)ReadAction.compute(() -> HttpRequestHistoryManager.getInstance(project).getLogDirectoryPath());
        return FileUtil.isAncestor((String)httpRequestsDirPath, (String)path.getPath(), (boolean)false);
    }

    @NotNull
    public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
        if (project == null) {
            HttpRequestIgnoredFileProvider.$$$reportNull$$$0(4);
        }
        LinkedHashSet<IgnoredFileBean> ignored = new LinkedHashSet<IgnoredFileBean>();
        String httpRequestsDirPath = (String)ReadAction.compute(() -> HttpRequestHistoryManager.getInstance(project).getLogDirectoryPath());
        ignored.add(IgnoredBeanFactory.ignoreUnderDirectory((String)httpRequestsDirPath, (Project)project));
        for (String privateFile : HttpRequestEnvironmentInputFilter.ENV_PRIVATE_FILE_NAMES) {
            ignored.add(IgnoredBeanFactory.withMask((String)privateFile));
        }
        Set set = ContainerUtil.unmodifiableOrEmptySet(ignored);
        if (set == null) {
            HttpRequestIgnoredFileProvider.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public String getIgnoredGroupDescription() {
        String string = RestClientBundle.message("http.request.log.ignored.files.provider.title", new Object[0]);
        if (string == null) {
            HttpRequestIgnoredFileProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/HttpRequestIgnoredFileProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpRequestIgnoredFileProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredGroupDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isHttpRequestsDirOrInsideIt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredFiles";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

