/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.cookies.CookieStorageInvalidFileException;
import com.intellij.ws.http.request.cookies.HttpRequestCookiesStorage;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestTarget;
import com.intellij.ws.http.request.psi.HttpVariable;
import com.intellij.ws.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.ws.http.request.run.HttpClientResponseHandler;
import com.intellij.ws.http.request.run.HttpRequestCompositePostProcessor;
import com.intellij.ws.http.request.run.HttpRequestConsolePostProcessor;
import com.intellij.ws.http.request.run.HttpRequestHistoryManager;
import com.intellij.ws.http.request.run.HttpRequestNotifications;
import com.intellij.ws.http.request.run.HttpRequestPostProcessor;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import com.intellij.ws.http.request.run.HttpRunRequestInfo;
import com.intellij.ws.http.request.run.console.HttpResponseConsole;
import com.intellij.ws.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.ws.http.request.run.console.HttpResponsePresentation;
import com.intellij.ws.http.request.run.console.HttpSingleResponseConsole;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientControllerImpl;
import com.intellij.ws.rest.client.RestClientFileUtil;
import com.intellij.ws.rest.client.RestClientRequest;
import com.intellij.ws.rest.client.RestClientRequestProcessor;
import com.intellij.ws.rest.client.RestClientResponse;
import com.intellij.ws.rest.client.RestClientResponseListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientExecutionController
extends RestClientControllerImpl {
    private static final Logger LOG = Logger.getInstance(HttpClientExecutionController.class);
    private static final int MAX_INPLACE_SIZE = 0x100000;
    private static final String AUTHORITY_ERROR_MESSAGE = "Illegal character in authority";
    private final Project myProject;
    private final String myRequestId;
    private final RestClientRequest myRequest;
    @NotNull
    private final SmartPsiElementPointer<? extends HttpRequest> myRequestPointer;
    private final HttpResponseConsole myConsole;
    private final HttpClientRequestProcessHandler myProcessHandler;
    private final HttpClientResponseHandler myResponseHandler;
    private final HttpRequestPostProcessor myRequestPostProcessor;
    private final Runnable myOnRequestFinished;
    private final boolean myForceShowResponseInplace;
    @Nullable
    private final String myIgnoreMessage;

    public HttpClientExecutionController(@NotNull Project project, @NotNull RestClientRequest request, @NotNull String requestId, @NotNull SmartPsiElementPointer<? extends HttpRequest> requestPointer, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console, @Nullable HttpClientResponseHandler responseHandler, @NotNull HttpRequestPostProcessor requestPostProcessor, boolean forceShowResponseInplace, @NotNull Runnable onRequestFinished, @Nullable String ignoreMessage) {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(0);
        }
        if (request == null) {
            HttpClientExecutionController.$$$reportNull$$$0(1);
        }
        if (requestId == null) {
            HttpClientExecutionController.$$$reportNull$$$0(2);
        }
        if (requestPointer == null) {
            HttpClientExecutionController.$$$reportNull$$$0(3);
        }
        if (processHandler == null) {
            HttpClientExecutionController.$$$reportNull$$$0(4);
        }
        if (console == null) {
            HttpClientExecutionController.$$$reportNull$$$0(5);
        }
        if (requestPostProcessor == null) {
            HttpClientExecutionController.$$$reportNull$$$0(6);
        }
        if (onRequestFinished == null) {
            HttpClientExecutionController.$$$reportNull$$$0(7);
        }
        super(project);
        this.myProject = project;
        this.myRequest = request;
        this.myRequestId = requestId;
        this.myRequestPointer = requestPointer;
        this.myConsole = console;
        this.myProcessHandler = processHandler;
        this.myResponseHandler = responseHandler;
        this.myRequestPostProcessor = requestPostProcessor;
        this.myOnRequestFinished = onRequestFinished;
        this.myForceShowResponseInplace = forceShowResponseInplace;
        this.myIgnoreMessage = ignoreMessage;
    }

    @NotNull
    public static HttpClientExecutionController create(@NotNull Project project, @NotNull HttpRunRequestInfo info, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console, @NotNull Runnable onRequestFinished, boolean showResponseInplace) throws HttpRequestValidationException {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(8);
        }
        if (info == null) {
            HttpClientExecutionController.$$$reportNull$$$0(9);
        }
        if (processHandler == null) {
            HttpClientExecutionController.$$$reportNull$$$0(10);
        }
        if (console == null) {
            HttpClientExecutionController.$$$reportNull$$$0(11);
        }
        if (onRequestFinished == null) {
            HttpClientExecutionController.$$$reportNull$$$0(12);
        }
        RestClientRequest request = info.getRequest();
        HttpClientExecutionController.loadCookiesFromJar(project, request);
        HttpClientExecutionController.convertCookieHeadersToBiscuits(request);
        String id = HttpClientExecutionController.toRequestId(request);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing: " + id);
        }
        HttpClientResponseHandler handler = info.getResponseHandler();
        Runnable onFinished = () -> {
            console.onRequestEnd(id);
            onRequestFinished.run();
        };
        return new HttpClientExecutionController(project, request, id, info.getRequestPointer(), processHandler, console, handler, info.getPostProcessor(), showResponseInplace, onFinished, info.getIgnoreMessage());
    }

    private static void loadCookiesFromJar(@NotNull Project project, @NotNull RestClientRequest request) {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(13);
        }
        if (request == null) {
            HttpClientExecutionController.$$$reportNull$$$0(14);
        }
        try {
            if (request.config.isSaveCookies()) {
                HttpRequestCookiesStorage.getInstance(project).saveToRequest(request);
            }
        }
        catch (CookieStorageInvalidFileException e) {
            LOG.warn("Failed loading cookies, " + e.getMessage());
        }
    }

    @NotNull
    private static String toRequestId(@NotNull RestClientRequest request) {
        if (request == null) {
            HttpClientExecutionController.$$$reportNull$$$0(15);
        }
        String string = request.getURL();
        if (string == null) {
            HttpClientExecutionController.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static void convertCookieHeadersToBiscuits(@NotNull RestClientRequest request) {
        List<String> cookieHeaders;
        if (request == null) {
            HttpClientExecutionController.$$$reportNull$$$0(17);
        }
        if ((cookieHeaders = request.getHeadersValue("Cookie")) == null || cookieHeaders.isEmpty()) {
            return;
        }
        URI uri = HttpClientExecutionController.getUrlForCookieDomain(request.urlBase);
        for (String cookieHeader : cookieHeaders) {
            for (String cookie : StringUtil.split((String)cookieHeader.trim(), (String)";")) {
                BasicClientCookie newCookie;
                String trimmedCookie = StringUtil.trimLeading((String)cookie);
                int separatorPos = trimmedCookie.indexOf(61);
                if (separatorPos == -1) {
                    newCookie = new BasicClientCookie(trimmedCookie, null);
                } else {
                    String cookieName = trimmedCookie.substring(0, separatorPos);
                    String cookieValue = trimmedCookie.substring(separatorPos + 1);
                    newCookie = new BasicClientCookie(cookieName, cookieValue);
                }
                if (uri != null) {
                    newCookie.setDomain(uri.getHost());
                    newCookie.setPath(uri.getPath());
                }
                request.addBiscuit((Cookie)newCookie);
            }
        }
        request.deleteHeader("Cookie");
    }

    @Nullable
    private static URI getUrlForCookieDomain(@Nullable String url) {
        try {
            if (StringUtil.isNotEmpty((String)url)) {
                return new URI(url);
            }
        }
        catch (URISyntaxException e) {
            LOG.warn("Cannot detect request url to set domain to cookies: " + e);
        }
        return null;
    }

    public void execute() {
        if (this.myIgnoreMessage != null) {
            this.myConsole.onRequestIgnored(this.myRequestId, this.myIgnoreMessage);
            this.myOnRequestFinished.run();
            return;
        }
        int size = this.myResponseHandler != null ? 2 : 1;
        this.myConsole.onRequestStart(this.myRequestId, size);
        final boolean saveCookies = this.myRequest.config.isSaveCookies();
        RestClientResponseListener listener = new RestClientResponseListener(){

            @Override
            public void onResponse(@Nullable String header, @NotNull String response, @Nullable String mimeType, @NotNull String status) {
                if (response == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (status == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!HttpClientExecutionController.isInterrupted(HttpClientExecutionController.this.myProcessHandler)) {
                    FileType fileType = RestClientFileUtil.findFileType(mimeType);
                    boolean inplace = response.length() < 0x100000 && HttpClientExecutionController.this.myForceShowResponseInplace;
                    HttpClientExecutionController.this.myConsole.setResponse(HttpClientExecutionController.this.myRequestId, HttpResponsePresentation.createResponse(header, response, status, inplace, saveCookies), fileType);
                }
            }

            @Override
            public void onErrorResponse(String response) {
                if (!HttpClientExecutionController.isInterrupted(HttpClientExecutionController.this.myProcessHandler)) {
                    HttpClientExecutionController.this.myConsole.setErrorResponse(HttpClientExecutionController.this.myRequestId, HttpResponsePresentation.createErrorResponse(StringUtil.notNullize((String)response)));
                }
            }

            @Override
            public void onErrorResponse(@Nullable Throwable throwable) {
                if (throwable == null || !(throwable.getCause() instanceof URISyntaxException)) {
                    this.onErrorResponse(throwable != null ? throwable.toString() : null);
                    return;
                }
                HttpVariable variable = HttpClientExecutionController.getVariableFromException(HttpClientExecutionController.this.myRequestPointer, (URISyntaxException)throwable.getCause());
                if (variable == null) {
                    this.onErrorResponse(throwable.toString());
                    return;
                }
                String variableName = variable.getName();
                LogicalPosition variablePosition = HttpClientExecutionController.findVariablePosition(variable);
                VirtualFile file2 = variable.getContainingFile().getOriginalFile().getVirtualFile();
                if (variablePosition != null && file2 != null) {
                    String message2 = RestClientBundle.message("http.client.request.error.message.description", variableName);
                    String path = String.format("%s:%d:%d", file2.getPresentableUrl(), variablePosition.line + 1, variablePosition.column + 1);
                    String response = RestClientBundle.message("http.client.request.error.message.begin", message2, path) + "\n" + RestClientBundle.message("http.client.request.error.message.quickfixes.title", new Object[0]) + "\n1. " + RestClientBundle.message("http.client.request.error.message.add.env.file.quickfix", new Object[0]) + "\n2. " + RestClientBundle.message("http.client.request.error.message.add.to.env.quickfix", new Object[0]) + "\n3. " + RestClientBundle.message("http.client.request.error.message.run.with.env.quickfix", new Object[0]);
                    this.onErrorResponse(response);
                } else {
                    this.onErrorResponse(throwable.toString());
                }
            }

            @Override
            public void onSetCookies(Collection<Cookie> cookies) {
                HttpClientExecutionController.saveCookiesToJar(HttpClientExecutionController.this.myProject, cookies);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "response";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "status";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ws/http/request/run/HttpClientExecutionController$1";
                objectArray[2] = "onResponse";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.onGoButtonClick(this.myRequest, false, listener, new RestClientRequestProcessor[0]);
    }

    @Nullable
    private static LogicalPosition findVariablePosition(@NotNull HttpVariable variable) {
        Document document;
        if (variable == null) {
            HttpClientExecutionController.$$$reportNull$$$0(18);
        }
        if ((document = PsiDocumentManager.getInstance((Project)variable.getProject()).getDocument(variable.getContainingFile().getOriginalFile())) == null) {
            return null;
        }
        int offset = variable.getTextOffset();
        int lineNumber = document.getLineNumber(offset);
        int columnNumber = offset - document.getLineStartOffset(lineNumber);
        return new LogicalPosition(lineNumber, columnNumber);
    }

    @Nullable
    private static HttpVariable getVariableFromException(@NotNull SmartPsiElementPointer<? extends HttpRequest> requestPointer, @NotNull URISyntaxException e) {
        HttpRequestTarget requestTarget;
        if (requestPointer == null) {
            HttpClientExecutionController.$$$reportNull$$$0(19);
        }
        if (e == null) {
            HttpClientExecutionController.$$$reportNull$$$0(20);
        }
        if ((requestTarget = (HttpRequestTarget)ObjectUtils.doIfNotNull((Object)((HttpRequest)requestPointer.getElement()), HttpRequest::getRequestTarget)) == null) {
            return null;
        }
        Collection variables = PsiTreeUtil.findChildrenOfType((PsiElement)requestTarget, HttpVariable.class);
        if (variables.isEmpty()) {
            return null;
        }
        int errorIndex = e.getMessage().startsWith(AUTHORITY_ERROR_MESSAGE) ? e.getInput().indexOf(123, e.getIndex()) : e.getIndex();
        String variableName = HttpClientExecutionController.getVariableNameByIndex(e.getInput(), errorIndex);
        if (variableName == null) {
            return null;
        }
        return (HttpVariable)ContainerUtil.find((Iterable)variables, httpVariable -> variableName.equals(httpVariable.getName()));
    }

    @Nullable
    private static String getVariableNameByIndex(@NotNull String url, int index) {
        if (url == null) {
            HttpClientExecutionController.$$$reportNull$$$0(21);
        }
        if (index < 0) {
            return null;
        }
        if (url.charAt(index) != '{' || !HttpClientExecutionController.isNextSymbolIs(url, index, '{')) {
            return null;
        }
        int indexOfFirstBrace = url.indexOf(125, index);
        if (indexOfFirstBrace == -1 || !HttpClientExecutionController.isNextSymbolIs(url, indexOfFirstBrace, '}')) {
            return null;
        }
        return url.substring(index + 2, indexOfFirstBrace);
    }

    private static boolean isNextSymbolIs(@NotNull String url, int index, char c) {
        if (url == null) {
            HttpClientExecutionController.$$$reportNull$$$0(22);
        }
        return index + 1 < url.length() && url.charAt(index + 1) == c;
    }

    private static void saveCookiesToJar(@NotNull Project project, Collection<Cookie> cookies) {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(23);
        }
        try {
            HttpRequestCookiesStorage.getInstance(project).setCookies(cookies);
        }
        catch (CookieStorageInvalidFileException e) {
            LOG.warn("Failed saving cookies, " + e.getMessage());
        }
    }

    @Override
    protected void addToHistory(final @NotNull Project project, @NotNull RestClientRequest request, final @Nullable RestClientResponse response) {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(24);
        }
        if (request == null) {
            HttpClientExecutionController.$$$reportNull$$$0(25);
        }
        if (HttpClientExecutionController.isInterrupted(this.myProcessHandler)) {
            return;
        }
        HttpRequestPostProcessor processor = HttpClientExecutionController.createProcessor(this.myRequestId, this.myConsole, this.myRequestPostProcessor);
        HttpRequestHistoryManager.getInstance(project).addToHistory(request, response, processor);
        if (response != null && this.myResponseHandler != null) {
            EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
            this.myProcessHandler.setPostProcessorIndicator((ProgressIndicator)progressIndicator);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(new Task.Backgroundable(project, RestClientBundle.message("rest.client.request.response.handler.execution", new Object[0]), false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    try {
                        HttpResponseOutputAdapter handlerPrinter = HttpClientExecutionController.this.myConsole.getResponseHandlerPrinter();
                        HttpResponseOutputAdapter testPrinter = HttpClientExecutionController.this.myConsole.getResponseHandlerTestPrinter();
                        HttpClientExecutionController.this.myResponseHandler.handle(project, response, handlerPrinter, testPrinter, HttpClientExecutionController.this.myConsole instanceof HttpSingleResponseConsole);
                    }
                    catch (ExecutionException e) {
                        String title = RestClientBundle.message("rest.client.cannot.execute.response.handler.failed.title", new Object[0]);
                        HttpRequestNotifications.showWarningBalloon(this.myProject, title, e.getMessage());
                    }
                    finally {
                        HttpClientExecutionController.this.myOnRequestFinished.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ws/http/request/run/HttpClientExecutionController$2", "run"));
                }
            }, (ProgressIndicator)progressIndicator);
        } else {
            this.myOnRequestFinished.run();
        }
    }

    @NotNull
    private static HttpRequestPostProcessor createProcessor(@NotNull String requestId, @NotNull HttpResponseConsole console, @NotNull HttpRequestPostProcessor processor) {
        if (requestId == null) {
            HttpClientExecutionController.$$$reportNull$$$0(26);
        }
        if (console == null) {
            HttpClientExecutionController.$$$reportNull$$$0(27);
        }
        if (processor == null) {
            HttpClientExecutionController.$$$reportNull$$$0(28);
        }
        return new HttpRequestCompositePostProcessor(processor, new HttpRequestConsolePostProcessor(requestId, console));
    }

    private static boolean isInterrupted(@NotNull ProcessHandler handler) {
        Integer code;
        if (handler == null) {
            HttpClientExecutionController.$$$reportNull$$$0(29);
        }
        return (code = handler.getExitCode()) != null && code != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestId";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPointer";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: 
            case 11: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPostProcessor";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onRequestFinished";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/HttpClientExecutionController";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpClientExecutionController";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toRequestId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadCookiesFromJar";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toRequestId";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertCookieHeadersToBiscuits";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findVariablePosition";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getVariableFromException";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getVariableNameByIndex";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isNextSymbolIs";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "saveCookiesToJar";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isInterrupted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

