/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.psi.manipulators;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.HttpRequestPsiFactory;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestBody;
import com.intellij.ws.http.request.psi.HttpRequestMessage;
import com.intellij.ws.http.request.psi.HttpRequestMessagesGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpRequestBodyBaseManipulator<T extends PsiElement>
extends AbstractElementManipulator<T> {
    public T handleContentChange(@NotNull T element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        HttpRequestMessage newMessage;
        if (element == null) {
            HttpRequestBodyBaseManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            HttpRequestBodyBaseManipulator.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)newContent)) {
            return null;
        }
        String newPath = this.getNewElementText(element, range, newContent);
        HttpRequestPsiFile file2 = HttpRequestPsiFactory.createDummyFile(element.getProject(), "http://127.0.0.1\n\n" + newPath);
        HttpRequest newRequest = HttpRequestPsiUtils.getFirstRequest((PsiFile)file2);
        if (newRequest != null && (newMessage = HttpRequestBodyBaseManipulator.getFirstMessage(newRequest)) != null) {
            return this.handleContentChange(element, newMessage);
        }
        return null;
    }

    @Nullable
    private static HttpRequestMessage getFirstMessage(@NotNull HttpRequest request) {
        HttpRequestBody body;
        if (request == null) {
            HttpRequestBodyBaseManipulator.$$$reportNull$$$0(2);
        }
        if ((body = request.getRequestBody()) instanceof HttpRequestMessagesGroup) {
            return (HttpRequestMessage)ContainerUtil.getFirstItem(((HttpRequestMessagesGroup)body).getRequestMessageList());
        }
        return null;
    }

    protected abstract T handleContentChange(@NotNull T var1, @NotNull HttpRequestMessage var2);

    @NotNull
    protected String getNewElementText(@NotNull T element, @NotNull TextRange range, @NotNull String newContent) {
        if (element == null) {
            HttpRequestBodyBaseManipulator.$$$reportNull$$$0(3);
        }
        if (range == null) {
            HttpRequestBodyBaseManipulator.$$$reportNull$$$0(4);
        }
        if (newContent == null) {
            HttpRequestBodyBaseManipulator.$$$reportNull$$$0(5);
        }
        String string = range.replace(element.getText(), newContent);
        if (string == null) {
            HttpRequestBodyBaseManipulator.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/psi/manipulators/HttpRequestBodyBaseManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/psi/manipulators/HttpRequestBodyBaseManipulator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewElementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFirstMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNewElementText";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

