/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.psi.impl;

import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.environment.HttpRequestEnvironmentIndex;
import com.intellij.ws.http.request.environment.HttpRequestEnvironmentInputFilter;
import com.intellij.ws.http.request.environment.HttpRequestIndex;
import com.intellij.ws.http.request.index.ScratchAwareFileBasedIndex;
import com.intellij.ws.http.request.microservices.endpoints.EmbeddedHttpClientEditor;
import com.intellij.ws.http.request.psi.HttpVariableBase;
import com.intellij.ws.http.request.psi.impl.HttpRequestNamedElementImpl;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpVariableBaseImpl
extends HttpRequestNamedElementImpl
implements HttpVariableBase {
    public HttpVariableBaseImpl(@NotNull ASTNode node) {
        if (node == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @NotNull
    public PsiElement getElement() {
        HttpVariableBaseImpl httpVariableBaseImpl = this;
        if (httpVariableBaseImpl == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(1);
        }
        return httpVariableBaseImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            int startOffset = identifier.getTextRange().getStartOffset() - this.getTextRange().getStartOffset();
            return new TextRange(startOffset, startOffset + identifier.getTextLength());
        }
        return new TextRange(0, this.getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length > 0 ? resolveResults[0].getElement() : null;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        return HttpVariableBaseImpl.getResolveResults(this.getProject(), this.getContainingFile(), this.getName());
    }

    public static ResolveResult @NotNull [] getResolveResults(@NotNull Project project, PsiFile containingFile, String name) {
        if (project == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(2);
        }
        if (EmbeddedHttpClientEditor.isInEmbeddedHttpClientEditor((PsiElement)containingFile)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                HttpVariableBaseImpl.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (StringUtil.isEmpty((String)name)) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                HttpVariableBaseImpl.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        GlobalSearchScope scope = HttpRequestIndex.getSearchScope(project, containingFile);
        ArrayList result2 = new ArrayList();
        String defaultEnv = HttpRequestEnvironment.getDefaultEnvName(project);
        if (StringUtil.isNotEmpty((String)defaultEnv)) {
            HttpVariableBaseImpl.addVariableDefinitions(project, name, defaultEnv, result2, scope);
        }
        ScratchAwareFileBasedIndex index = new ScratchAwareFileBasedIndex(project);
        for (String env : index.getAllKeys(HttpRequestEnvironmentIndex.INDEX_KEY)) {
            if (StringUtil.equals((CharSequence)env, (CharSequence)defaultEnv)) continue;
            HttpVariableBaseImpl.addVariableDefinitions(project, name, env, result2, scope);
        }
        ResolveResult[] resolveResultArray = !result2.isEmpty() ? result2.toArray(ResolveResult.EMPTY_ARRAY) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    public static void addVariableDefinitions(@NotNull Project project, @NotNull String name, @NotNull String env, @NotNull Collection<? super ResolveResult> result2, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(6);
        }
        if (name == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(7);
        }
        if (env == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(10);
        }
        new ScratchAwareFileBasedIndex(project).processValues(HttpRequestEnvironmentIndex.INDEX_KEY, env, scope, (file2, value) -> {
            if (value.contains(name)) {
                JsonProperty property;
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
                if (!(psiFile instanceof JsonFile)) {
                    return true;
                }
                JsonValue root = ((JsonFile)psiFile).getTopLevelValue();
                JsonObject environment = root instanceof JsonObject ? (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)((JsonObject)root), (String)env, JsonObject.class) : null;
                JsonProperty jsonProperty = property = environment != null ? environment.findProperty(name) : null;
                if (property != null) {
                    result2.add((ResolveResult)new PsiElementResolveResult((PsiElement)property));
                }
            }
            return true;
        });
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(12);
        }
        return this.setName(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException("Method bindToElement is not implemented in " + this.getClass().getName());
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            HttpVariableBaseImpl.$$$reportNull$$$0(14);
        }
        if (element instanceof JsonProperty && StringUtil.equals((CharSequence)((JsonProperty)element).getName(), (CharSequence)this.getName()) && element.isValid() && element.isPhysical()) {
            PsiFile file2 = element.getContainingFile();
            return file2 != null && HttpRequestEnvironmentInputFilter.isHttpRequestEnvFile(file2.getVirtualFile());
        }
        return false;
    }

    public PsiReference getReference() {
        if (this.getNameIdentifier() != null) {
            return this;
        }
        return null;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/psi/impl/HttpVariableBaseImpl";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/psi/impl/HttpVariableBaseImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResults";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResults";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addVariableDefinitions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

