/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpMessageBody;
import com.intellij.ws.http.request.psi.HttpRequestContentDescriptor;
import com.intellij.ws.http.request.psi.HttpRequestMessagesGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestBodyInjector
implements MultiHostInjector {
    private static final List<Class<? extends HttpRequestMessagesGroup>> INJECTION_CONTEXT = Collections.singletonList(HttpRequestMessagesGroup.class);

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(1);
        }
        if (context instanceof HttpRequestMessagesGroup) {
            Language language = this.getInjectedLanguage(context);
            if (language == null) {
                return;
            }
            List messages = ((HttpRequestMessagesGroup)context).getRequestMessageList().stream().filter(message2 -> message2 instanceof HttpMessageBody && message2.getTextLength() > 0).map(message2 -> (HttpMessageBody)message2).collect(Collectors.toList());
            if (!messages.isEmpty()) {
                MultiHostRegistrar injector = registrar.startInjecting(language);
                HttpRequestVariableSubstitutor substitutor = HttpRequestVariableSubstitutor.getDefault(context.getProject());
                for (int i = 0; i < messages.size(); ++i) {
                    HttpMessageBody message3 = (HttpMessageBody)messages.get(i);
                    String messageBody = message3.getText();
                    int lastVariableRangeEndOffset = 0;
                    for (TextRange variableRange : HttpRequestPsiUtils.collectVariablesRangesInMessageBody(messageBody)) {
                        String variableName = HttpRequestPsiUtils.getVariableNameRange(messageBody, variableRange).substring(messageBody);
                        injector.addPlace(null, substitutor.getVariableValue(variableName, variableName), (PsiLanguageInjectionHost)message3, TextRange.create((int)lastVariableRangeEndOffset, (int)variableRange.getStartOffset()));
                        lastVariableRangeEndOffset = variableRange.getEndOffset();
                    }
                    injector.addPlace(null, i == messages.size() - 1 ? null : "\n", (PsiLanguageInjectionHost)message3, TextRange.create((int)lastVariableRangeEndOffset, (int)message3.getTextLength()));
                }
                injector.doneInjecting();
            }
        }
    }

    @Nullable
    public Language getInjectedLanguage(@NotNull PsiElement context) {
        String mimeType;
        HttpRequestContentDescriptor descriptor;
        if (context == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(2);
        }
        if ((descriptor = (HttpRequestContentDescriptor)PsiTreeUtil.getParentOfType((PsiElement)context, HttpRequestContentDescriptor.class)) != null && StringUtil.isNotEmpty((String)(mimeType = descriptor.getMimeType()))) {
            if (mimeType.endsWith("+json")) {
                mimeType = "application/json";
            }
            return (Language)ContainerUtil.getFirstItem((Collection)Language.findInstancesByMimeType((String)mimeType));
        }
        return null;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends HttpRequestMessagesGroup>> list = INJECTION_CONTEXT;
        if (list == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/injection/HttpRequestBodyInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/injection/HttpRequestBodyInjector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedLanguage";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

