/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.ws.http.request.documentation.comments.HttpDocComment;
import com.intellij.ws.http.request.psi.HttpHeaderFieldValue;
import com.intellij.ws.http.request.psi.HttpMultipartField;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.http.request.psi.impl.HttpRequestPsiImplUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestFoldingBuilder
implements FoldingBuilder,
DumbAware {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        HttpRequestFoldingBuilder.collectDescriptors(node, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY);
        if (foldingDescriptorArray == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    private static void collectDescriptors(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        ASTNode[] requestBlocks;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(4);
        }
        if ((requestBlocks = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.REQUEST_BLOCK}))).length > 0) {
            for (ASTNode requestBlockNode : requestBlocks) {
                ASTNode requestNode = requestBlockNode.findChildByType(HttpRequestElementTypes.REQUEST);
                if (requestNode == null) continue;
                HttpRequestFoldingBuilder.collectMultipartRequests(requestNode, descriptors);
                HttpRequestFoldingBuilder.collectScriptPart(requestNode, descriptors);
                if (requestNode.findChildByType(HttpRequestElementTypes.METHOD) == null) continue;
                descriptors.add(new FoldingDescriptor(requestNode, requestNode.getTextRange()));
            }
        }
    }

    private static void collectMultipartRequests(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        ASTNode multipartMessageNode;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (descriptors == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(6);
        }
        if ((multipartMessageNode = node.findChildByType(HttpRequestElementTypes.MULTIPART_MESSAGE)) != null) {
            ASTNode[] multipartFields;
            for (ASTNode multipartFieldNode : multipartFields = multipartMessageNode.getChildren(TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.MULTIPART_FIELD}))) {
                ASTNode prevElement = HttpRequestFoldingBuilder.skipCommentsAndWhitespaces(multipartFieldNode);
                int startOffset = prevElement != null && prevElement.getElementType() == HttpRequestElementTypes.MESSAGE_BOUNDARY ? prevElement.getTextRange().getStartOffset() : multipartFieldNode.getTextRange().getStartOffset();
                descriptors.add(new FoldingDescriptor(multipartFieldNode, new TextRange(startOffset, multipartFieldNode.getTextRange().getEndOffset())));
            }
        }
    }

    private static void collectScriptPart(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        ASTNode responseHandlerNode;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (descriptors == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(8);
        }
        if ((responseHandlerNode = node.findChildByType(HttpRequestElementTypes.RESPONSE_HANDLER)) != null) {
            descriptors.add(new FoldingDescriptor(responseHandlerNode, responseHandlerNode.getTextRange()));
        }
    }

    @Nullable
    private static ASTNode skipCommentsAndWhitespaces(@NotNull ASTNode node) {
        ASTNode curNode;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(9);
        }
        for (curNode = node.getTreePrev(); curNode != null && (curNode.getPsi() instanceof PsiWhiteSpace || curNode.getPsi() instanceof HttpDocComment); curNode = curNode.getTreePrev()) {
        }
        return curNode;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        IElementType type;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(10);
        }
        if ((type = node.getElementType()) == HttpRequestElementTypes.REQUEST) {
            ASTNode httpMethodNode = node.findChildByType(HttpRequestElementTypes.METHOD);
            ASTNode httpRequestTargetNode = node.findChildByType(HttpRequestElementTypes.REQUEST_TARGET);
            if (httpMethodNode != null) {
                return httpMethodNode.getText() + (String)(httpRequestTargetNode != null ? " " + httpRequestTargetNode.getText() : "");
            }
        } else if (type == HttpRequestElementTypes.MULTIPART_FIELD) {
            ASTNode messagesGroupNode = node.findChildByType(HttpRequestElementTypes.REQUEST_MESSAGES_GROUP);
            String contentDispositionName = HttpRequestFoldingBuilder.getContentDispositionName(node);
            if (contentDispositionName != null) {
                if (messagesGroupNode != null) {
                    return contentDispositionName + ": " + messagesGroupNode.getText();
                }
                return contentDispositionName;
            }
            if (messagesGroupNode != null) {
                return messagesGroupNode.getText();
            }
            if (node.getFirstChildNode() != null) {
                return node.getFirstChildNode().getText();
            }
        } else if (type == HttpRequestElementTypes.RESPONSE_HANDLER) {
            return "{% ... %}";
        }
        return "...";
    }

    @Nullable
    private static String getContentDispositionName(@NotNull ASTNode node) {
        HttpHeaderFieldValue headerFieldValue;
        PsiElement psiElement;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(11);
        }
        if ((psiElement = node.getPsi()) instanceof HttpMultipartField && (headerFieldValue = HttpRequestPsiImplUtil.getMultipartFieldDescription((HttpMultipartField)node.getPsi())) != null) {
            return headerFieldValue.getHeaderFieldOption("name");
        }
        return null;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(12);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/folding/HttpRequestFoldingBuilder";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/folding/HttpRequestFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDescriptors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectMultipartRequests";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectScriptPart";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "skipCommentsAndWhitespaces";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContentDispositionName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

