/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.completion;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.ws.http.request.HttpRequestCollectionProvider;
import com.intellij.ws.http.request.HttpRequestFileType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/ws/http/request/completion/HttpRequestFilesInputFilter;", "Lcom/intellij/util/indexing/DefaultFileTypeSpecificInputFilter;", "()V", "acceptInput", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isCollectionFile", "intellij.restClient"})
public final class HttpRequestFilesInputFilter
extends DefaultFileTypeSpecificInputFilter {
    public boolean acceptInput(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return super.acceptInput(file2) && !this.isCollectionFile(file2);
    }

    private final boolean isCollectionFile(VirtualFile file2) {
        VirtualFile parentDirectory = file2.getParent();
        AtomicNullableLazyValue<VirtualFile> atomicNullableLazyValue = HttpRequestCollectionProvider.COLLECTION;
        Intrinsics.checkNotNullExpressionValue(atomicNullableLazyValue, (String)"HttpRequestCollectionProvider.COLLECTION");
        VirtualFile collectionRoot = (VirtualFile)atomicNullableLazyValue.getValue();
        return parentDirectory != null && collectionRoot != null && Intrinsics.areEqual((Object)parentDirectory.getUrl(), (Object)collectionRoot.getUrl());
    }

    public HttpRequestFilesInputFilter() {
        super(new FileType[]{(FileType)HttpRequestFileType.INSTANCE});
    }
}

