/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.codeInsight;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpDynamicVariable;
import com.intellij.ws.http.request.psi.HttpMessageBody;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ws/http/request/codeInsight/ReplacePlaceholderFix;", "Lcom/intellij/codeInspection/IntentionAndQuickFixAction;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFamilyName", "", "getName", "runTemplate", "psiElement", "Lcom/intellij/psi/PsiElement;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.restClient"})
final class ReplacePlaceholderFix
extends IntentionAndQuickFixAction {
    @NotNull
    public String getName() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        String string = RestClientBundle.message("http.request.placeholder.inspection.message.fix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RestClientBundle.message\u2026.inspection.message.fix\")");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @Nullable PsiFile file2, @Nullable Editor editor) {
        Object v6;
        HttpMessageBody messageBody;
        block7: {
            void $this$parentOfType$iv;
            void $this$parentOfType$iv2;
            PsiElement element;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (editor == null) {
                return;
            }
            if (file2 == null) {
                return;
            }
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            int offset = caretModel.getOffset();
            PsiElement psiElement = file2.findElementAt(offset);
            if (psiElement == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"file.findElementAt(offset) ?: return");
            PsiElement psiElement2 = element = psiElement;
            boolean withSelf$iv22 = true;
            boolean $i$f$parentOfType = false;
            HttpDynamicVariable dynamicVariable = (HttpDynamicVariable)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv2, HttpDynamicVariable.class, (boolean)false);
            if (dynamicVariable != null) {
                PsiElement psiElement3 = (PsiElement)dynamicVariable;
                TextRange textRange = dynamicVariable.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"dynamicVariable.textRange");
                this.runTemplate(psiElement3, new TextRange(0, textRange.getLength()), editor);
                return;
            }
            PsiElement withSelf$iv22 = element;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType2 = false;
            HttpMessageBody httpMessageBody = (HttpMessageBody)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, HttpMessageBody.class, (boolean)false);
            if (httpMessageBody == null) {
                return;
            }
            messageBody = httpMessageBody;
            List<TextRange> list = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(messageBody.getText());
            Intrinsics.checkNotNullExpressionValue(list, (String)"HttpRequestPsiUtils.coll\u2026ageBody(messageBody.text)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TextRange it = (TextRange)element$iv;
                boolean bl = false;
                if (!it.contains(offset - messageBody.getTextOffset())) continue;
                v6 = element$iv;
                break block7;
            }
            v6 = null;
        }
        TextRange textRange = v6;
        if (textRange == null) {
            return;
        }
        TextRange currentTextRange = textRange;
        this.runTemplate((PsiElement)messageBody, currentTextRange, editor);
    }

    private final void runTemplate(PsiElement psiElement, TextRange textRange, Editor editor) {
        TemplateBuilderImpl template = new TemplateBuilderImpl(psiElement);
        template.replaceElement(psiElement, textRange, "VAR", (Expression)new ConstantNode(textRange.substring(psiElement.getText())), true);
        WriteCommandAction.writeCommandAction((Project)psiElement.getProject()).withName(RestClientBundle.message("http.request.placeholder.inspection.message.fix", new Object[0])).run(new ThrowableRunnable(template, editor){
            final /* synthetic */ TemplateBuilderImpl $template;
            final /* synthetic */ Editor $editor;

            public final void run() {
                this.$template.run(this.$editor, true);
            }
            {
                this.$template = templateBuilderImpl;
                this.$editor = editor;
            }
        });
    }
}

