/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.psi.HttpDynamicVariable;
import com.intellij.ws.http.request.psi.HttpRequestCompositeElement;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.http.request.psi.HttpVariable;
import com.intellij.ws.http.request.psi.HttpVariableBase;
import com.intellij.ws.http.request.run.HttpClientDynamicVariables;
import com.intellij.ws.http.request.run.HttpRequestGlobalContext;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestVariableSubstitutor {
    private static final Logger LOG = Logger.getInstance(HttpRequestVariableSubstitutor.class);
    private static final HttpRequestVariableSubstitutor EMPTY = new HttpRequestVariableSubstitutor(HttpRequestEnvironment.empty(), new HttpRequestGlobalContext());
    private final HttpRequestEnvironment myEnvironment;
    private final HttpRequestGlobalContext myGlobalContext;

    private HttpRequestVariableSubstitutor(@NotNull HttpRequestEnvironment environment, @NotNull HttpRequestGlobalContext context) {
        if (environment == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(1);
        }
        this.myEnvironment = environment;
        this.myGlobalContext = context;
    }

    @NotNull
    public static HttpRequestVariableSubstitutor getDefault(@NotNull Project project) {
        if (project == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(2);
        }
        return HttpRequestVariableSubstitutor.getDefault(project, null);
    }

    @NotNull
    public static HttpRequestVariableSubstitutor getDefault(@NotNull Project project, @Nullable PsiFile contextFile) {
        if (project == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(3);
        }
        try {
            HttpRequestEnvironment env = HttpRequestEnvironment.getDefault(project, contextFile);
            if (env != null) {
                return HttpRequestVariableSubstitutor.create(project, env);
            }
        }
        catch (HttpRequestValidationException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return HttpRequestVariableSubstitutor.empty();
    }

    @NotNull
    public static HttpRequestVariableSubstitutor create(@NotNull Project project, @NotNull HttpRequestEnvironment environment) {
        if (project == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(5);
        }
        HttpRequestGlobalContext context = HttpRequestGlobalContext.getInstance(project);
        return new HttpRequestVariableSubstitutor(environment, context);
    }

    @NotNull
    public static HttpRequestVariableSubstitutor empty() {
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = EMPTY;
        if (httpRequestVariableSubstitutor == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(6);
        }
        return httpRequestVariableSubstitutor;
    }

    @NotNull
    public String getValue(@NotNull PsiElement element) {
        if (element == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(7);
        }
        String string = this.getValue(element, (Condition<? super PsiElement>)Conditions.alwaysTrue());
        if (string == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getValue(@NotNull PsiElement element, @NotNull Condition<? super PsiElement> filter2) {
        if (element == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(9);
        }
        if (filter2 == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(10);
        }
        if (element instanceof HttpVariableBase) {
            return this.getVariableValue((HttpVariableBase)element);
        }
        if (element instanceof HttpRequestCompositeElement) {
            StringBuilder builder = new StringBuilder();
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof HttpVariableBase) {
                    builder.append(this.getVariableValue((HttpVariableBase)child));
                    continue;
                }
                if (!filter2.value((Object)child)) continue;
                builder.append(child.getText());
            }
            String string = builder.toString();
            if (string == null) {
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private String getVariableValue(@NotNull HttpVariableBase variable) {
        if (variable == null) {
            HttpRequestVariableSubstitutor.$$$reportNull$$$0(13);
        }
        if (variable instanceof HttpDynamicVariable) {
            String string = this.getDynamicVariableValue(variable.getName(), variable.getText());
            if (string == null) {
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (variable instanceof HttpVariable) {
            String string = this.getEnvironmentVariableValue(variable.getName(), variable.getText());
            if (string == null) {
                HttpRequestVariableSubstitutor.$$$reportNull$$$0(15);
            }
            return string;
        }
        throw new IllegalArgumentException("Unknown subclass of HttpVariableBase");
    }

    @Nullable
    @Contract(value="_,!null->!null")
    public String getDynamicVariableValue(@Nullable String name, @Nullable String defaultValue) {
        String result2;
        if (StringUtil.isNotEmpty((String)name) && (result2 = HttpClientDynamicVariables.get(name)) != null) {
            return result2;
        }
        return defaultValue;
    }

    @Nullable
    @Contract(value="_,!null->!null")
    public String getEnvironmentVariableValue(@Nullable String name, @Nullable String defaultValue) {
        if (StringUtil.isNotEmpty((String)name)) {
            String global = this.myGlobalContext.getValue(name);
            if (global != null) {
                return global;
            }
            String envVariable = this.myEnvironment.getVariableValue(StringUtil.notNullize((String)name));
            if (envVariable != null) {
                return envVariable;
            }
        }
        return defaultValue;
    }

    @Nullable
    @Contract(value="_,!null->!null")
    public String getVariableValue(@Nullable String name, @Nullable String defaultValue) {
        if (StringUtil.isNotEmpty((String)name)) {
            if (name.startsWith(HttpRequestElementTypes.DYNAMIC_SIGN.toString())) {
                return this.getDynamicVariableValue(name.substring(HttpRequestElementTypes.DYNAMIC_SIGN.toString().length()).trim(), defaultValue);
            }
            return this.getEnvironmentVariableValue(name, defaultValue);
        }
        return defaultValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/HttpRequestVariableSubstitutor";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/HttpRequestVariableSubstitutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefault";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVariableValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

