/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.ws.http.request.documentation.comments.HttpDocComment;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.http.request.psi.HttpRequestTokenType;
import com.intellij.ws.http.request.psi.HttpRequestTokenTypeSets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestPsiUtils {
    private static final HttpRequestBlock[] EMPTY = new HttpRequestBlock[0];

    private HttpRequestPsiUtils() {
    }

    public static HttpRequestBlock @NotNull [] getRequestBlocks(@NotNull PsiFile file2) {
        HttpRequestBlock[] blocks;
        if (file2 == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(0);
        }
        HttpRequestBlock[] httpRequestBlockArray = (blocks = (HttpRequestBlock[])PsiTreeUtil.getChildrenOfType((PsiElement)file2, HttpRequestBlock.class)) == null ? EMPTY : blocks;
        if (httpRequestBlockArray == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(1);
        }
        return httpRequestBlockArray;
    }

    @Nullable
    public static HttpRequest getFirstRequest(@NotNull PsiFile file2) {
        HttpRequestBlock[] blocks;
        if (file2 == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(2);
        }
        if ((blocks = HttpRequestPsiUtils.getRequestBlocks(file2)).length == 0) {
            return null;
        }
        return blocks[0].getRequest();
    }

    @NotNull
    public static TextRange getRequestsRange(@NotNull HttpRequestBlock first, @NotNull HttpRequestBlock last) {
        int nextOffset;
        if (first == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(3);
        }
        if (last == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(4);
        }
        int end = (nextOffset = HttpRequestPsiUtils.getNextSeparatorStartOffset(last)) != -1 ? nextOffset : last.getTextRange().getEndOffset();
        return new TextRange(first.getTextRange().getStartOffset(), end);
    }

    public static int getNextSeparatorStartOffset(@NotNull HttpRequestBlock block) {
        PsiElement next;
        if (block == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(5);
        }
        if ((next = HttpRequestPsiUtils.getNextSiblingByType((PsiElement)block, HttpRequestElementTypes.REQUEST_SEPARATOR, true)) == null) {
            next = HttpRequestPsiUtils.getNextSiblingByType((PsiElement)block, HttpRequestElementTypes.REQUEST_BLOCK, true);
        }
        return next != null ? next.getTextRange().getStartOffset() : -1;
    }

    @Nullable
    public static PsiElement getPrevSiblingByType(@Nullable PsiElement element, @NotNull IElementType type, boolean strict) {
        PsiElement sibling;
        if (type == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(6);
        }
        PsiElement psiElement = sibling = element != null && strict ? element.getPrevSibling() : element;
        while (sibling != null && !HttpRequestPsiUtils.isOfType(sibling, type)) {
            sibling = sibling.getPrevSibling();
        }
        return sibling;
    }

    @Nullable
    public static PsiElement getNextSiblingByType(@Nullable PsiElement element, @NotNull IElementType type, boolean strict) {
        PsiElement sibling;
        if (type == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(7);
        }
        PsiElement psiElement = sibling = element != null && strict ? element.getNextSibling() : element;
        while (sibling != null && !HttpRequestPsiUtils.isOfType(sibling, type)) {
            sibling = sibling.getNextSibling();
        }
        return sibling;
    }

    @Nullable
    public static PsiElement getProtocol(@NotNull HttpRequest request) {
        if (request == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(8);
        }
        for (PsiElement child = request.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)child) != HttpRequestElementTypes.PROTOCOL) continue;
            return child;
        }
        return null;
    }

    public static boolean isOfType(@NotNull PsiElement element, @NotNull IElementType type) {
        ASTNode node;
        if (element == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(9);
        }
        if (type == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(10);
        }
        return (node = element.getNode()) != null && node.getElementType() == type;
    }

    public static boolean isOfTypes(@NotNull PsiElement element, @NotNull TokenSet types) {
        ASTNode node;
        if (element == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(11);
        }
        if (types == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(12);
        }
        return (node = element.getNode()) != null && types.contains(node.getElementType());
    }

    @Nullable
    public static PsiElement getNextSiblingIgnoreWhitespace(@Nullable PsiElement element, boolean strict) {
        PsiElement sibling;
        Object object = strict ? (element != null ? element.getNextSibling() : null) : (sibling = element);
        while (sibling instanceof PsiWhiteSpace) {
            sibling = sibling.getNextSibling();
        }
        return sibling;
    }

    @Nullable
    public static PsiElement getPrevSiblingIgnoreWhitespace(@Nullable PsiElement element) {
        PsiElement sibling = element != null ? element.getPrevSibling() : null;
        return sibling instanceof PsiWhiteSpace ? sibling.getPrevSibling() : sibling;
    }

    @Nullable
    public static HttpDocComment findDocComment(@NotNull HttpRequest request) {
        PsiElement parent;
        if (request == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(13);
        }
        if ((parent = request.getParent()) instanceof HttpRequestBlock) {
            HttpDocComment comment = (HttpDocComment)PsiTreeUtil.getPrevSiblingOfType((PsiElement)request, HttpDocComment.class);
            if (comment != null) {
                return comment;
            }
            PsiElement file2 = parent.getParent();
            if (file2 != null && request == PsiTreeUtil.findChildOfType((PsiElement)file2, HttpRequest.class)) {
                return (HttpDocComment)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parent, HttpDocComment.class);
            }
        }
        return null;
    }

    @NotNull
    public static List<TextRange> collectVariablesRangesInMessageBody(@NotNull String body) {
        if (body == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(14);
        }
        SmartList result2 = new SmartList();
        int index = 0;
        while (index < body.length()) {
            int openBraceIndex = body.indexOf("{{", index);
            int closeBraceIndex = body.indexOf("}}", openBraceIndex);
            if (openBraceIndex < 0 || closeBraceIndex < 0) break;
            TextRange range = TextRange.create((int)openBraceIndex, (int)(closeBraceIndex + 2));
            if (!range.isEmpty() && !StringUtil.isEmptyOrSpaces((String)body.substring(openBraceIndex + 2, closeBraceIndex))) {
                result2.add(range);
            }
            index = closeBraceIndex + 2;
        }
        SmartList smartList = result2;
        if (smartList == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(15);
        }
        return smartList;
    }

    @NotNull
    public static TextRange getVariableNameRange(@NotNull String messageBody, @NotNull TextRange variableRange) {
        if (messageBody == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(16);
        }
        if (variableRange == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(17);
        }
        int startIndex = StringUtil.skipWhitespaceForward((CharSequence)messageBody, (int)(variableRange.getStartOffset() + 2));
        int endIndex = StringUtil.skipWhitespaceBackward((CharSequence)messageBody, (int)(variableRange.getEndOffset() - 2));
        TextRange textRange = TextRange.create((int)startIndex, (int)endIndex);
        if (textRange == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(18);
        }
        return textRange;
    }

    @Nullable
    public static TextRange getDynamicVariableNameRange(@NotNull String messageBody, @NotNull TextRange variableRange) {
        int endIndex;
        int signIndex;
        if (messageBody == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(19);
        }
        if (variableRange == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(20);
        }
        if ((signIndex = messageBody.indexOf(HttpRequestElementTypes.DYNAMIC_SIGN.toString(), variableRange.getStartOffset())) < 0) {
            return null;
        }
        int startIndex = StringUtil.skipWhitespaceForward((CharSequence)messageBody, (int)(signIndex + HttpRequestElementTypes.DYNAMIC_SIGN.toString().length()));
        return startIndex <= (endIndex = StringUtil.skipWhitespaceBackward((CharSequence)messageBody, (int)(variableRange.getEndOffset() - 2))) ? TextRange.create((int)startIndex, (int)endIndex) : TextRange.EMPTY_RANGE;
    }

    @NotNull
    public static Set<String> supportedMethods() {
        Set set = (Set)((StreamEx)StreamEx.of((Object[])HttpRequestTokenTypeSets.METHODS.getTypes()).filter(type -> type instanceof HttpRequestTokenType)).map(it -> it.toString()).collect(Collectors.toSet());
        if (set == null) {
            HttpRequestPsiUtils.$$$reportNull$$$0(21);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 15: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 15: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/HttpRequestPsiUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBody";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/HttpRequestPsiUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestBlocks";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVariablesRangesInMessageBody";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableNameRange";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "supportedMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRequestBlocks";
                break;
            }
            case 1: 
            case 15: 
            case 18: 
            case 21: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFirstRequest";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRequestsRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNextSeparatorStartOffset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSiblingByType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNextSiblingByType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProtocol";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOfType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isOfTypes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectVariablesRangesInMessageBody";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVariableNameRange";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicVariableNameRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 15: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

