/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.ws.converters.RequestBuilder;
import com.intellij.ws.http.request.HttpHeaderFieldPreprocessor;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.documentation.comments.HttpDocComment;
import com.intellij.ws.http.request.documentation.comments.psi.HttpDocNoCookieJarTag;
import com.intellij.ws.http.request.documentation.comments.psi.HttpDocNoLogResponseTag;
import com.intellij.ws.http.request.documentation.comments.psi.HttpDocNoRedirectTag;
import com.intellij.ws.http.request.documentation.comments.psi.HttpDocUseOsCredentialsTag;
import com.intellij.ws.http.request.psi.HttpFilePath;
import com.intellij.ws.http.request.psi.HttpHeaderField;
import com.intellij.ws.http.request.psi.HttpHeaderFieldValue;
import com.intellij.ws.http.request.psi.HttpInputFile;
import com.intellij.ws.http.request.psi.HttpMessageBody;
import com.intellij.ws.http.request.psi.HttpMultipartField;
import com.intellij.ws.http.request.psi.HttpMultipartMessage;
import com.intellij.ws.http.request.psi.HttpQuery;
import com.intellij.ws.http.request.psi.HttpQueryParameter;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestBody;
import com.intellij.ws.http.request.psi.HttpRequestMessage;
import com.intellij.ws.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.ws.http.request.psi.HttpRequestTarget;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import com.intellij.ws.rest.RestClientRequestBuilder;
import com.intellij.ws.rest.client.HttpRequestConfig;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientFormBodyPart;
import com.intellij.ws.rest.client.RestClientRequest;
import java.io.File;
import java.io.IOException;
import java.util.List;
import one.util.streamex.StreamEx;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestPsiConverter {
    private static final String DEFAULT_TMP_INPUT_FILE_NAME = "http_request_input_file";
    private static final String INPUT_SIGN = "< ";
    private static final String REQUEST_SEPARATOR = "###";

    @NotNull
    public static String getSeparator() {
        return REQUEST_SEPARATOR;
    }

    @NotNull
    public static String toPsiHttpRequest(@NotNull RestClientRequest request) {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(0);
        }
        return HttpRequestPsiConverter.toPsiHttpRequest(request, null);
    }

    @NotNull
    public static String toPsiHttpRequest(@NotNull RestClientRequest request, @Nullable String responseFileName) {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(1);
        }
        return HttpRequestPsiConverter.toPsiHttpRequest(request, responseFileName, false);
    }

    @NotNull
    public static String toPsiHttpRequest(@NotNull RestClientRequest request, @Nullable String responseFileName, boolean addCookies) {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(2);
        }
        StringBuilder result2 = new StringBuilder();
        HttpRequestPsiConverter.appendDocComment(result2, request.config);
        if (request.isEmptyCredentials()) {
            result2.append("# ").append("@use-os-credentials").append("\n");
        }
        result2.append(StringUtil.notNullize((String)request.httpMethod));
        result2.append(" ");
        result2.append(request.getURL());
        if (request.parametersEnabled && !request.parameters.isEmpty()) {
            result2.append("?");
            result2.append(StringUtil.join(request.parameters, pair -> pair.getKey() + "=" + pair.getValue(), (String)"&"));
        }
        if (request.authData != null) {
            String scheme = request.authData.getScope().getScheme();
            Credentials credentials = request.authData.getAuthCredentials();
            if (StringUtil.isNotEmpty((String)scheme) && credentials instanceof UsernamePasswordCredentials) {
                result2.append("\n");
                result2.append("Authorization").append(": ");
                result2.append(StringUtil.capitalize((String)StringUtil.toLowerCase((String)scheme))).append(" ");
                UsernamePasswordCredentials userCredentials = (UsernamePasswordCredentials)credentials;
                result2.append(userCredentials.getUserName()).append(" ").append(userCredentials.getPassword());
            }
        }
        if (!request.headers.isEmpty()) {
            result2.append("\n");
            result2.append(StringUtil.join(request.headers, pair -> pair.getKey() + ": " + pair.getValue(), (String)"\n"));
        }
        if (addCookies && !request.biscuits.isEmpty()) {
            result2.append("\n");
            result2.append("Cookie: ");
            result2.append(StringUtil.join(request.biscuits, biscuit -> biscuit.getName() + "=" + biscuit.getValue(), (String)"; "));
        }
        if (request.isFileUpload && !request.formBodyPart.isEmpty()) {
            result2.append("\n\n");
            for (RestClientFormBodyPart part : request.formBodyPart) {
                result2.append("--").append(request.multipartBoundary);
                result2.append("\n").append(part.toPsiRepresentation()).append("\n");
            }
            result2.append("--").append(request.multipartBoundary).append("--");
        } else if (request.haveFileToSend && StringUtil.isNotEmpty((String)request.filesToSend)) {
            String inputFiles = StreamEx.of((Object[])request.filesToSend.split(File.pathSeparator)).map(path -> INPUT_SIGN + path).joining((CharSequence)"\n");
            result2.append("\n\n");
            result2.append(inputFiles);
        } else if (request.haveTextToSend && StringUtil.isNotEmpty((String)request.textToSend)) {
            result2.append("\n\n");
            result2.append(StringUtil.convertLineSeparators((String)request.textToSend));
        }
        if (StringUtil.isNotEmpty((String)responseFileName)) {
            result2.append("\n\n");
            result2.append("<> ").append(responseFileName);
        }
        result2.append("\n\n").append(REQUEST_SEPARATOR).append("\n\n");
        String string = result2.toString();
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void appendDocComment(@NotNull StringBuilder result2, @NotNull HttpRequestConfig config) {
        if (result2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(4);
        }
        if (config == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(5);
        }
        if (!config.myFollowRedirects) {
            result2.append("# ").append("@no-redirect").append("\n");
        }
        if (!config.myLogResponse) {
            result2.append("# ").append("@no-log").append("\n");
        }
        if (!config.mySaveCookies) {
            result2.append("# ").append("@no-cookie-jar").append("\n");
        }
    }

    @NotNull
    public static RestClientRequest toRestClientRequest(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor) throws HttpRequestValidationException {
        if (element == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(6);
        }
        if (substitutor == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(7);
        }
        return HttpRequestPsiConverter.convertFromHttpRequest(element, substitutor, new RestClientRequestBuilder());
    }

    @NotNull
    public static <T, R extends RequestBuilder.RequestFormBodyPart> T convertFromHttpRequest(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor, @NotNull RequestBuilder<T, R> requestBuilder) throws HttpRequestValidationException {
        if (element == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(8);
        }
        if (substitutor == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(9);
        }
        if (requestBuilder == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(10);
        }
        Object object = ReadAction.compute(() -> {
            boolean useOsCredentials;
            HttpQuery query;
            HttpRequestTarget target = element.getRequestTarget();
            String url = element.getHttpUrl(substitutor);
            if (StringUtil.isEmpty((String)url)) {
                throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.url.is.invalid", new Object[0]));
            }
            requestBuilder.withUrl(url);
            requestBuilder.withMethod(element.getHttpMethod());
            RequestBuilder.HttpProtocol protocol = HttpRequestPsiConverter.getProtocolValue(HttpRequestPsiUtils.getProtocol(element));
            if (protocol != null) {
                requestBuilder.withProtocol(protocol);
            }
            HttpQuery httpQuery = query = target != null ? target.getQuery() : null;
            if (query != null) {
                requestBuilder.withQueryParameters(queryBuilder -> {
                    for (HttpQueryParameter parameter : query.getQueryParameterList()) {
                        String key = parameter.getKey(substitutor);
                        String value = parameter.getValue(substitutor);
                        if (StringUtil.isNotEmpty((String)key)) {
                            queryBuilder.addQueryParameter(key, StringUtil.notNullize((String)value));
                            continue;
                        }
                        throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.query.is.invalid", parameter.getText()));
                    }
                });
            }
            for (HttpHeaderField field : element.getHeaderFieldList()) {
                String fieldName = field.getHeaderFieldName().getText();
                HttpHeaderFieldPreprocessor.create(fieldName).addHeader(requestBuilder, field, substitutor);
            }
            HttpRequestBody body = element.getRequestBody();
            if (body instanceof HttpRequestMessagesGroup) {
                List<HttpRequestMessage> messages = ((HttpRequestMessagesGroup)body).getRequestMessageList();
                if (!messages.isEmpty()) {
                    if (messages.size() == 1 && messages.get(0) instanceof HttpInputFile) {
                        requestBuilder.withFileToSend(HttpRequestPsiConverter.getFileToSend((HttpInputFile)messages.get(0), substitutor));
                    } else {
                        requestBuilder.withTextToSend(HttpRequestPsiConverter.getTextToSend(element.getContainingFile(), messages, substitutor));
                    }
                }
            } else if (body instanceof HttpMultipartMessage) {
                requestBuilder.withMultipartBody(HttpRequestPsiConverter.getMultipartBoundary(element), multipartBodyBuilder -> {
                    List<HttpMultipartField> fields = ((HttpMultipartMessage)body).getMultipartFieldList();
                    for (int i = 0; i < fields.size(); ++i) {
                        HttpMultipartField field = fields.get(i);
                        Object bodyPart = HttpRequestPsiConverter.newBodyPartBuilder(field, substitutor, i, multipartBodyBuilder);
                        for (HttpHeaderField header : field.getHeaderFieldList()) {
                            bodyPart.addHeader(header.getName(), header.getValue(substitutor));
                        }
                        multipartBodyBuilder.addFormBodyPart(bodyPart);
                    }
                });
            }
            HttpDocComment docComment = HttpRequestPsiUtils.findDocComment(element);
            requestBuilder.withConfig(HttpRequestPsiConverter.toRequestConfig(docComment));
            boolean bl = useOsCredentials = docComment != null && docComment.getTags().stream().anyMatch(tag -> tag instanceof HttpDocUseOsCredentialsTag);
            if (useOsCredentials) {
                requestBuilder.withEmptyCredentials();
            }
            return requestBuilder.build();
        });
        if (object == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(11);
        }
        return (T)object;
    }

    @NotNull
    private static HttpRequestConfig toRequestConfig(@Nullable HttpDocComment docComment) {
        boolean followRedirects = docComment == null || docComment.getTags().stream().noneMatch(tag -> tag instanceof HttpDocNoRedirectTag);
        boolean logResponse = docComment == null || docComment.getTags().stream().noneMatch(tag -> tag instanceof HttpDocNoLogResponseTag);
        boolean saveCookies = docComment == null || docComment.getTags().stream().noneMatch(tag -> tag instanceof HttpDocNoCookieJarTag);
        return new HttpRequestConfig(followRedirects, logResponse, saveCookies);
    }

    @Nullable
    private static String getMultipartBoundary(@NotNull HttpRequest request) {
        HttpHeaderField field;
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(12);
        }
        if ((field = request.getHeaderField("Content-Type")) != null) {
            HttpHeaderFieldValue contentType = field.getHeaderFieldValue();
            return contentType != null ? contentType.getHeaderFieldOption("boundary") : null;
        }
        return null;
    }

    @NotNull
    public static <R extends RequestBuilder.RequestFormBodyPart> R newBodyPartBuilder(@NotNull HttpMultipartField field, @NotNull HttpRequestVariableSubstitutor substitutor, int index, @NotNull RequestBuilder.MultipartBodyBuilder<R> builderFactory) throws HttpRequestValidationException {
        String filename;
        HttpHeaderFieldValue description;
        String name;
        if (field == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(13);
        }
        if (substitutor == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(14);
        }
        if (builderFactory == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(15);
        }
        String string = name = (description = field.getMultipartFieldDescription()) != null ? description.getHeaderFieldOption("name") : String.valueOf(index);
        if (StringUtil.isEmpty((String)name)) {
            name = String.valueOf(index);
        }
        String string2 = filename = description != null ? description.getHeaderFieldOption("filename") : null;
        if (StringUtil.isNotEmpty((String)filename)) {
            File toUpload = HttpRequestPsiConverter.getFileToUpload(field, filename, substitutor);
            RequestBuilder.RequestFormBodyPart requestFormBodyPart = (RequestBuilder.RequestFormBodyPart)builderFactory.createPartForFile(name, filename, toUpload, field.getContentType(substitutor));
            if (requestFormBodyPart == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(16);
            }
            return (R)requestFormBodyPart;
        }
        String text = HttpRequestPsiConverter.getTextToSend(field.getContainingFile(), field.getRequestMessages(), substitutor);
        RequestBuilder.RequestFormBodyPart requestFormBodyPart = (RequestBuilder.RequestFormBodyPart)builderFactory.createPartForString(name, text, field.getContentType(substitutor));
        if (requestFormBodyPart == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(17);
        }
        return (R)requestFormBodyPart;
    }

    @NotNull
    private static File getFileToUpload(@NotNull HttpMultipartField field, @NotNull String fieldName, @Nullable HttpRequestVariableSubstitutor substitutor) throws HttpRequestValidationException {
        File file2;
        List<HttpRequestMessage> messages;
        if (field == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(18);
        }
        if (fieldName == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(19);
        }
        if ((messages = field.getRequestMessages()).size() == 1 && messages.get(0) instanceof HttpInputFile) {
            return HttpRequestPsiConverter.getFileToSend((HttpInputFile)messages.get(0), substitutor);
        }
        try {
            File file3 = FileUtil.createTempFile((String)DEFAULT_TMP_INPUT_FILE_NAME, (String)".txt");
            FileUtil.writeToFile((File)file3, (String)HttpRequestPsiConverter.getTextToSend(field.getContainingFile(), messages, substitutor));
            file2 = file3;
        }
        catch (IOException e) {
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.cannot.create.file", fieldName));
        }
        if (file2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(20);
        }
        return file2;
    }

    @NotNull
    private static String getTextToSend(@Nullable PsiFile file2, @NotNull List<HttpRequestMessage> messages, @Nullable HttpRequestVariableSubstitutor substitutor) throws HttpRequestValidationException {
        if (messages == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(21);
        }
        String lineSeparator = file2 == null || messages.size() < 2 ? LineSeparator.getSystemLineSeparator().getSeparatorString() : FileDocumentManager.getInstance().getLineSeparator(file2.getVirtualFile(), file2.getProject());
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < messages.size(); ++i) {
            HttpRequestMessage message2 = messages.get(i);
            if (message2 instanceof HttpMessageBody) {
                result2.append(HttpRequestPsiConverter.fillVariables(message2.getText(), substitutor));
            } else if (message2 instanceof HttpInputFile) {
                result2.append(HttpRequestPsiConverter.fillVariables(HttpRequestPsiConverter.loadFileContent(HttpRequestPsiConverter.resolveFileUrl((HttpInputFile)message2)), substitutor));
            }
            if (i == messages.size() - 1) continue;
            result2.append(lineSeparator);
        }
        String string = result2.toString();
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static String fillVariables(@NotNull String messageBody, @Nullable HttpRequestVariableSubstitutor substitutor) {
        List<TextRange> variablesRanges;
        if (messageBody == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(23);
        }
        if (substitutor != null && !(variablesRanges = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(messageBody)).isEmpty()) {
            StringBuilder result2 = new StringBuilder(messageBody.length());
            int lastVariableRangeEndOffset = 0;
            for (TextRange variableRange : variablesRanges) {
                result2.append(messageBody, lastVariableRangeEndOffset, variableRange.getStartOffset());
                String variableValue = substitutor.getVariableValue(HttpRequestPsiUtils.getVariableNameRange(messageBody, variableRange).substring(messageBody), variableRange.substring(messageBody));
                result2.append(variableValue);
                lastVariableRangeEndOffset = variableRange.getEndOffset();
            }
            result2.append(messageBody, lastVariableRangeEndOffset, messageBody.length());
            String string = result2.toString();
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = messageBody;
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static boolean isTextFile(@NotNull File file2) {
        if (file2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(26);
        }
        FileType fileType = !file2.isDirectory() ? FileTypeManager.getInstance().getFileTypeByFileName(file2.getName()) : null;
        return fileType != null && !fileType.isBinary();
    }

    @NotNull
    private static File getFileToSend(@NotNull HttpInputFile message2, HttpRequestVariableSubstitutor substitutor) throws HttpRequestValidationException {
        String url;
        if (message2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(27);
        }
        if (!StringUtil.equals((CharSequence)VirtualFileManager.extractProtocol((String)(url = HttpRequestPsiConverter.resolveFileUrl(message2))), (CharSequence)"jar")) {
            String path = VfsUtilCore.urlToPath((String)url);
            File file2 = new File(PathUtil.toSystemDependentName((String)path));
            if (HttpRequestPsiConverter.isTextFile(file2)) {
                String fileContent = HttpRequestPsiConverter.loadFileContent(url);
                String extension = PathUtil.getFileExtension((String)file2.getName());
                String fileContentWithVariables = HttpRequestPsiConverter.fillVariables(fileContent, substitutor);
                if (extension != null && !StringUtil.equals((CharSequence)fileContent, (CharSequence)fileContentWithVariables)) {
                    return HttpRequestPsiConverter.createTempFile(fileContentWithVariables, extension, FileUtilRt.getNameWithoutExtension((String)file2.getName()));
                }
            }
            return new File(path);
        }
        return HttpRequestPsiConverter.createTempFile(HttpRequestPsiConverter.loadFileContent(url), "txt", DEFAULT_TMP_INPUT_FILE_NAME);
    }

    @NotNull
    private static File createTempFile(@NotNull String content, @NotNull String extension, @NotNull String filename) throws HttpRequestValidationException {
        File file2;
        if (content == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(28);
        }
        if (extension == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(29);
        }
        if (filename == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(30);
        }
        try {
            File tmpFile = FileUtil.createTempFile((String)filename, (String)("." + extension));
            FileUtil.writeToFile((File)tmpFile, (String)content);
            file2 = tmpFile;
        }
        catch (IOException e) {
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.cannot.create.file.post", new Object[0]));
        }
        if (file2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(31);
        }
        return file2;
    }

    @NotNull
    private static String resolveFileUrl(@NotNull HttpInputFile message2) throws HttpRequestValidationException {
        HttpFilePath filePath;
        if (message2 == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(32);
        }
        if ((filePath = message2.getFilePath()) == null) {
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.file.path.is.empty", new Object[0]));
        }
        PsiFile file2 = FileReferenceUtil.findFile((PsiElement)filePath);
        if (file2 != null) {
            String string = file2.getVirtualFile().getUrl();
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(33);
            }
            return string;
        }
        String path = filePath.getPresentablePath();
        if (OSAgnosticPathUtil.isAbsolute((String)path)) {
            String string = VfsUtilCore.pathToUrl((String)path);
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(34);
            }
            return string;
        }
        throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.file.path.is.invalid", path));
    }

    @NotNull
    private static String loadFileContent(@NotNull String url) throws HttpRequestValidationException {
        block6: {
            String string;
            if (url == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(35);
            }
            try {
                VirtualFile file2;
                String protocol = VirtualFileManager.extractProtocol((String)url);
                if (StringUtil.equals((CharSequence)protocol, (CharSequence)"file") || (file2 = VirtualFileManager.getInstance().findFileByUrl(url)) == null) break block6;
                string = VfsUtilCore.loadText((VirtualFile)file2);
            }
            catch (IOException e) {
                throw new HttpRequestValidationException(e.getMessage());
            }
            if (string == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(36);
            }
            return string;
        }
        String string = FileUtil.loadFile((File)new File(PathUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url))));
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(37);
        }
        return string;
    }

    @Nullable
    private static RequestBuilder.HttpProtocol getProtocolValue(@Nullable PsiElement protocolElement) {
        if (protocolElement == null) {
            return null;
        }
        switch (protocolElement.getText()) {
            case "HTTP/1.0": {
                return RequestBuilder.HttpProtocol.HTTP_10;
            }
            case "HTTP/1.1": {
                return RequestBuilder.HttpProtocol.HTTP_11;
            }
            case "HTTP/2": {
                return RequestBuilder.HttpProtocol.HTTP_2;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 11: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/HttpRequestPsiConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestBuilder";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderFactory";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBody";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/HttpRequestPsiConverter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiHttpRequest";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromHttpRequest";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "newBodyPartBuilder";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToUpload";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextToSend";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "fillVariables";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFileUrl";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toPsiHttpRequest";
                break;
            }
            case 3: 
            case 11: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendDocComment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toRestClientRequest";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertFromHttpRequest";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMultipartBoundary";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "newBodyPartBuilder";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFileToUpload";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTextToSend";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fillVariables";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isTextFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFileToSend";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileUrl";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadFileContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

