/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.ws.converters.RequestBuilder;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpHeaderField;
import com.intellij.ws.http.request.psi.HttpHeaderFieldValue;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.http.request.psi.HttpVariable;
import com.intellij.ws.rest.client.auth.HttpClientAuthData;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpHeaderFieldPreprocessor {
    @NotNull
    static HttpHeaderFieldPreprocessor create(@NotNull String name) {
        if (name == null) {
            HttpHeaderFieldPreprocessor.$$$reportNull$$$0(0);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"Authorization")) {
            HttpHeaderFieldPreprocessor httpHeaderFieldPreprocessor = HttpHeaderAuthorizationPreprocessor.AUTHORIZATION;
            if (httpHeaderFieldPreprocessor == null) {
                HttpHeaderFieldPreprocessor.$$$reportNull$$$0(1);
            }
            return httpHeaderFieldPreprocessor;
        }
        HttpHeaderFieldPreprocessor httpHeaderFieldPreprocessor = HttpHeaderDefaultPreprocessor.DEFAULT;
        if (httpHeaderFieldPreprocessor == null) {
            HttpHeaderFieldPreprocessor.$$$reportNull$$$0(2);
        }
        return httpHeaderFieldPreprocessor;
    }

    public abstract void addHeader(@NotNull RequestBuilder<?, ?> var1, @NotNull HttpHeaderField var2, @NotNull HttpRequestVariableSubstitutor var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/HttpHeaderFieldPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/HttpHeaderFieldPreprocessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HttpHeaderDefaultPreprocessor
    extends HttpHeaderFieldPreprocessor {
        private static final HttpHeaderFieldPreprocessor DEFAULT = new HttpHeaderDefaultPreprocessor();

        @Override
        public void addHeader(@NotNull RequestBuilder<?, ?> requestBuilder, @NotNull HttpHeaderField field, @NotNull HttpRequestVariableSubstitutor substitutor) {
            String name;
            if (requestBuilder == null) {
                HttpHeaderDefaultPreprocessor.$$$reportNull$$$0(0);
            }
            if (field == null) {
                HttpHeaderDefaultPreprocessor.$$$reportNull$$$0(1);
            }
            if (substitutor == null) {
                HttpHeaderDefaultPreprocessor.$$$reportNull$$$0(2);
            }
            if ("Content-Length".equalsIgnoreCase(name = field.getHeaderFieldName().getText())) {
                return;
            }
            requestBuilder.withHeader(name, field.getValue(substitutor), (NullableFunction<String, String>)((NullableFunction)option -> (String)ObjectUtils.doIfNotNull((Object)field.getHeaderFieldValue(), value -> value.getHeaderFieldOption((String)option))));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "requestBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "field";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ws/http/request/HttpHeaderFieldPreprocessor$HttpHeaderDefaultPreprocessor";
            objectArray[2] = "addHeader";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HttpHeaderAuthorizationPreprocessor
    extends HttpHeaderDefaultPreprocessor {
        private static final HttpHeaderFieldPreprocessor AUTHORIZATION = new HttpHeaderAuthorizationPreprocessor();

        @Override
        public void addHeader(@NotNull RequestBuilder<?, ?> requestBuilder, @NotNull HttpHeaderField field, @NotNull HttpRequestVariableSubstitutor substitutor) {
            HttpClientAuthData data;
            if (requestBuilder == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(0);
            }
            if (field == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(1);
            }
            if (substitutor == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(2);
            }
            if ((data = this.generateAuthData(field, substitutor)) != null) {
                requestBuilder.withAuthData(data);
            } else {
                super.addHeader(requestBuilder, field, substitutor);
            }
        }

        @Nullable
        public HttpClientAuthData generateAuthData(@NotNull HttpHeaderField field, @NotNull HttpRequestVariableSubstitutor substitutor) {
            List<PsiElement> values;
            String protocol;
            HttpHeaderFieldValue value;
            if (field == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(3);
            }
            if (substitutor == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(4);
            }
            if ((value = field.getHeaderFieldValue()) != null && (StringUtil.equalsIgnoreCase((CharSequence)(protocol = HttpHeaderAuthorizationPreprocessor.getProtocol(value, substitutor)), (CharSequence)"Basic") || StringUtil.equalsIgnoreCase((CharSequence)protocol, (CharSequence)"Digest")) && (values = HttpHeaderAuthorizationPreprocessor.collectFieldValues((PsiElement)value)).size() == 3) {
                String username = substitutor.getValue(values.get(1));
                String password = substitutor.getValue(values.get(2));
                AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, protocol);
                return new HttpClientAuthData(scope, (Credentials)new UsernamePasswordCredentials(username, password));
            }
            return null;
        }

        @Nullable
        private static String getProtocol(@NotNull HttpHeaderFieldValue value, @NotNull HttpRequestVariableSubstitutor substitutor) {
            PsiElement first;
            if (value == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(5);
            }
            if (substitutor == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(6);
            }
            if ((first = HttpRequestPsiUtils.getNextSiblingIgnoreWhitespace(value.getFirstChild(), false)) != null && (HttpRequestPsiUtils.isOfType(first, HttpRequestElementTypes.FIELD_VALUE) || first instanceof HttpVariable)) {
                return substitutor.getValue(first);
            }
            return null;
        }

        @NotNull
        private static List<PsiElement> collectFieldValues(@NotNull PsiElement field) {
            if (field == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(7);
            }
            ArrayList<PsiElement> values = new ArrayList<PsiElement>();
            for (PsiElement child = field.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof PsiWhiteSpace || child instanceof PsiComment) continue;
                values.add(child);
            }
            ArrayList<PsiElement> arrayList = values;
            if (arrayList == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestBuilder";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/HttpHeaderFieldPreprocessor$HttpHeaderAuthorizationPreprocessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/HttpHeaderFieldPreprocessor$HttpHeaderAuthorizationPreprocessor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectFieldValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addHeader";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generateAuthData";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getProtocol";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collectFieldValues";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

