/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions.generation;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ws.http.request.HttpRequestPsiFactory;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.impl.HttpRequestPsiImplUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lcom/intellij/ws/actions/generation/UrlChecker;", "", "()V", "checkGeneratedUrlIsEqualsTo", "", "request", "Lcom/intellij/ws/http/request/psi/HttpRequest;", "url", "", "isValidRequest", "project", "Lcom/intellij/openapi/project/Project;", "authority", "intellij.restClient"})
final class UrlChecker {
    public static final UrlChecker INSTANCE;

    public final boolean isValidRequest(@NotNull Project project, @NotNull String url, @NotNull String authority) {
        HttpRequest request;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isReadAccessAllowed()) {
            return false;
        }
        String urlToCheck = "http://" + authority + url;
        String dummyRequest = "GET " + urlToCheck;
        HttpRequestPsiFile httpRequestPsiFile = HttpRequestPsiFactory.createDummyFile(project, dummyRequest);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)httpRequestPsiFile), (String)"HttpRequestPsiFactory.cr\u2026le(project, dummyRequest)");
        HttpRequestPsiFile file2 = httpRequestPsiFile;
        HttpRequest httpRequest = request = HttpRequestPsiUtils.getFirstRequest((PsiFile)file2);
        return (httpRequest != null ? httpRequest.getRequestTarget() : null) != null && this.checkGeneratedUrlIsEqualsTo(request, urlToCheck) && !PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)request));
    }

    public static /* synthetic */ boolean isValidRequest$default(UrlChecker urlChecker, Project project, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "/intellijRulez";
        }
        if ((n & 4) != 0) {
            string2 = "localhost:8000";
        }
        return urlChecker.isValidRequest(project, string, string2);
    }

    private final boolean checkGeneratedUrlIsEqualsTo(HttpRequest request, String url) {
        String string = HttpRequestPsiImplUtil.getHttpUrl(request, HttpRequestVariableSubstitutor.empty());
        String httpPath = string != null ? StringsKt.trimEnd((String)string, (char[])new char[]{'/'}) : null;
        return Intrinsics.areEqual((Object)httpPath, (Object)StringsKt.trimEnd((String)StringsKt.trimStart((String)url, (char[])new char[]{'/'}), (char[])new char[]{'/'}));
    }

    private UrlChecker() {
    }

    static {
        UrlChecker urlChecker;
        INSTANCE = urlChecker = new UrlChecker();
    }
}

