/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.HttpClientDataKeys;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.environment.HttpRequestIndex;
import com.intellij.ws.http.request.run.RunHttpRequestAction;
import com.intellij.ws.http.request.run.config.HttpRequestFileExecutionConfig;
import com.intellij.ws.rest.client.RestClientBundle;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HttpRequestRunFileAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(0);
        }
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Project project = e.getProject();
        if (project != null && file2 instanceof HttpRequestPsiFile) {
            HttpRequestRunFileAction.showEnvironmentsPopup(e.getProject(), e, (HttpRequestPsiFile)file2);
        }
    }

    private static void showEnvironmentsPopup(@NotNull Project project, final @NotNull AnActionEvent event2, @NotNull HttpRequestPsiFile containingFile) {
        if (project == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(1);
        }
        if (event2 == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(2);
        }
        if (containingFile == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(3);
        }
        String title = RestClientBundle.message("rest.client.request.execute.environment.popup.header", new Object[0]);
        final Map<String, AnAction> actions = HttpRequestRunFileAction.getActionsForPopup(project, containingFile);
        ListPopup runActionsPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(title, new ArrayList<String>(actions.keySet())){

            public PopupStep onChosen(String requestName, boolean finalChoice) {
                return this.doFinalStep(() -> ((AnAction)actions.get(requestName)).actionPerformed(event2));
            }
        });
        HyperlinkLabel hyperlinkLabel = (HyperlinkLabel)event2.getDataContext().getData(HttpClientDataKeys.RUN_ALL_TOOLBAR_HYPERLINK_LABEL);
        if (hyperlinkLabel != null) {
            runActionsPopup.showUnderneathOf((Component)hyperlinkLabel);
        } else {
            runActionsPopup.showInBestPositionFor(event2.getDataContext());
        }
    }

    @NotNull
    private static Map<String, AnAction> getActionsForPopup(@NotNull Project project, @NotNull HttpRequestPsiFile containingFile) {
        if (project == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(4);
        }
        if (containingFile == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(5);
        }
        HttpRequestEnvironment.clearDefaultIfInvalid(project, (PsiFile)containingFile);
        Collection<String> envs2 = HttpRequestIndex.getAllEnvironments(project, (PsiFile)containingFile);
        HttpRequestFileExecutionConfig config = new HttpRequestFileExecutionConfig(containingFile);
        String actionName = DefaultRunExecutor.getRunExecutorInstance().getActionName();
        Map actions = ContainerUtil.newHashMap((Pair)Pair.create((Object)RestClientBundle.message("rest.client.request.execute.with.default.environment", actionName), (Object)((Object)new RunHttpRequestAction.RunRequestWithDefaultEnvAction(config, null))), (Pair[])new Pair[]{Pair.create((Object)RestClientBundle.message("rest.client.request.execute.with.no.environment", actionName), (Object)((Object)new RunHttpRequestAction.RunRequestWithoutEnvAction(config, null)))});
        for (String env : envs2) {
            actions.put(RestClientBundle.message("rest.client.request.execute.with.environment", actionName, env), new RunHttpRequestAction.RunRequestWithEnvAction(config, env, null));
        }
        Map map = actions;
        if (map == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(6);
        }
        return map;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            HttpRequestRunFileAction.$$$reportNull$$$0(7);
        }
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabledAndVisible(file2 instanceof HttpRequestPsiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/actions/HttpRequestRunFileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/actions/HttpRequestRunFileAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionsForPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showEnvironmentsPopup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActionsForPopup";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

