/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ws.actions.HttpClientConvertFromCurlDialog;
import com.intellij.ws.actions.OpenInScratchFileAction;
import com.intellij.ws.converters.curl.Utils;
import com.intellij.ws.converters.curl.exceptions.CurlParseException;
import com.intellij.ws.converters.curl.parser.CurlParser;
import com.intellij.ws.http.request.HttpRequestFileType;
import com.intellij.ws.http.request.HttpRequestFileUtils;
import com.intellij.ws.http.request.HttpRequestPsiConverter;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientRequest;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ConvertCurlToHttpRequestAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ConvertCurlToHttpRequestAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ConvertCurlToHttpRequestAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        String clipboard = ConvertCurlToHttpRequestAction.getClipboardContent();
        String initial = Utils.isCurlString(clipboard) ? clipboard : "curl -i http://httpbin.org/ip";
        HttpClientConvertFromCurlDialog dialog = new HttpClientConvertFromCurlDialog(project, initial);
        if (dialog.showAndGet()) {
            try {
                String text = dialog.getCurlText();
                RestClientRequest request = new CurlParser().parseToRestClientRequest(text);
                VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
                if (selectedFiles.length > 0 && FileTypeRegistry.getInstance().isFileOfType(selectedFiles[0], (FileType)HttpRequestFileType.INSTANCE) && !HttpRequestFileUtils.isHttpRequestSystemFile(project, selectedFiles[0].getPath())) {
                    if (editor != null) {
                        Document document = editor.getDocument();
                        editor.getCaretModel().moveToOffset(0);
                        WriteCommandAction.runWriteCommandAction((Project)project, (String)RestClientBundle.message("http.request.convert.curl.ui.title", new Object[0]), null, () -> document.insertString(0, (CharSequence)(Utils.createCurlStringComment(text) + HttpRequestPsiConverter.toPsiHttpRequest(request))), (PsiFile[])new PsiFile[0]);
                    }
                } else {
                    OpenInScratchFileAction.createAndOpenScratchFile(project, request, Utils.createCurlStringComment(text));
                }
            }
            catch (CurlParseException ex) {
                Messages.showErrorDialog((Project)project, (String)ex.getMessage(), (String)RestClientBundle.message("http.request.convert.curl.to.http.request.failed.title", new Object[0]));
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ConvertCurlToHttpRequestAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null);
    }

    @NotNull
    private static String getClipboardContent() {
        block3: {
            String string;
            try {
                Transferable contents = CopyPasteManager.getInstance().getContents();
                if (contents == null) break block3;
                string = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e1) {
                LOG.warn("Failed getting clipboard content");
            }
            if (string == null) {
                ConvertCurlToHttpRequestAction.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/actions/ConvertCurlToHttpRequestAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/actions/ConvertCurlToHttpRequestAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClipboardContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

