/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.model.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javaee.model.JpsConfigFileCollectionElement;
import org.jetbrains.jps.javaee.model.JpsConfigFileMetaData;
import org.jetbrains.jps.javaee.model.JpsConfigFileMetaDataProvider;
import org.jetbrains.jps.javaee.model.JpsJavaeeModuleExtension;
import org.jetbrains.jps.javaee.model.impl.JpsConfigFileMetaDataImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;
import org.jetbrains.jps.service.JpsServiceManager;

public abstract class JpsJavaeeModuleExtensionSerializerBase<T extends JpsJavaeeModuleExtension>
extends JpsFacetConfigurationSerializer<T> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.javaee.model.impl.JpsJavaeeModuleExtensionLoaderBase");
    private static final String DESCRIPTORS_TAG = "descriptors";
    private static final String DESCRIPTOR_TAG = "deploymentDescriptor";
    private static final String URL_ATTRIBUTE = "url";
    private static final String ID_ATTRIBUTE = "name";
    private final JpsElementCollectionRole<T> myCollectionRole;

    protected JpsJavaeeModuleExtensionSerializerBase(JpsElementChildRole<T> role, JpsElementCollectionRole<T> collectionRole, String facetTypeId) {
        super(role, facetTypeId, null);
        this.myCollectionRole = collectionRole;
    }

    public T loadExtension(Element configurationElement, String facetName, JpsModule module, JpsElement parentFacet) {
        JpsJavaeeModuleExtension e = (JpsJavaeeModuleExtension)this.loadExtension(configurationElement, facetName, parentFacet, module);
        return (T)((JpsJavaeeModuleExtension)((JpsElementCollection)module.getContainer().getOrSetChild(this.myCollectionRole)).addChild((JpsElement)e));
    }

    public boolean hasExtension(JpsModule module) {
        JpsElementCollection collection = (JpsElementCollection)module.getContainer().getChild(this.myCollectionRole);
        return collection != null && !collection.getElements().isEmpty();
    }

    protected static void loadJavaeeConfigFiles(JpsConfigFileCollectionElement extension, Element facetConfigurationElement) {
        JpsJavaeeModuleExtensionSerializerBase.loadConfigFiles(extension, facetConfigurationElement.getChild(DESCRIPTORS_TAG));
    }

    public static void loadConfigFiles(JpsConfigFileCollectionElement extension, @Nullable Element descriptorsElement) {
        for (Element descriptor : JDOMUtil.getChildren((Element)descriptorsElement, (String)DESCRIPTOR_TAG)) {
            String url = descriptor.getAttributeValue(URL_ATTRIBUTE);
            String id = descriptor.getAttributeValue(ID_ATTRIBUTE);
            JpsConfigFileMetaData metaData = JpsJavaeeModuleExtensionSerializerBase.getMetaData(id);
            if (metaData == null) {
                String dirName = id.contains("web") ? "WEB-INF" : "META-INF";
                metaData = new JpsConfigFileMetaDataImpl(dirName, id);
                LOG.info("Unknown config file id: " + id + ", relative output path is set to " + dirName);
            }
            extension.addConfigFile(metaData, url);
        }
    }

    @Nullable
    private static JpsConfigFileMetaData getMetaData(String id) {
        for (JpsConfigFileMetaDataProvider provider : JpsServiceManager.getInstance().getExtensions(JpsConfigFileMetaDataProvider.class)) {
            for (Pair<String, JpsConfigFileMetaData> pair : provider.getMetaDataList()) {
                if (!((String)pair.getFirst()).equals(id)) continue;
                return (JpsConfigFileMetaData)pair.getSecond();
            }
        }
        return null;
    }
}

