/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.build.jspValidation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.jasper2.LineReader;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.artifacts.impl.ArtifactOutToSourceStorageProvider;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.javaee.JavaeeJpsBundle;
import org.jetbrains.jps.javaee.build.jspValidation.JspDependenciesStorage;
import org.jetbrains.jps.javaee.build.jspValidation.JspDependenciesStorageProvider;
import org.jetbrains.jps.javaee.build.jspValidation.JspFileDependenciesAnalyzer;
import org.jetbrains.jps.javaee.build.jspValidation.JspFileDependenciesData;
import org.jetbrains.jps.javaee.build.jspValidation.JspValidationRootDescriptor;
import org.jetbrains.jps.javaee.build.jspValidation.JspValidationTarget;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaDependencyScope;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceDependency;
import org.jetbrains.jps.service.SharedThreadPool;

public final class JasperValidator
extends TargetBuilder<JspValidationRootDescriptor, JspValidationTarget> {
    private static final Logger LOG = Logger.getInstance(JasperValidator.class);
    public static final String JASPER_VERSION_KEY = "JASPER.VERSION";
    public static final String JASPER_CLASSPATH = "JASPER.CLASSPATH";
    public static final String JASPER_REQUIRES_JAVA_COMPILER_KEY = "JASPER.REQUIRES.JAVA.COMPILER";
    @Nls
    static final String BUILDER_NAME = JavaeeJpsBundle.message("jasper.validator", new Object[0]);
    private static final LanguageLevel HIGHEST_SUPPORTED_LANGUAGE_LEVEL = LanguageLevel.JDK_12;

    public JasperValidator() {
        super(Collections.singleton(JspValidationTarget.TYPE));
    }

    public void build(@NotNull JspValidationTarget target, @NotNull DirtyFilesHolder<JspValidationRootDescriptor, JspValidationTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws IOException {
        LanguageLevel languageLevel;
        if (target == null) {
            JasperValidator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JasperValidator.$$$reportNull$$$0(1);
        }
        if (outputConsumer == null) {
            JasperValidator.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JasperValidator.$$$reportNull$$$0(3);
        }
        String jasperVersion = context.getBuilderParameter(JASPER_VERSION_KEY);
        String jasperClasspath = context.getBuilderParameter(JASPER_CLASSPATH);
        if (jasperVersion == null || jasperClasspath == null) {
            return;
        }
        boolean jasperRequiresJavaCompiler = Boolean.parseBoolean(context.getBuilderParameter(JASPER_REQUIRES_JAVA_COMPILER_KEY));
        final ArrayList<File> filesToValidate = new ArrayList<File>();
        JpsProject project = context.getProjectDescriptor().getProject();
        holder.processDirtyFiles((FileProcessor)new FileProcessor<JspValidationRootDescriptor, JspValidationTarget>(){

            public boolean apply(JspValidationTarget target, File file, JspValidationRootDescriptor root) {
                filesToValidate.add(file);
                return true;
            }
        });
        JspDependenciesStorage dependenciesStorage = (JspDependenciesStorage)context.getProjectDescriptor().dataManager.getStorage((BuildTarget)target, (StorageProvider)JspDependenciesStorageProvider.INSTANCE);
        Iterator iterator = dependenciesStorage.getKeysIterator();
        Set processed = FileCollectionFactory.createCanonicalFileSet();
        processed.addAll(filesToValidate);
        while (iterator.hasNext()) {
            List<Pair<String, Long>> state;
            String filePath = (String)iterator.next();
            File file2 = new File(filePath);
            if (!processed.add(file2) || (state = dependenciesStorage.getState(filePath)) == null) continue;
            for (Pair<String, Long> pair : state) {
                long lastModified = FSOperations.lastModified((File)new File((String)pair.first));
                if (lastModified == (Long)pair.second) continue;
                filesToValidate.add(file2);
            }
        }
        Collection files = holder.getRemovedFiles((BuildTarget)target);
        for (String file3 : files) {
            dependenciesStorage.remove(file3);
        }
        JpsJavaCompilerConfiguration compilerConfiguration = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
        JpsCompilerExcludes excludes = compilerConfiguration.getValidationExcludes();
        filesToValidate.removeIf(file -> {
            String sourcePath = JasperValidator.findSourcePath(file.getPath(), context, target.getArtifact());
            return sourcePath != null && excludes.isExcluded(new File(sourcePath));
        });
        if (filesToValidate.isEmpty()) {
            return;
        }
        LOG.debug("Validating JSP files using Jasper " + jasperVersion);
        File outputRoot = new File(context.getProjectDescriptor().dataManager.getDataPaths().getTargetDataRoot((BuildTarget)target), "jasper-output");
        FileUtil.createDirectory((File)outputRoot);
        ArrayList<String> vmOptions = new ArrayList<String>();
        vmOptions.add("-Xmx" + JpsJavaExtensionService.getInstance().getCompilerConfiguration((JpsProject)project).getCurrentCompilerOptions().MAXIMUM_HEAP_SIZE + "m");
        String debugPort = System.getProperty("intellij.jasper.validator.debug.port");
        if (debugPort != null) {
            vmOptions.add("-agentlib:jdwp=transport=dt_socket,address=" + debugPort + ",suspend=y,server=y");
        }
        List<String> classPath = JasperValidator.populateClasspath(target, jasperClasspath);
        ArrayList<String> programParameters = new ArrayList<String>();
        LanguageLevel projectLanguageLevel = JpsJavaExtensionService.getInstance().getOrCreateProjectExtension(project).getLanguageLevel();
        if (projectLanguageLevel != null) {
            if (projectLanguageLevel.compareTo((Enum)HIGHEST_SUPPORTED_LANGUAGE_LEVEL) > 0) {
                context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.WARNING, JavaeeJpsBundle.message("java.0.is.not.supported.java.1.will.be.used.instead", projectLanguageLevel.toJavaVersion(), HIGHEST_SUPPORTED_LANGUAGE_LEVEL.toJavaVersion())));
                languageLevel = HIGHEST_SUPPORTED_LANGUAGE_LEVEL;
            } else {
                languageLevel = projectLanguageLevel;
            }
        } else {
            languageLevel = HIGHEST_SUPPORTED_LANGUAGE_LEVEL;
        }
        String javaVersionOption = JasperValidator.getJavaVersionForJasper(languageLevel.toJavaVersion());
        programParameters.add("-source");
        programParameters.add(javaVersionOption);
        programParameters.add("-target");
        programParameters.add(javaVersionOption);
        programParameters.add("-d");
        programParameters.add(outputRoot.getAbsolutePath());
        programParameters.add("-mapped");
        programParameters.add("-compile");
        programParameters.add("-uriroot");
        String directoryToValidate = target.getArtifact().getOutputPath();
        programParameters.add(directoryToValidate);
        programParameters.add("-p");
        programParameters.add("jsp");
        JpsSdkReference jdkRef = project.getSdkReferencesTable().getSdkReference((JpsSdkType)JpsJavaSdkType.INSTANCE);
        if (jdkRef == null) {
            return;
        }
        JpsTypedLibrary jdk = (JpsTypedLibrary)jdkRef.resolve();
        if (jdk == null) {
            return;
        }
        JpsSdk jdkProperties = (JpsSdk)jdk.getProperties();
        JavaVersion jdkVersion = JavaVersion.tryParse((String)jdkProperties.getVersionString());
        boolean isModularJdk = jdkVersion != null && jdkVersion.feature >= 9;
        boolean useCommandLineWrapper = true;
        if (jasperRequiresJavaCompiler) {
            if (!isModularJdk) {
                classPath.add(new File(jdkProperties.getHomePath(), "lib/tools.jar").getAbsolutePath());
            } else {
                useCommandLineWrapper = false;
            }
        }
        String javaExecutable = JpsJavaSdkType.getJavaExecutable((JpsSdk)jdkProperties);
        List commandLine = ExternalProcessUtil.buildJavaCommandLine((String)javaExecutable, (String)"com.intellij.rt.jasper2.Jasper2Runner", Collections.emptyList(), classPath, vmOptions, programParameters, (boolean)useCommandLineWrapper, (boolean)false);
        if (context.getLoggingManager().getProjectBuilderLogger().isEnabled()) {
            context.getLoggingManager().getProjectBuilderLogger().logCompiledFiles(filesToValidate, BUILDER_NAME, "Validating JSP files:");
        }
        this.runJasper(commandLine, filesToValidate, directoryToValidate, target, context);
    }

    @NotNull
    private static String getJavaVersionForJasper(JavaVersion javaVersion) {
        String string = javaVersion.feature <= 8 ? "1." + javaVersion.feature : String.valueOf(javaVersion.feature);
        if (string == null) {
            JasperValidator.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void runJasper(List<String> commandLine, Collection<File> filesToValidate, String directoryToValidate, JspValidationTarget target, CompileContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting Jasper Validator: " + commandLine);
            LOG.debug(" files to process (" + filesToValidate.size() + "):");
            for (File file : filesToValidate) {
                LOG.debug(" " + file.getAbsolutePath());
            }
        }
        try {
            Process process = new ProcessBuilder(commandLine).start();
            try (OutputStream outputStream = process.getOutputStream();){
                outputStream.write(10);
                for (File file : filesToValidate) {
                    outputStream.write(file.getAbsolutePath().getBytes(StandardCharsets.UTF_8));
                    outputStream.write(10);
                }
            }
            OutputParser outputParser = new OutputParser(process, context, target, new File(directoryToValidate));
            Future parsingThreadFuture = SharedThreadPool.getInstance().submit((Runnable)outputParser);
            ParsingErrorThread parsingErrorThread = new ParsingErrorThread(process);
            Future parsingErrorThreadFuture = SharedThreadPool.getInstance().submit((Runnable)parsingErrorThread);
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                String errorText = StringUtil.notNullize((String)parsingErrorThread.getErrorText());
                LOG.info(errorText);
                String firstLine = ((String)ObjectUtils.notNull((Object)StringUtil.substringBefore((String)errorText, (String)"\n"), (Object)errorText)).trim();
                String message = JavaeeJpsBundle.message("jasper.process.finished.with.exit.code.0", exitCode);
                if (!firstLine.isEmpty()) {
                    message = message + ":\n" + firstLine;
                }
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, message));
                return;
            }
            try {
                parsingThreadFuture.get();
                parsingErrorThreadFuture.get();
            }
            catch (InterruptedException errorText) {
            }
            catch (ExecutionException errorText) {
                // empty catch block
            }
            outputParser.processErrors();
            List<JspFileDependenciesData> validated = outputParser.getSuccessfullyValidated();
            JspDependenciesStorage storage = (JspDependenciesStorage)context.getProjectDescriptor().dataManager.getStorage((BuildTarget)target, (StorageProvider)JspDependenciesStorageProvider.INSTANCE);
            for (JspFileDependenciesData data : validated) {
                ArrayList<Pair<String, Long>> state = new ArrayList<Pair<String, Long>>();
                for (File dependency : data.getDependencies()) {
                    state.add((Pair<String, Long>)Pair.create((Object)dependency.getAbsolutePath(), (Object)FSOperations.lastModified((File)dependency)));
                }
                storage.update(data.getJspFile().getAbsolutePath(), state);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, e.getMessage()));
        }
        catch (InterruptedException e) {
            LOG.debug((Throwable)e);
        }
    }

    @NotNull
    private static List<String> populateClasspath(@NotNull JspValidationTarget target, String jasperClasspath) {
        if (target == null) {
            JasperValidator.$$$reportNull$$$0(5);
        }
        ArrayList<String> classPath = new ArrayList<String>(StringUtil.split((String)jasperClasspath, (String)File.pathSeparator));
        Set modules = JpsArtifactUtil.getModulesIncludedInArtifacts(Collections.singletonList(target.getArtifact()));
        Condition condition = dep -> {
            JpsJavaDependencyExtension extension = JpsJavaExtensionService.getInstance().getDependencyExtension(dep);
            return extension != null && extension.getScope() == JpsJavaDependencyScope.PROVIDED || dep instanceof JpsModuleSourceDependency && !modules.contains(dep.getContainingModule());
        };
        Set notIncludedDependencies = modules.stream().flatMap(module -> JpsJavaExtensionService.dependencies((JpsModule)module).withoutSdk().recursivelyExportedOnly().satisfying(condition).classes().getRoots().stream()).collect(Collectors.toCollection(() -> FileCollectionFactory.createCanonicalFileSet()));
        classPath.addAll(notIncludedDependencies.stream().map(File::getAbsolutePath).sorted().collect(Collectors.toList()));
        for (JpsArtifact ear : target.getParentEars()) {
            File[] jarsInLib;
            String earOutputPath = ear.getOutputPath();
            if (earOutputPath == null || (jarsInLib = new File(earOutputPath, "lib").listFiles(FileFilters.withExtension((String)"jar"))) == null) continue;
            for (File jar : jarsInLib) {
                classPath.add(jar.getAbsolutePath());
            }
        }
        ArrayList<String> arrayList = classPath;
        if (arrayList == null) {
            JasperValidator.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public String getPresentableName() {
        String string = BUILDER_NAME;
        if (string == null) {
            JasperValidator.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static String findSourcePath(String path, CompileContext compileContext, JpsArtifact webArtifact) {
        try {
            BuildDataManager dataManager = compileContext.getProjectDescriptor().dataManager;
            ArtifactOutputToSourceMapping outSrcMapping = (ArtifactOutputToSourceMapping)dataManager.getStorage((BuildTarget)new ArtifactBuildTarget(webArtifact), (StorageProvider)ArtifactOutToSourceStorageProvider.INSTANCE);
            List sources = outSrcMapping.getState(path);
            if (sources != null && !sources.isEmpty()) {
                return ((ArtifactOutputToSourceMapping.SourcePathAndRootIndex)sources.get(0)).getPath();
            }
            return null;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/javaee/build/jspValidation/JasperValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/javaee/build/jspValidation/JasperValidator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaVersionForJasper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "populateClasspath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "populateClasspath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OutputParser
    implements Runnable {
        private final Process myProcess;
        private final File myExplodedDir;
        private File myLastProcessedFile;
        private final LineReader myLineReader;
        private final CompileContext myContext;
        private final JpsArtifact myWebArtifact;
        private final JspFileDependenciesAnalyzer myDependenciesAnalyzer;
        private final List<JspFileDependenciesData> mySuccessfullyValidated = new ArrayList<JspFileDependenciesData>();
        private final Map<File, List<CompilerMessage>> myErrorMessages = FileCollectionFactory.createCanonicalFileMap();

        private OutputParser(Process process, CompileContext compileContext, JspValidationTarget target, File explodedDir) throws IOException {
            this.myProcess = process;
            this.myContext = compileContext;
            this.myWebArtifact = target.getArtifact();
            this.myLineReader = new LineReader(process.getInputStream());
            this.myExplodedDir = explodedDir;
            File targetDataRoot = compileContext.getProjectDescriptor().dataManager.getDataPaths().getTargetDataRoot((BuildTarget)target);
            this.myDependenciesAnalyzer = new JspFileDependenciesAnalyzer(new File(targetDataRoot, "class-file-data"), compileContext.getProjectDescriptor().dataManager.getMappings());
        }

        private void processLine(String line) {
            if (line.startsWith("VALIDATING")) {
                File file = this.findFile(this.myLineReader.getNextLine());
                if (file == null) {
                    return;
                }
                this.myLastProcessedFile = file;
                this.myContext.processMessage((BuildMessage)new ProgressMessage(JavaeeJpsBundle.message("validating.jsp.files", new Object[0])));
            } else if (line.startsWith("VALIDATE-SUCCESS")) {
                String jspFilePath = this.myLineReader.getNextLine();
                String classFilePath = this.myLineReader.getNextLine();
                int numberOfIncludedFiles = Integer.parseInt(this.myLineReader.getNextLine());
                String[] pathsToIncludedFiles = new String[numberOfIncludedFiles];
                for (int i = 0; i < numberOfIncludedFiles; ++i) {
                    pathsToIncludedFiles[i] = new File(this.myExplodedDir, StringUtil.trimStart((String)this.myLineReader.getNextLine(), (String)"/")).getAbsolutePath();
                }
                File file = this.findFile(jspFilePath);
                if (file == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(jspFilePath + " file not found");
                    }
                    return;
                }
                this.processSuccessfullyValidatedFile(file, classFilePath, pathsToIncludedFiles);
                this.myLastProcessedFile = null;
            } else if (line.startsWith("VALIDATE-ERROR")) {
                File file = this.findFile(this.myLineReader.getNextLine());
                int line1 = Integer.parseInt(this.myLineReader.getNextLine());
                int column = Integer.parseInt(this.myLineReader.getNextLine());
                String errorMessage = this.parseMessageRemainder();
                if (errorMessage != null) {
                    this.rememberError(file, errorMessage, line1, column);
                }
                this.myLastProcessedFile = null;
            }
        }

        @Nullable
        @NlsSafe
        private String parseMessageRemainder() {
            String errorLine;
            StringBuilder buffer = new StringBuilder();
            while ((errorLine = this.myLineReader.getNextLine()) != null && !errorLine.startsWith("END-MESSAGE")) {
                if (buffer.length() > 0) {
                    buffer.append("\n");
                }
                buffer.append(errorLine);
            }
            String msg = buffer.toString();
            msg = msg.equals("null") ? null : StringUtil.unescapeXmlEntities((String)msg);
            return msg;
        }

        @Nullable
        private File findFile(String path) {
            if (Comparing.strEqual((String)path, null)) {
                return this.myLastProcessedFile;
            }
            File file = new File(this.myExplodedDir, FileUtil.toSystemDependentName((String)path));
            if (file.exists()) {
                return file;
            }
            file = new File(path);
            if (file.exists()) {
                return file;
            }
            try {
                file = new File(new URL(path).getFile());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (file.exists()) {
                return file;
            }
            return null;
        }

        @Override
        public void run() {
            while (true) {
                if (this.myContext.getCancelStatus().isCanceled()) {
                    this.myProcess.destroy();
                    break;
                }
                String line = this.myLineReader.getNextLine();
                if (line == null) break;
                this.processLine(line);
            }
        }

        private void processSuccessfullyValidatedFile(File jspFile, String classFilePath, String[] pathsToIncludedFiles) {
            JspFileDependenciesData data;
            try {
                data = this.myDependenciesAnalyzer.analyzeDependencies(jspFile, classFilePath, pathsToIncludedFiles);
            }
            catch (IOException e) {
                this.myContext.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.WARNING, JavaeeJpsBundle.message("failed.to.compute.dependencies", jspFile)));
                data = new JspFileDependenciesData(jspFile, Collections.emptyList(), Collections.emptyList());
            }
            this.mySuccessfullyValidated.add(data);
        }

        private void rememberError(File jspFile, @NotNull @Nls String errorMessage, int errorLine, int errorColumn) {
            String path;
            if (errorMessage == null) {
                OutputParser.$$$reportNull$$$0(0);
            }
            if (jspFile != null) {
                String outputPath = jspFile.getAbsolutePath();
                String sourcePath = JasperValidator.findSourcePath(outputPath, this.myContext, this.myWebArtifact);
                path = (String)ObjectUtils.notNull((Object)sourcePath, (Object)outputPath);
            } else {
                path = null;
            }
            CompilerMessage message = new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, errorMessage, path, -1L, -1L, -1L, (long)errorLine, (long)errorColumn);
            if (jspFile != null) {
                this.myErrorMessages.computeIfAbsent(jspFile, __ -> new ArrayList()).add(message);
            } else {
                this.myContext.processMessage((BuildMessage)message);
            }
        }

        List<JspFileDependenciesData> getSuccessfullyValidated() {
            return this.mySuccessfullyValidated;
        }

        void processErrors() {
            Set includedFiles = this.mySuccessfullyValidated.stream().flatMap(data -> data.getIncludedFiles().stream()).collect(Collectors.toCollection(() -> FileCollectionFactory.createCanonicalFileSet()));
            for (Map.Entry<File, List<CompilerMessage>> entry : this.myErrorMessages.entrySet()) {
                if (includedFiles.contains(entry.getKey())) continue;
                for (CompilerMessage message : entry.getValue()) {
                    this.myContext.processMessage((BuildMessage)message);
                }
            }
            this.mySuccessfullyValidated.removeIf(data -> includedFiles.contains(data.getJspFile()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "org/jetbrains/jps/javaee/build/jspValidation/JasperValidator$OutputParser", "rememberError"));
        }
    }

    private static final class ParsingErrorThread
    implements Runnable {
        private final InputStream myInputStream;
        private volatile String myErrorText;

        private ParsingErrorThread(Process process) {
            this.myInputStream = process.getErrorStream();
        }

        @Override
        public void run() {
            try {
                char[] chars = FileUtil.adaptiveLoadText((Reader)new InputStreamReader(this.myInputStream, StandardCharsets.UTF_8));
                this.myErrorText = new String(chars);
                LOG.debug(this.myErrorText);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private String getErrorText() {
            return this.myErrorText;
        }
    }
}

