/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.actions;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import com.intellij.util.xml.ui.actions.generate.CreateDomElementAction;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;

public abstract class CreateClassMappingAction<T extends DomElement>
extends CreateDomElementAction<T> {
    @Nullable
    private final String myBaseClass;
    private final String myTemplate;

    public CreateClassMappingAction(Class<T> contextClass, @Nullable String baseClass, String template) {
        super(contextClass);
        this.myBaseClass = baseClass;
        this.myTemplate = template;
    }

    protected DomElement createElement(T context, Editor editor, PsiFile file, Project project) {
        PsiClass selectedClass;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            PsiClass baseClass = this.getBaseClass(context, project, this.myBaseClass);
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance(project).createInheritanceClassChooser(this.getChooserTitle(), GlobalSearchScope.allScope((Project)project), baseClass, null, new ClassFilter(){

                @Override
                public boolean isAccepted(PsiClass aClass) {
                    return !aClass.isInterface() && !aClass.hasModifierProperty("abstract");
                }
            });
            chooser.showDialog();
            selectedClass = chooser.getSelected();
        } else {
            selectedClass = this.getBaseClass(context, project, this.myBaseClass == null ? "java.lang.Object" : this.myBaseClass);
        }
        if (selectedClass == null) {
            return null;
        }
        return this.createElement(context, editor, file, project, selectedClass);
    }

    @Nullable
    protected DomElement createElement(T context, Editor editor, PsiFile file, Project project, PsiClass selectedClass) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CLASS_NAME", selectedClass.getQualifiedName());
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).run(() -> DomTemplateRunner.getInstance((Project)project).runTemplate(this.createElement(context), this.myTemplate, editor, map));
        return null;
    }

    @NlsContexts.DialogTitle
    protected String getChooserTitle() {
        String text = this.getTemplatePresentation().getText();
        if (text != null && text.endsWith("...")) {
            text = StringUtil.trimEnd((String)text, (String)"...");
        }
        return JavaBundle.message("create.class.mapping.dialog.title", text);
    }

    protected abstract DomElement createElement(T var1);

    @Nullable
    protected PsiClass getBaseClass(T context, Project project, String baseClass) {
        return baseClass == null ? null : JavaPsiFacade.getInstance(project).findClass(baseClass, GlobalSearchScope.allScope((Project)project));
    }

    public boolean startInWriteAction() {
        return false;
    }
}

