/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uast;

import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UastLanguagePlugin;

public final class UastMetaLanguage
extends MetaLanguage {
    private final Set<Language> myLanguages;

    private UastMetaLanguage() {
        super("UAST");
        Collection<UastLanguagePlugin> languagePlugins = UastLanguagePlugin.Companion.getInstances();
        this.myLanguages = new HashSet<Language>(languagePlugins.size());
        this.initLanguages(languagePlugins);
        UastLanguagePlugin.Companion.getExtensionPointName().addChangeListener(() -> {
            this.myLanguages.clear();
            this.initLanguages(UastLanguagePlugin.Companion.getInstances());
        }, null);
    }

    private void initLanguages(Collection<UastLanguagePlugin> languagePlugins) {
        for (UastLanguagePlugin plugin : languagePlugins) {
            this.myLanguages.add(plugin.getLanguage());
        }
    }

    public boolean matchesLanguage(@NotNull Language language2) {
        if (language2 == null) {
            UastMetaLanguage.$$$reportNull$$$0(0);
        }
        return this.myLanguages.contains(language2);
    }

    @NotNull
    public Collection<Language> getMatchingLanguages() {
        Set<Language> set = Collections.unmodifiableSet(this.myLanguages);
        if (set == null) {
            UastMetaLanguage.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uast/UastMetaLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uast/UastMetaLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchesLanguage";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

