/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ArithmeticExceptionInfo;
import com.intellij.execution.filters.ArrayIndexOutOfBoundsExceptionInfo;
import com.intellij.execution.filters.ArrayStoreExceptionInfo;
import com.intellij.execution.filters.AssertionErrorInfo;
import com.intellij.execution.filters.ClassCastExceptionInfo;
import com.intellij.execution.filters.ExceptionLineRefiner;
import com.intellij.execution.filters.JetBrainsNotNullInstrumentationExceptionInfo;
import com.intellij.execution.filters.NegativeArraySizeExceptionInfo;
import com.intellij.execution.filters.NullPointerExceptionInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ExceptionInfo {
    @NonNls
    private static final String EXCEPTION_IN_THREAD = "Exception in thread \"";
    @NonNls
    private static final String CAUSED_BY = "Caused by: ";
    private final int myClassNameOffset;
    @NotNull
    private final String myExceptionClassName;
    @NotNull
    private final String myExceptionMessage;

    ExceptionInfo(int offset, @NotNull String exceptionClassName, @NotNull String exceptionMessage) {
        if (exceptionClassName == null) {
            ExceptionInfo.$$$reportNull$$$0(0);
        }
        if (exceptionMessage == null) {
            ExceptionInfo.$$$reportNull$$$0(1);
        }
        this.myClassNameOffset = offset;
        this.myExceptionClassName = exceptionClassName;
        this.myExceptionMessage = exceptionMessage;
    }

    @Nullable
    PsiElement matchSpecificExceptionElement(@NotNull PsiElement element) {
        if (element == null) {
            ExceptionInfo.$$$reportNull$$$0(2);
        }
        return null;
    }

    @NotNull
    public ExceptionLineRefiner getPositionRefiner() {
        return new AfterExceptionRefiner(this);
    }

    public int getClassNameOffset() {
        return this.myClassNameOffset;
    }

    @NotNull
    public String getExceptionClassName() {
        String string = this.myExceptionClassName;
        if (string == null) {
            ExceptionInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getExceptionMessage() {
        String string = this.myExceptionMessage;
        if (string == null) {
            ExceptionInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static ExceptionInfo parseMessage(String line, int textEndOffset) {
        int firstSpace = line.indexOf(32);
        int colonPos = -1;
        TextRange classRange = null;
        if (firstSpace == -1) {
            classRange = ExceptionInfo.getExceptionClassFromMessage(line, 0, ExceptionInfo.getLength(line));
        } else if (firstSpace == "Caused".length() && line.startsWith(CAUSED_BY)) {
            colonPos = line.indexOf(58, CAUSED_BY.length());
            classRange = ExceptionInfo.getExceptionClassFromMessage(line, CAUSED_BY.length(), colonPos == -1 ? ExceptionInfo.getLength(line) : colonPos);
        } else if (firstSpace == "Exception".length() && line.startsWith(EXCEPTION_IN_THREAD)) {
            int start;
            int nextQuotePos = line.indexOf("\" ", EXCEPTION_IN_THREAD.length());
            if (nextQuotePos == -1) {
                return null;
            }
            colonPos = line.indexOf(58, start = nextQuotePos + "\" ".length());
            classRange = ExceptionInfo.getExceptionClassFromMessage(line, start, colonPos == -1 ? ExceptionInfo.getLength(line) : colonPos);
        } else if (firstSpace > 2 && line.charAt(firstSpace - 1) == ':') {
            colonPos = firstSpace - 1;
            classRange = ExceptionInfo.getExceptionClassFromMessage(line, 0, firstSpace - 1);
        } else if (firstSpace > 3 && line.charAt(0) == '[' && line.charAt(firstSpace - 1) == ':' && line.charAt(firstSpace - 2) == ']') {
            colonPos = line.indexOf(58, firstSpace);
            classRange = ExceptionInfo.getExceptionClassFromMessage(line, firstSpace + 1, colonPos == -1 ? ExceptionInfo.getLength(line) : colonPos);
        }
        if (classRange == null) {
            return null;
        }
        String message = colonPos == -1 ? null : line.substring(colonPos + 1).trim();
        message = StringUtil.notNullize(message);
        int absoluteOffset = textEndOffset - line.length();
        String exceptionName = classRange.substring(line);
        int startOffset = classRange.getStartOffset() + absoluteOffset;
        return ExceptionInfo.createExceptionInfo(message, exceptionName, startOffset);
    }

    @NotNull
    private static ExceptionInfo createExceptionInfo(String message, String exceptionName, int startOffset) {
        switch (exceptionName) {
            case "java.lang.ArrayIndexOutOfBoundsException": {
                return new ArrayIndexOutOfBoundsExceptionInfo(startOffset, message);
            }
            case "java.lang.ArrayStoreException": {
                return new ArrayStoreExceptionInfo(startOffset, message);
            }
            case "java.lang.ClassCastException": {
                return new ClassCastExceptionInfo(startOffset, message);
            }
            case "java.lang.NullPointerException": {
                return new NullPointerExceptionInfo(startOffset, message);
            }
            case "java.lang.AssertionError": {
                return new AssertionErrorInfo(startOffset, message);
            }
            case "java.lang.ArithmeticException": {
                return new ArithmeticExceptionInfo(startOffset, message);
            }
            case "java.lang.NegativeArraySizeException": {
                return new NegativeArraySizeExceptionInfo(startOffset, message);
            }
        }
        JetBrainsNotNullInstrumentationExceptionInfo info = JetBrainsNotNullInstrumentationExceptionInfo.tryCreate(startOffset, exceptionName, message);
        return info != null ? info : new ExceptionInfo(startOffset, exceptionName, message);
    }

    private static int getLength(String line) {
        int length;
        for (length = line.length(); length > 2 && Character.isWhitespace(line.charAt(length - 1)); --length) {
        }
        return length;
    }

    private static TextRange getExceptionClassFromMessage(String line, int from, int to) {
        if (to - from > 200) {
            return null;
        }
        boolean hasDot = false;
        for (int i = from; i < to; ++i) {
            char c = line.charAt(i);
            if (c == '.' && i == from) {
                return null;
            }
            if (c == '$' && !hasDot) {
                return null;
            }
            if (c != '.' && c != '$' && !Character.isJavaIdentifierPart(c)) {
                return null;
            }
            hasDot |= c == '.';
        }
        if (!hasDot) {
            return null;
        }
        return new TextRange(from, to);
    }

    public ExceptionInfo consumeStackLine(@NonNls String line) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionMessage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/ExceptionInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/ExceptionInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionClassName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "matchSpecificExceptionElement";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AfterExceptionRefiner
    implements ExceptionLineRefiner {
        private final ExceptionInfo myInfo;

        public AfterExceptionRefiner(ExceptionInfo info) {
            this.myInfo = info;
        }

        @Override
        public PsiElement matchElement(@NotNull PsiElement element) {
            PsiType type;
            PsiNewExpression newExpression;
            if (element == null) {
                AfterExceptionRefiner.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiKeyword && element.textMatches((CharSequence)"new") && (newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiNewExpression.class)) != null && (type = newExpression.getType()) != null && type.equalsToText(this.myInfo.getExceptionClassName())) {
                return element;
            }
            return this.myInfo.matchSpecificExceptionElement(element);
        }

        @Override
        public ExceptionLineRefiner consumeNextLine(String line) {
            ExceptionInfo info = this.myInfo.consumeStackLine(line);
            if (info != null) {
                return new AfterExceptionRefiner(info);
            }
            return null;
        }

        @Override
        public ExceptionInfo getExceptionInfo() {
            return this.myInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/filters/ExceptionInfo$AfterExceptionRefiner", "matchElement"));
        }
    }
}

