/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationsPanel;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.ide.DataManager;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NullableNotNullDialog
extends DialogWrapper {
    private final Project myProject;
    private final AnnotationsPanel myNullablePanel;
    private final AnnotationsPanel myNotNullPanel;
    private final boolean myShowInstrumentationOptions;

    public NullableNotNullDialog(@NotNull Project project) {
        if (project == null) {
            NullableNotNullDialog.$$$reportNull$$$0(0);
        }
        this(project, false);
    }

    private NullableNotNullDialog(@NotNull Project project, boolean showInstrumentationOptions) {
        if (project == null) {
            NullableNotNullDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myProject = project;
        this.myShowInstrumentationOptions = showInstrumentationOptions;
        NullableNotNullManager manager = NullableNotNullManager.getInstance(this.myProject);
        this.myNullablePanel = new AnnotationsPanel(project, "Nullable", manager.getDefaultNullable(), manager.getNullables(), manager.getDefaultNullables(), Collections.emptySet(), false, true);
        this.myNotNullPanel = new AnnotationsPanel(project, "NotNull", manager.getDefaultNotNull(), manager.getNotNulls(), manager.getDefaultNotNulls(), new HashSet<String>(manager.getInstrumentedNotNulls()), showInstrumentationOptions, true);
        this.init();
        this.setTitle(JavaBundle.message("nullable.notnull.configuration.dialog.title", new Object[0]));
    }

    public static JButton createConfigureAnnotationsButton(Component context) {
        JButton button = new JButton(JavaBundle.message("configure.annotations.option", new Object[0]));
        button.addActionListener(NullableNotNullDialog.createActionListener(context));
        return button;
    }

    public static ActionListener createActionListener(final Component context) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NullableNotNullDialog.showDialog(context, false);
            }
        };
    }

    public static void showDialogWithInstrumentationOptions(@NotNull Component context) {
        if (context == null) {
            NullableNotNullDialog.$$$reportNull$$$0(2);
        }
        NullableNotNullDialog.showDialog(context, true);
    }

    private static void showDialog(Component context, boolean showInstrumentationOptions) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(context));
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        NullableNotNullDialog dialog = new NullableNotNullDialog(project, showInstrumentationOptions);
        dialog.show();
    }

    protected JComponent createCenterPanel() {
        Splitter splitter = new Splitter(true);
        splitter.setFirstComponent(this.myNullablePanel.getComponent());
        splitter.setSecondComponent(this.myNotNullPanel.getComponent());
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setPreferredSize((Dimension)JBUI.size((int)300, (int)400));
        return splitter;
    }

    protected void doOKAction() {
        NullableNotNullManager manager = NullableNotNullManager.getInstance(this.myProject);
        manager.setNotNulls(this.myNotNullPanel.getAnnotations());
        manager.setDefaultNotNull(this.myNotNullPanel.getDefaultAnnotation());
        manager.setNullables(this.myNullablePanel.getAnnotations());
        manager.setDefaultNullable(this.myNullablePanel.getDefaultAnnotation());
        if (this.myShowInstrumentationOptions) {
            manager.setInstrumentedNotNulls(this.myNotNullPanel.getCheckedAnnotations());
        }
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/NullableNotNullDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogWithInstrumentationOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

