/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.ui.BundleAccessor;
import com.intellij.remote.ui.SdkScopeController;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentProjectLevelSetupForm {
    private static final Logger LOG = Logger.getInstance(DeploymentProjectLevelSetupForm.class);
    private JPanel myMainPanel;
    private JPanel myDeploymentProjectLevelServerSetupPanel;
    private HyperlinkLabel myDeploymentLevelWarningLabel;
    private ActionLink myDeploymentCreateAppLevelSeverLink;
    private JBLabel myDeploymentCreateAppLevelLabel;
    private ActionLink myDeploymentMoveServerLink;
    private JBLabel myDeploymentMoveServerLabel;
    private JPanel myCustomActionPanel;
    @Nullable
    private Project myProject;
    @NotNull
    private final Listener myListener;
    @Nullable
    private String myWebServerConfigId;
    @Nullable
    private final BundleAccessor myBundleAccessor;
    @NotNull
    private final SdkScopeController mySdkScopeController;

    public DeploymentProjectLevelSetupForm(@Nullable Project project, @Nullable BundleAccessor bundleAccessor, @NotNull Listener listener, @NotNull SdkScopeController sdkScopeController) {
        if (listener == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(0);
        }
        if (sdkScopeController == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myBundleAccessor = bundleAccessor;
        this.myListener = listener;
        this.mySdkScopeController = sdkScopeController;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        String createTooltip = RemoteSdkBundle.message("created.deployment.server.will.be.visible.for.all.projects", objectArray);
        this.myDeploymentCreateAppLevelLabel.setToolTipText(createTooltip);
        this.myDeploymentCreateAppLevelSeverLink.setToolTipText(createTooltip);
        String moveTooltip = RemoteSdkBundle.message("deployment.server.will.be.visible.for.all.projects", new Object[0]);
        this.myDeploymentMoveServerLink.setToolTipText(moveTooltip);
        this.myDeploymentMoveServerLabel.setToolTipText(moveTooltip);
        this.myDeploymentProjectLevelServerSetupPanel.setBorder((Border)JBUI.Borders.emptyTop((int)JBUIScale.scale((int)10)));
        this.configureDeploymentLevelWarning();
        if (bundleAccessor != null) {
            this.myDeploymentMoveServerLink.setText(StringUtil.notNullize((String)bundleAccessor.messageOrNull("remote.interpreter.move.server.action.link", new Object[0]), (String)RemoteSdkBundle.message("move", new Object[0])));
            this.myDeploymentMoveServerLabel.setText(StringUtil.notNullize((String)bundleAccessor.messageOrNull("remote.interpreter.move.server.label", new Object[0]), (String)RemoteSdkBundle.message("label.this.server.to.ide.settings", new Object[0])));
        }
        if (sdkScopeController.isProjectLevelSupported()) {
            this.configureMoveInterpreterAction();
        }
    }

    private void configureDeploymentLevelWarning() {
        String warningMessage;
        String customMessage;
        String string = customMessage = this.myBundleAccessor == null ? null : this.myBundleAccessor.messageOrNull("remote.interpreter.deployment.level.incompatibility", new Object[0]);
        if (customMessage != null) {
            warningMessage = customMessage;
        } else {
            @Nls String entityName = this.myBundleAccessor == null ? null : this.myBundleAccessor.messageOrNull("remote.interpreter.entity.name", new Object[0]);
            entityName = StringUtil.notNullize((String)entityName, (String)RemoteSdkBundle.message("sentence.remote.sdk", new Object[0]));
            warningMessage = RemoteSdkBundle.message("link.label.saved.in.href.ide.settings.so.it.needs.deployment.server", entityName);
        }
        this.myDeploymentLevelWarningLabel.setHtmlText(warningMessage);
        this.myDeploymentLevelWarningLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpManager.getInstance().invokeHelp("concepts.project.settings");
                }
            }
        });
    }

    private void configureMoveInterpreterAction() {
        String moveTooltip = RemoteSdkBundle.message("remote.interpreter.move.interpreter.tooltip", new Object[0]);
        ActionLink interpreterMoveLink = new ActionLink(RemoteSdkBundle.message("remote.interpreter.move.interpreter.action.link", new Object[0]), new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                DeploymentProjectLevelSetupForm.this.mySdkScopeController.setProjectLevel(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/remotesdk/ui/DeploymentProjectLevelSetupForm$2", "actionPerformed"));
            }
        });
        interpreterMoveLink.setToolTipText(moveTooltip);
        this.myCustomActionPanel.add((Component)interpreterMoveLink);
        JBLabel label = new JBLabel(RemoteSdkBundle.message("remote.interpreter.move.interpreter.label", new Object[0]));
        label.setToolTipText(moveTooltip);
        this.myCustomActionPanel.add((Component)label);
    }

    protected void createUIComponents() {
        this.myDeploymentCreateAppLevelSeverLink = new ActionLink(RemoteSdkBundle.message("action.link.create", new Object[0]), new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                GroupedServersConfigManager instance;
                WebServerConfig server;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                LOG.assertTrue((server = (instance = GroupedServersConfigManager.getInstance((Project)DeploymentProjectLevelSetupForm.this.myProject)).findServer(DeploymentProjectLevelSetupForm.this.myWebServerConfigId)) != null, (Object)("Server with id " + DeploymentProjectLevelSetupForm.this.myWebServerConfigId + " not found"));
                LOG.assertTrue(server.isProjectLevel(), (Object)"IDE-level server with actions shown");
                WebServerConfig global = server.cloneWithNewIdAndCredentials();
                global.setIsProjectLevel(false);
                global.setName("Copy of project-level server '" + global.getName() + "'");
                instance.setUniqueName(global);
                PublishConfig publishConfig = PublishConfig.getInstance((Project)(DeploymentProjectLevelSetupForm.this.myProject == null ? ProjectManager.getInstance().getDefaultProject() : DeploymentProjectLevelSetupForm.this.myProject));
                List oldPaths = publishConfig.getExcludedPaths(server.getId());
                publishConfig.setExcludedPaths(global.getId(), oldPaths);
                List oldMappings = publishConfig.getPathMappings(server.getId());
                publishConfig.setPathMappings(global.getId(), oldMappings);
                instance.addServer(global);
                DeploymentProjectLevelSetupForm.this.myListener.onConfigCopied(global);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/remotesdk/ui/DeploymentProjectLevelSetupForm$3", "actionPerformed"));
            }
        });
        this.myDeploymentMoveServerLink = new ActionLink(RemoteSdkBundle.message("action.link.move", new Object[0]), new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                GroupedServersConfigManager instance;
                WebServerConfig server;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                LOG.assertTrue((server = (instance = GroupedServersConfigManager.getInstance((Project)DeploymentProjectLevelSetupForm.this.myProject)).findServer(DeploymentProjectLevelSetupForm.this.myWebServerConfigId)) != null, (Object)("Server with id " + DeploymentProjectLevelSetupForm.this.myWebServerConfigId + " not found"));
                LOG.assertTrue(server.isProjectLevel(), (Object)"IDE-level server with actions shown");
                WebServerConfig movedServer = instance.moveServer(server);
                DeploymentProjectLevelSetupForm.this.myListener.onConfigMoved(movedServer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/remotesdk/ui/DeploymentProjectLevelSetupForm$4", "actionPerformed"));
            }
        });
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    public JPanel getCustomActionPanel() {
        JPanel jPanel = this.myCustomActionPanel;
        if (jPanel == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    public ActionLink getDeploymentMoveServerLink() {
        ActionLink actionLink = this.myDeploymentMoveServerLink;
        if (actionLink == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(4);
        }
        return actionLink;
    }

    @NotNull
    public HyperlinkLabel getDeploymentLevelWarningLabel() {
        HyperlinkLabel hyperlinkLabel = this.myDeploymentLevelWarningLabel;
        if (hyperlinkLabel == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(5);
        }
        return hyperlinkLabel;
    }

    @NotNull
    public JBLabel getDeploymentMoveServerLabel() {
        JBLabel jBLabel = this.myDeploymentMoveServerLabel;
        if (jBLabel == null) {
            DeploymentProjectLevelSetupForm.$$$reportNull$$$0(6);
        }
        return jBLabel;
    }

    public void setWebServerConfigId(@Nullable String webServerConfigId) {
        this.myWebServerConfigId = webServerConfigId;
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkScopeController";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/DeploymentProjectLevelSetupForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/DeploymentProjectLevelSetupForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomActionPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentMoveServerLink";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentLevelWarningLabel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentMoveServerLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeploymentProjectLevelServerSetupPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeploymentLevelWarningLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0, 5, 5));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ActionLink actionLink = this.myDeploymentCreateAppLevelSeverLink;
        this.$$$loadLabelText$$$((JLabel)actionLink, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", DeploymentProjectLevelSetupForm.class).getString("action.link.create"));
        Component component = jPanel5.add((Component)actionLink);
        this.myDeploymentCreateAppLevelLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", DeploymentProjectLevelSetupForm.class).getString("copy.of.this.deployment.server.in.ide.settings"));
        Component component2 = jPanel5.add((Component)jBLabel2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0, 5, 5));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ActionLink actionLink2 = this.myDeploymentMoveServerLink;
        this.$$$loadLabelText$$$((JLabel)actionLink2, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", DeploymentProjectLevelSetupForm.class).getString("action.link.move"));
        Component component3 = jPanel6.add((Component)actionLink2);
        this.myDeploymentMoveServerLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", DeploymentProjectLevelSetupForm.class).getString("label.this.server.to.ide.settings"));
        Component component4 = jPanel6.add((Component)jBLabel);
        this.myCustomActionPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Listener {
        public void onConfigCopied(@NotNull WebServerConfig var1);

        public void onConfigMoved(@NotNull WebServerConfig var1);
    }
}

