/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.remote.ColoredRemoteProcessHandler;
import com.intellij.remote.DeferredRemoteProcess;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsBuilder;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ProcessBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolProcessAdapter;
import com.jetbrains.plugins.remotesdk.tools.RemoteTool;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promises;

public class RemoteToolRunProfile
implements ModuleRunProfile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tools.ToolRunProfile");
    private final RemoteTool myTool;
    private final RemoteCredentials myRemoteCredentials;
    private final DataContext myContext;
    private final GeneralCommandLine myCommandLine;

    public RemoteToolRunProfile(RemoteTool tool, RemoteCredentials remoteCredentials, DataContext context) {
        this.myTool = tool;
        this.myRemoteCredentials = remoteCredentials;
        this.myContext = context;
        this.myCommandLine = this.myTool.createCommandLine(context);
    }

    @NotNull
    public String getName() {
        String string = RemoteToolRunProfile.expandMacrosInName(this.myTool, this.myContext);
        if (string == null) {
            RemoteToolRunProfile.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String expandMacrosInName(Tool tool, DataContext context) {
        String name = tool.getName();
        try {
            return MacroManager.getInstance().expandMacrosInString(name, true, context);
        }
        catch (Macro.ExecutionCancelledException e) {
            LOG.info((Throwable)e);
            return name;
        }
    }

    public Icon getIcon() {
        return null;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        FilterInfo[] outputFilters;
        Project project;
        if (executor == null) {
            RemoteToolRunProfile.$$$reportNull$$$0(1);
        }
        if (env == null) {
            RemoteToolRunProfile.$$$reportNull$$$0(2);
        }
        if ((project = env.getProject()) == null || this.myCommandLine == null) {
            return null;
        }
        CommandLineState commandLineState = new CommandLineState(env){

            GeneralCommandLine createCommandLine() {
                return RemoteToolRunProfile.this.myCommandLine;
            }

            @NotNull
            protected ProcessHandler startProcess() throws ExecutionException {
                GeneralCommandLine commandLine = this.createCommandLine();
                ConnectionBuilder connectionBuilder2 = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)RemoteToolRunProfile.this.myRemoteCredentials, (Project)project);
                RemoteSdkCredentials sdkData = new RemoteSdkCredentialsBuilder().withCredentials(RemoteToolRunProfile.this.myRemoteCredentials).withInterpreterPath("").build();
                ProcessBuilder builder = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder2, (GeneralCommandLine)commandLine).withAllocatePty(true);
                DeferredRemoteProcess process2 = new DeferredRemoteProcess(Promises.runAsync(() -> ((ProcessBuilder)builder).start()));
                ColoredRemoteProcessHandler processHandler = new ColoredRemoteProcessHandler((RemoteProcess)process2, commandLine.getCommandLineString(sdkData.getFullInterpreterPath() + ":" + commandLine.getExePath()), EncodingProjectManager.getInstance((Project)project).getDefaultCharset());
                ProcessTerminatedListener.attach((ProcessHandler)processHandler);
                ColoredRemoteProcessHandler coloredRemoteProcessHandler = processHandler;
                if (coloredRemoteProcessHandler == null) {
                    1.$$$reportNull$$$0(0);
                }
                return coloredRemoteProcessHandler;
            }

            @NotNull
            public ExecutionResult execute(final @NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                ExecutionResult result;
                ProcessHandler processHandler;
                if (executor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (runner == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((processHandler = (result = super.execute(executor, runner)).getProcessHandler()) != null) {
                    processHandler.addProcessListener((ProcessListener)new ToolProcessAdapter(project, RemoteToolRunProfile.this.myTool.synchronizeAfterExecution(), RemoteToolRunProfile.this.getName()));
                    processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (outputType == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (outputType == ProcessOutputTypes.STDOUT && RemoteToolRunProfile.this.myTool.isShowConsoleOnStdOut() || outputType == ProcessOutputTypes.STDERR && RemoteToolRunProfile.this.myTool.isShowConsoleOnStdErr()) {
                                RunContentManager.getInstance((Project)project).toFrontRunContent(executor, processHandler);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "outputType";
                                    break;
                                }
                            }
                            objectArray[1] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile$1$1";
                            objectArray[2] = "onTextAvailable";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
                ExecutionResult executionResult = result;
                if (executionResult == null) {
                    1.$$$reportNull$$$0(3);
                }
                return executionResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        for (FilterInfo outputFilter : outputFilters = this.myTool.getOutputFilters()) {
            builder.addFilter((Filter)new RegexpFilter(project, outputFilter.getRegExp()));
        }
        commandLineState.setConsoleBuilder(builder);
        return commandLineState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

