/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target.wizard;

import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ExecBuilder;
import com.intellij.ssh.process.SshExecProcess;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\b\b\u0001\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable;", "Lcom/intellij/execution/target/LanguageRuntimeType$Introspectable;", "connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "textProvider", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$TextProvider;", "(Lcom/intellij/ssh/ConnectionBuilder;Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$TextProvider;)V", "executeCommand", "Ljava/util/concurrent/CompletableFuture;", "", "cmd", "promiseEnvironmentVariable", "varName", "promiseExecuteScript", "script", "Companion", "TextProvider", "intellij.remoteRun"})
public final class SshTargetIntrospectable
extends LanguageRuntimeType.Introspectable {
    private final ConnectionBuilder connectionBuilder;
    private final TextProvider textProvider;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public CompletableFuture<String> promiseEnvironmentVariable(@NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        return this.executeCommand("echo ${" + varName + '}');
    }

    private final CompletableFuture<String> executeCommand(@NlsSafe String cmd) {
        TextProvider textProvider2 = this.textProvider;
        if (textProvider2 != null) {
            textProvider2.printlnSystemText("> " + cmd);
        }
        try {
            SshExecProcess sshExecProcess = ExecBuilder.execute$default((ExecBuilder)this.connectionBuilder.execBuilder(cmd), (int)0, (boolean)true, (int)1, null);
            long timeoutMs = 10000L;
            boolean exited = sshExecProcess.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
            sshExecProcess.destroyForcibly();
            InputStream inputStream = sshExecProcess.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"sshExecProcess.inputStream");
            Object object = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = object;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            String output = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
            object = output;
            boolean bl3 = false;
            if (object.length() > 0) {
                TextProvider textProvider3 = this.textProvider;
                if (textProvider3 != null) {
                    textProvider3.printlnText(output);
                }
            }
            LOG.debug("Command output: " + output);
            int exitValue = sshExecProcess.exitValue();
            TextProvider textProvider4 = this.textProvider;
            if (textProvider4 != null) {
                String string = RemoteSdkBundle.message("sst.target.introspectable.message.command.finished.with.exit.code.0", exitValue);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RemoteSdkBundle.message(\u2026.exit.code.0\", exitValue)");
                textProvider4.printlnSystemText(string);
            }
            if (exited) {
                LOG.info("Execution for '" + cmd + "' exited normally with code " + sshExecProcess.exitValue());
            } else {
                TextProvider textProvider5 = this.textProvider;
                if (textProvider5 != null) {
                    String string = RemoteSdkBundle.message("sst.target.introspectable.message.execution.was.killed.due.to.timeout", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RemoteSdkBundle.message(\u2026s.killed.due.to.timeout\")");
                    textProvider5.printlnError(string);
                }
                LOG.warn("Execution for '" + cmd + "' was killed due to timeout of " + timeoutMs + " ms");
            }
            if (exited && exitValue == 0) {
                CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(output);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(output)");
                return completableFuture;
            }
            CompletableFuture<String> completableFuture = CompletableFuture.failedFuture(new Throwable(RemoteSdkBundle.message("sst.target.introspectable.message.getting.environment.failed.with.exit.value.0", exitValue)));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.failed\u2026it.value.0\", exitValue)))");
            return completableFuture;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            TextProvider textProvider6 = this.textProvider;
            if (textProvider6 != null) {
                String string = RemoteSdkBundle.message("sst.target.introspectable.message.failed.to.execute.command", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RemoteSdkBundle.message(\u2026iled.to.execute.command\")");
                textProvider6.printlnError(string);
            }
            CompletableFuture<String> completableFuture = CompletableFuture.failedFuture(e);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.failedFuture(e)");
            return completableFuture;
        }
    }

    @NotNull
    public CompletableFuture<String> promiseExecuteScript(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return this.executeCommand(script);
    }

    public SshTargetIntrospectable(@NotNull ConnectionBuilder connectionBuilder2, @Nullable TextProvider textProvider2) {
        Intrinsics.checkNotNullParameter((Object)connectionBuilder2, (String)"connectionBuilder");
        this.connectionBuilder = connectionBuilder2;
        this.textProvider = textProvider2;
    }

    public /* synthetic */ SshTargetIntrospectable(ConnectionBuilder connectionBuilder2, TextProvider textProvider2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textProvider2 = null;
        }
        this(connectionBuilder2, textProvider2);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshTargetIntrospectable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0007\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$TextProvider;", "", "printlnError", "", "text", "", "printlnSystemText", "printlnText", "intellij.remoteRun"})
    public static interface TextProvider {
        public void printlnText(@Nls @NotNull String var1);

        public void printlnSystemText(@Nls @NotNull String var1);

        public void printlnError(@Nls @NotNull String var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.remoteRun"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

