/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.websocket.jam.WebSocketPathParam;
import com.intellij.websocket.references.WebSocketPathParamPsiElement;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class WebSocketPathReference
extends PsiReferenceBase<PsiElement> {
    private final PsiLiteralExpression myLiteral;
    private final TextRange myRange;
    private final String myName;

    public WebSocketPathReference(PsiLiteralExpression literal, TextRange range, String name) {
        super((PsiElement)literal, range, true);
        this.myLiteral = literal;
        this.myRange = range;
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public PsiElement resolve() {
        return new WebSocketPathParamPsiElement((PsiElement)this.myLiteral, this.myName, this.myRange);
    }

    public Object @NotNull [] getVariants() {
        HashSet<LookupElementBuilder> variants = new HashSet<LookupElementBuilder>();
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiClass.class);
        if (psiClass != null) {
            for (WebSocketPathParam pathParam : WebSocketCommonUtils.getPathParams(psiClass)) {
                String name = pathParam.getName();
                if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                variants.add(LookupElementBuilder.create((String)name).withIcon(PlatformIcons.VARIABLE_ICON));
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            WebSocketPathReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/references/WebSocketPathReference", "getVariants"));
    }
}

