/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.providers;

import com.intellij.ide.presentation.Presentation;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.FrameworkUrlPathSpecification;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.DefaultFrameworkUrlPathSpecification;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.websocket.jam.WebSocketJamModel;
import com.intellij.websocket.jam.WebSocketServerEndpoint;
import com.intellij.websocket.providers.WebSocketTargetInfo;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="WebSocket", icon="AllIcons.Webreferences.WebSocket")
public final class WebSocketPathResolver
implements UrlResolver {
    public static final List<Authority.Exact> AUTHORITY_HINTS = Collections.emptyList();
    private final Project myProject;

    public WebSocketPathResolver(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<Authority.Exact> getAuthorityHints() {
        List<Authority.Exact> list = AUTHORITY_HINTS;
        if (list == null) {
            WebSocketPathResolver.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<String> getSupportedSchemes() {
        List list = UrlConstants.WS_SCHEMES;
        if (list == null) {
            WebSocketPathResolver.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        List<WebSocketServerEndpoint> endpoints;
        if (request == null) {
            WebSocketPathResolver.$$$reportNull$$$0(2);
        }
        if ((endpoints = WebSocketJamModel.getModel(this.myProject).getServerEndpoints(GlobalSearchScope.projectScope((Project)this.myProject), JavaeeType.JAVAX, JavaeeType.JAKARTA)).isEmpty()) {
            Set<UrlTargetInfo> set = Collections.emptySet();
            if (set == null) {
                WebSocketPathResolver.$$$reportNull$$$0(3);
            }
            return set;
        }
        Iterator combinations = UrlPath.combinations((UrlPath)request.getPath()).iterator();
        HashSet<UrlTargetInfo> resolved = new HashSet<UrlTargetInfo>();
        while (combinations.hasNext()) {
            resolved.addAll(WebSocketPathResolver.resolveInner((UrlPath)combinations.next(), endpoints));
        }
        HashSet<UrlTargetInfo> hashSet = resolved;
        if (hashSet == null) {
            WebSocketPathResolver.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static Collection<? extends UrlTargetInfo> resolveInner(@NotNull UrlPath urlPath, @NotNull List<WebSocketServerEndpoint> endpoints) {
        if (urlPath == null) {
            WebSocketPathResolver.$$$reportNull$$$0(5);
        }
        if (endpoints == null) {
            WebSocketPathResolver.$$$reportNull$$$0(6);
        }
        HashSet<WebSocketTargetInfo> resolved = new HashSet<WebSocketTargetInfo>();
        for (WebSocketServerEndpoint endpoint : endpoints) {
            if (!urlPath.toStringWithStars().equals(StringsKt.removePrefix((String)endpoint.getPath(), (CharSequence)"/"))) continue;
            resolved.add(new WebSocketTargetInfo(urlPath, endpoint.getPsiElement().getNavigationElement()));
        }
        return resolved;
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        DefaultFrameworkUrlPathSpecification specification = DefaultFrameworkUrlPathSpecification.INSTANCE;
        Iterable iterable = WebSocketJamModel.getModel(this.myProject).getServerEndpoints(GlobalSearchScope.projectScope((Project)this.myProject), JavaeeType.JAVAX, JavaeeType.JAKARTA).stream().map(arg_0 -> WebSocketPathResolver.lambda$getVariants$0((FrameworkUrlPathSpecification)specification, arg_0)).collect(Collectors.toSet());
        if (iterable == null) {
            WebSocketPathResolver.$$$reportNull$$$0(7);
        }
        return iterable;
    }

    private static /* synthetic */ WebSocketTargetInfo lambda$getVariants$0(FrameworkUrlPathSpecification specification, WebSocketServerEndpoint ep) {
        return new WebSocketTargetInfo(specification.parsePath(ep.getPath()), ep.getPsiElement().getNavigationElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/websocket/providers/WebSocketPathResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorityHints";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedSchemes";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/websocket/providers/WebSocketPathResolver";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class WebSocketPathResolverFactory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            if (project == null) {
                WebSocketPathResolverFactory.$$$reportNull$$$0(0);
            }
            return WebSocketCommonUtils.hasWebSocketLibrary(project) ? new WebSocketPathResolver(project) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/providers/WebSocketPathResolver$WebSocketPathResolverFactory", "forProject"));
        }
    }
}

