/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.utils;

import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.beans.CdiExtensionBeanDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.constants.CdiClassesConstants;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.cdi.utils.CdiVersion;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.javaee.ejb.model.EjbAnnotationConstants;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdiCommonUtils {
    private static final Key<CachedValue<Collection<PsiPackage>>> VETOED_PACKAGES = new Key("VETOED_PACKAGES");
    private static final Key<CachedValue<Boolean>> MANAGED_BEAN = new Key("SIMPLE_WEB_BEAN");

    private CdiCommonUtils() {
    }

    @NotNull
    public static Collection<PsiClass> getQualifierClasses(PsiModifierListOwner modifierListOwner) {
        return CdiCommonUtils.getQualifierClasses(modifierListOwner, ModuleUtilCore.findModuleForPsiElement((PsiElement)modifierListOwner));
    }

    @NotNull
    public static Set<PsiClass> getQualifierClasses(PsiModifierListOwner modifierListOwner, @Nullable Module module) {
        HashSet<PsiClass> bindingTypes = new HashSet<PsiClass>();
        for (PsiClass anno : CdiCommonUtils.getQualifierClasses(module)) {
            String annoQualifiedName = CdiCommonUtils.getQualifierBeanAnnotation(anno.getProject(), anno.getQualifiedName());
            if (annoQualifiedName == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)annoQualifiedName, (int)1)) continue;
            bindingTypes.add(anno);
        }
        HashSet<PsiClass> hashSet = bindingTypes;
        if (hashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    public static PsiAnnotation @NotNull [] getQualifierAnnotations(PsiModifierListOwner psiModifierListOwner) {
        Collection<String> strings = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getQualifierClasses(psiModifierListOwner));
        PsiAnnotation[] psiAnnotationArray = AnnotationUtil.findAnnotations((PsiModifierListOwner)psiModifierListOwner, strings);
        if (psiAnnotationArray == null) {
            CdiCommonUtils.$$$reportNull$$$0(1);
        }
        return psiAnnotationArray;
    }

    @NotNull
    public static Set<PsiClass> getInterceptorBindingTypesClasses(PsiModifierListOwner modifierListOwner, @Nullable Module module) {
        HashSet<PsiClass> bindingTypes = new HashSet<PsiClass>();
        for (PsiClass anno : CdiCommonUtils.getInterceptorBindingTypesClasses(module)) {
            String annoQualifiedName = anno.getQualifiedName();
            if (annoQualifiedName == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)annoQualifiedName, (int)1)) continue;
            bindingTypes.add(anno);
        }
        HashSet<PsiClass> hashSet = bindingTypes;
        if (hashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<PsiClass> getQualifierClasses(@Nullable Module module) {
        Collection<Object> collection = module == null ? Collections.emptyList() : MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)CdiAnnoConstants.QUALIFIER_ANNOTATION.fqn(module), (boolean)false);
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getInterceptorBindingTypesClasses(@Nullable Module module) {
        Collection<Object> collection = module == null ? Collections.emptyList() : MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)CdiAnnoConstants.INTERCEPTOR_BINDING_ANNOTATION.fqn(module), (boolean)false);
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getBindingTypesQualifiedNames(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(5);
        }
        return CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getQualifierClasses(module));
    }

    @NotNull
    public static Collection<PsiClass> getNormalScopeTypesClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(6);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, (String)CdiAnnoConstants.NORMAL_SCOPE_ANNOTATION.fqn(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getNormalScopeQualifiedNames(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(8);
        }
        return CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getNormalScopeTypesClasses(module));
    }

    @NotNull
    public static Collection<PsiClass> getScopeTypesClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(9);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, (String)CdiAnnoConstants.SCOPE_ANNOTATION.fqn(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getScopeQualifiedNames(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(11);
        }
        return CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getScopeTypesClasses(module));
    }

    @NotNull
    public static Collection<PsiClass> getDeploymentTypesClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(12);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, (String)CdiAnnoConstants.DEPLOYMENT_TYPE_ANNOTATION.fqn(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getStereotypeAnnotationNames(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(14);
        }
        return CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getStereotypeAnnotationClasses(module));
    }

    @NotNull
    public static Collection<PsiClass> getStereotypeAnnotationClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(15);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, (String)CdiAnnoConstants.STEREOTYPE_ANNOTATION.fqn(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiPackage> getVetoedPackages(@NotNull Module module) {
        CachedValue cachedValue;
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(17);
        }
        if ((cachedValue = (CachedValue)module.getUserData(VETOED_PACKAGES)) == null) {
            cachedValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> {
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(CdiAnnoConstants.VETOED_ANNOTATION.fqn(module), scope);
                Set packages = psiClass == null ? Collections.emptySet() : AnnotatedPackagesSearch.search((PsiClass)psiClass, (SearchScope)scope).findAll();
                return CachedValueProvider.Result.create(packages, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
            module.putUserData(VETOED_PACKAGES, (Object)cachedValue);
        }
        Collection collection = (Collection)cachedValue.getValue();
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getAlternativeStereotypeAnnotationClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(19);
        }
        HashSet alternativeStereotypeAnnotations = new HashSet();
        String alternativeAnnotationFqn = CdiAnnoConstants.ALTERNATIVE_ANNOTATION.fqn(module);
        for (PsiClass psiClass : MetaAnnotationUtil.getAnnotatedTypes((Module)module, (String)CdiAnnoConstants.STEREOTYPE_ANNOTATION.fqn(module))) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)alternativeAnnotationFqn, (int)1)) continue;
            alternativeStereotypeAnnotations.add(psiClass);
        }
        Set<Object> set = alternativeStereotypeAnnotations.isEmpty() ? Collections.emptySet() : alternativeStereotypeAnnotations;
        if (set == null) {
            CdiCommonUtils.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    public static Collection<PsiClass> getStereotypeAnnotationClasses(Module module, String ... encapsulatedClasses) {
        if (encapsulatedClasses.length == 0) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                CdiCommonUtils.$$$reportNull$$$0(21);
            }
            return list;
        }
        ArrayList stereotypes = new ArrayList();
        for (PsiClass stereotypeAnnoPsiClass : CdiCommonUtils.getStereotypeAnnotationClasses(module)) {
            if (!stereotypeAnnoPsiClass.isAnnotationType() || !AnnotationUtil.isAnnotated((PsiModifierListOwner)stereotypeAnnoPsiClass, Arrays.asList(encapsulatedClasses), (int)0)) continue;
            stereotypes.add(stereotypeAnnoPsiClass);
        }
        List<Object> list = stereotypes.isEmpty() ? Collections.emptyList() : stereotypes;
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public static Collection<String> getQualifiedNames(Iterable<? extends PsiClass> annotations) {
        List list = ContainerUtil.mapNotNull(annotations, psiClass -> psiClass.getQualifiedName());
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(23);
        }
        return list;
    }

    public static boolean isManagedBean(@NotNull PsiClass psiClass) {
        Boolean value;
        CachedValue cachedValue;
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(24);
        }
        if ((cachedValue = (CachedValue)psiClass.getUserData(MANAGED_BEAN)) == null) {
            cachedValue = CachedValuesManager.getManager((Project)psiClass.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)CdiManagedBeanValidationUtils.isManagedBean(psiClass), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
            psiClass.putUserData(MANAGED_BEAN, (Object)cachedValue);
        }
        return (value = (Boolean)cachedValue.getValue()) != null && value != false;
    }

    public static boolean isInjectAvailable(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)CdiAnnoConstants.INJECT_ANNOTATION.fqn(module));
    }

    public static boolean isCdiInstalled(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)CdiClassesConstants.ENTERPRISE_INJECT_INSTANCE.fqn(module));
    }

    public static boolean isCdiAvailable(@Nullable Project project) {
        for (String className : CdiClassesConstants.ENTERPRISE_INJECT_INSTANCE.all()) {
            if (!JavaLibraryUtils.hasLibraryClass((Project)project, (String)className)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCdiInstalled(@Nullable Module module, @NotNull CdiVersion version) {
        if (version == null) {
            CdiCommonUtils.$$$reportNull$$$0(25);
        }
        if (module == null || module.isDisposed()) {
            return false;
        }
        if (version == CdiVersion.CDI_3_0) {
            return JavaLibraryUtils.hasLibraryClass((Module)module, (String)CdiClassesConstants.REQUEST_CONTEXT_CONTROLLER.jakarta());
        }
        if (version == CdiVersion.CDI_2_0) {
            return JavaLibraryUtils.hasLibraryClass((Module)module, (String)CdiClassesConstants.REQUEST_CONTEXT_CONTROLLER.javax());
        }
        if (version == CdiVersion.CDI_1_1) {
            return JavaLibraryUtils.hasLibraryClass((Module)module, (String)CdiAnnoConstants.VETOED_ANNOTATION.javax());
        }
        if (version == CdiVersion.CDI_1_0) {
            return JavaLibraryUtils.hasLibraryClass((Module)module, (String)CdiClassesConstants.ENTERPRISE_INJECT_INSTANCE.javax());
        }
        return false;
    }

    public static List<String> getCdiAnnotations(Module module) {
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            DumbService dumbService = DumbService.getInstance((Project)module.getProject());
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.createSingleDependency(Collections.emptyList(), (Object)dumbService);
            }
            return CachedValueProvider.Result.createSingleDependency(CdiCommonUtils.findCdiAnnotationsFromCdiAnnoConstants(module), (Object)ProjectRootManager.getInstance((Project)module.getProject()));
        });
    }

    private static List<String> findCdiAnnotationsFromCdiAnnoConstants(Module module) {
        ArrayList<String> annotations = new ArrayList<String>();
        try {
            for (Field field : CdiAnnoConstants.class.getFields()) {
                Object value = field.get(null);
                if (value instanceof String) {
                    annotations.add((String)value);
                    continue;
                }
                if (!(value instanceof JavaeeClass)) continue;
                ContainerUtil.addAll(annotations, (Object[])((JavaeeClass)value).all());
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)module.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        return ContainerUtil.filter(annotations, annotationFqn -> javaPsi.findClass(annotationFqn, scope) != null);
    }

    public static boolean isDecorator(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(26);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)CdiAnnoConstants.DECORATOR_ANNOTATION.fqn((PsiElement)psiClass), (int)0);
    }

    public static boolean isInterceptor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(27);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)CdiAnnoConstants.INTERCEPTOR_ANNOTATION.fqn((PsiElement)psiClass), (int)0);
    }

    public static boolean isAlternative(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            CdiCommonUtils.$$$reportNull$$$0(28);
        }
        if (CdiCommonUtils.isAlternativeAnnotated(psiMember)) {
            return true;
        }
        return psiMember instanceof PsiClass && CdiCommonUtils.hasAlternativeProducers((PsiClass)psiMember);
    }

    public static boolean isAlternativeAnnotated(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            CdiCommonUtils.$$$reportNull$$$0(29);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)CdiAnnoConstants.ALTERNATIVE_ANNOTATION.fqn((PsiElement)psiMember), (int)0)) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMember);
        if (module != null) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getAlternativeStereotypeAnnotationClasses(module)), (int)0)) {
                return true;
            }
            List<String> alternativeAnnotations = CdiCustomizationManager.getCustomAlternativeAnnotations(module);
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, alternativeAnnotations, (int)0)) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasAlternativeProducers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(30);
        }
        for (PsiField field : CdiCommonUtils.getProducerFields(psiClass)) {
            if (!CdiCommonUtils.isAlternativeAnnotated((PsiMember)field)) continue;
            return true;
        }
        for (PsiMethod psiMethod : CdiCommonUtils.getProducerMethods(psiClass)) {
            if (!CdiCommonUtils.isAlternativeAnnotated((PsiMember)psiMethod)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiClass getOriginalPsiClass(PsiType type, @NotNull Module module) {
        String name;
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(31);
        }
        if (type instanceof PsiClassType) {
            PsiType genericPsiType;
            List<PsiType> psiTypes;
            PsiClassType psiClassType = (PsiClassType)type;
            PsiClassType providerClass = CdiCommonUtils.getProviderClass(psiClassType);
            if (providerClass != null && (psiTypes = CdiCommonUtils.resolveGenerics(providerClass)).size() == 1 && (genericPsiType = psiTypes.get(0)) instanceof PsiClassType) {
                return ((PsiClassType)genericPsiType).resolve();
            }
            return psiClassType.resolve();
        }
        if (type instanceof PsiPrimitiveType && !StringUtil.isEmptyOrSpaces((String)(name = ((PsiPrimitiveType)type).getBoxedTypeName()))) {
            return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(name, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        }
        return null;
    }

    @Nullable
    private static PsiClassType getProviderClass(@NotNull PsiClassType psiClassType) {
        PsiClass psiClass;
        if (psiClassType == null) {
            CdiCommonUtils.$$$reportNull$$$0(32);
        }
        if ((psiClass = psiClassType.resolve()) == null) {
            return null;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (CdiClassesConstants.INJECT_PROVIDER.isFqn(qualifiedName)) {
            return psiClassType;
        }
        for (PsiType type : psiClassType.getSuperTypes()) {
            PsiClass superClass;
            if (!(type instanceof PsiClassType) || (superClass = ((PsiClassType)type).resolve()) == null || !CdiClassesConstants.INJECT_PROVIDER.isFqn(superClass.getQualifiedName())) continue;
            return (PsiClassType)type;
        }
        return null;
    }

    public static List<PsiType> resolveGenerics(PsiClassType classType) {
        SmartList generics = new SmartList();
        PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (psiClass != null) {
            for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
                generics.add(substitutor.substitute(typeParameter));
            }
        }
        return generics;
    }

    public static boolean isProxyable(@NotNull PsiType psiType) {
        if (psiType == null) {
            CdiCommonUtils.$$$reportNull$$$0(33);
        }
        if (psiType instanceof PsiPrimitiveType) {
            return false;
        }
        if (psiType instanceof PsiArrayType) {
            return false;
        }
        if (psiType instanceof PsiClassType) {
            return CdiCommonUtils.isClassProxyable(((PsiClassType)psiType).resolve());
        }
        return false;
    }

    public static boolean isClassProxyable(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (psiClass.isInterface()) {
            return true;
        }
        if (!CdiManagedBeanValidationUtils.hasAppropriateConstructor(psiClass)) {
            return false;
        }
        PsiModifierList list = psiClass.getModifierList();
        if (list != null && (list.hasModifierProperty("private") || list.hasModifierProperty("final"))) {
            return false;
        }
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (!psiMethod.getModifierList().hasModifierProperty("final")) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<PsiMethod> getProducerMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(34);
        }
        List list = CdiCommonUtils.filterProducers((PsiMember[])psiClass.getAllMethods());
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public static List<PsiField> getProducerFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(36);
        }
        List list = CdiCommonUtils.filterProducers((PsiMember[])psiClass.getAllFields());
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(37);
        }
        return list;
    }

    private static <T extends PsiMember> List<T> filterProducers(T[] members) {
        return ContainerUtil.filter((Object[])members, m -> CdiAnnoConstants.PRODUCES_ANNOTATION.isAnnotated((PsiModifierListOwner)m, 0));
    }

    public static List<PsiMember> getPsiTypeProducers(@NotNull Module module, @NotNull PsiType psiType) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(38);
        }
        if (psiType == null) {
            CdiCommonUtils.$$$reportNull$$$0(39);
        }
        ArrayList<PsiMember> producers = new ArrayList<PsiMember>();
        for (CdiProduces<?> jamProduces : CdiJamModel.getModel(module).getProduces()) {
            PsiType productType = jamProduces.getProductType();
            if (productType == null || !productType.isAssignableFrom(psiType)) continue;
            producers.add((PsiMember)jamProduces.getPsiElement());
        }
        return producers;
    }

    @NotNull
    public static Set<PsiMethod> getDisposerMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(40);
        }
        String disposerAnno = CdiAnnoConstants.DISPOSES_ANNOTATION.fqn((PsiElement)psiClass);
        PsiMethod[] methods = psiClass.getAllMethods();
        HashSet<PsiMethod> disposerMethods = new HashSet<PsiMethod>();
        block0: for (PsiMethod psiMethod : methods) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)disposerAnno, (int)0)) continue;
                disposerMethods.add(psiMethod);
                continue block0;
            }
        }
        HashSet<PsiMethod> hashSet = disposerMethods;
        if (hashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(41);
        }
        return hashSet;
    }

    @NotNull
    public static List<PsiMethod> getObservesMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(42);
        }
        PsiMethod[] methods = psiClass.getAllMethods();
        SmartList observesMethods = new SmartList();
        List<String> annotations = Arrays.asList(CdiAnnoConstants.OBSERVES_ANNOTATION.fqn((PsiElement)psiClass), CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.fqn((PsiElement)psiClass));
        for (PsiMethod psiMethod : methods) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, annotations, (int)0)) continue;
                observesMethods.add(psiMethod);
            }
        }
        SmartList smartList = observesMethods;
        if (smartList == null) {
            CdiCommonUtils.$$$reportNull$$$0(43);
        }
        return smartList;
    }

    public static boolean isClassContainsCdiAnnotations(PsiClass psiClass, Module module) {
        List<String> annos = CdiCommonUtils.collectCdiBeansAnnotations(module);
        return CdiCommonUtils.isClassContainsCdiAnnotations(psiClass, annos);
    }

    public static boolean isClassContainsCdiAnnotations(@NotNull PsiClass psiClass, @NotNull List<String> annos) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(44);
        }
        if (annos == null) {
            CdiCommonUtils.$$$reportNull$$$0(45);
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, annos) != null) {
            return true;
        }
        for (PsiField psiField : psiClass.getFields()) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, annos) == null) continue;
            return true;
        }
        for (PsiField psiField : psiClass.getMethods()) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, annos) != null) {
                return true;
            }
            for (PsiParameter parameter : psiField.getParameterList().getParameters()) {
                if (AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, annos) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> collectCdiBeansAnnotations(Module module) {
        ArrayList<String> annotations = new ArrayList<String>(CdiCommonUtils.getCdiAnnotations(module));
        annotations.addAll(CdiCommonUtils.getBindingTypesQualifiedNames(module));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getNormalScopeTypesClasses(module)));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getDeploymentTypesClasses(module)));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getStereotypeAnnotationClasses(module)));
        annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getScopeTypesClasses(module)));
        annotations.addAll(CdiCustomizationManager.getCustomBeanAnnotations(module));
        return annotations;
    }

    public static boolean hasImplicitArchive(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(46);
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)CdiCommonUtils.hasBeanDefinedClasses(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public static boolean hasBeanDefinedClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(47);
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        for (String anno : CdiCommonUtils.getBeanDefiningAnnotations(module)) {
            if (!CdiCommonUtils.hasAnnotatedMembers(javaPsiFacade, searchScope, anno)) continue;
            return true;
        }
        if (CdiCommonUtils.hasAnnotatedMembers(javaPsiFacade, searchScope, EjbAnnotationConstants.STATEFUL_ANNO.javax())) {
            return true;
        }
        if (CdiCommonUtils.hasAnnotatedMembers(javaPsiFacade, searchScope, EjbAnnotationConstants.STATEFUL_ANNO.javax())) {
            return true;
        }
        if (CdiCommonUtils.hasAnnotatedMembers(javaPsiFacade, searchScope, EjbAnnotationConstants.STATELESS_ANNO.jakarta())) {
            return true;
        }
        return CdiCommonUtils.hasAnnotatedMembers(javaPsiFacade, searchScope, EjbAnnotationConstants.STATELESS_ANNO.jakarta());
    }

    public static boolean hasAnnotatedMembers(@NotNull JavaPsiFacade javaPsiFacade, @NotNull GlobalSearchScope searchScope, @NotNull String anno) {
        PsiClass annoClass;
        if (javaPsiFacade == null) {
            CdiCommonUtils.$$$reportNull$$$0(48);
        }
        if (searchScope == null) {
            CdiCommonUtils.$$$reportNull$$$0(49);
        }
        if (anno == null) {
            CdiCommonUtils.$$$reportNull$$$0(50);
        }
        return (annoClass = javaPsiFacade.findClass(anno, searchScope)) != null && AnnotatedMembersSearch.search((PsiClass)annoClass, (SearchScope)searchScope).findFirst() != null;
    }

    @NotNull
    public static Set<String> getBeanDefiningAnnotations(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(51);
        }
        LinkedHashSet<String> annotations = new LinkedHashSet<String>(CdiCommonUtils.getNormalScopeQualifiedNames(module));
        annotations.add(CdiAnnoConstants.DECORATOR_ANNOTATION.fqn(module));
        annotations.add(CdiAnnoConstants.INTERCEPTOR_ANNOTATION.fqn(module));
        annotations.addAll(CdiCommonUtils.getStereotypeAnnotationNames(module));
        annotations.add(CdiAnnoConstants.DEPENDENT_ANNOTATION.fqn(module));
        LinkedHashSet<String> linkedHashSet = annotations;
        if (linkedHashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(52);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<CdiExtensionBeanDescriptor> collectExtensionBeanDescriptors(@NotNull Project project) {
        if (project == null) {
            CdiCommonUtils.$$$reportNull$$$0(53);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            HashSet<CdiExtensionBeanDescriptor> descriptors = new HashSet<CdiExtensionBeanDescriptor>();
            descriptors.addAll(CdiCommonUtils.getJavaeeDescriptors(project, JavaeeType.JAVAX));
            descriptors.addAll(CdiCommonUtils.getJavaeeDescriptors(project, JavaeeType.JAKARTA));
            return CachedValueProvider.Result.create(descriptors, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (set == null) {
            CdiCommonUtils.$$$reportNull$$$0(54);
        }
        return set;
    }

    @NotNull
    private static Set<CdiExtensionBeanDescriptor> getJavaeeDescriptors(@NotNull Project project, @NotNull JavaeeType javaeeType) {
        if (project == null) {
            CdiCommonUtils.$$$reportNull$$$0(55);
        }
        if (javaeeType == null) {
            CdiCommonUtils.$$$reportNull$$$0(56);
        }
        HashSet<CdiExtensionBeanDescriptor> descriptors = new HashSet<CdiExtensionBeanDescriptor>();
        Collection<CdiObserves> afterBeanDiscoveryObserves = CdiCommonUtils.getAfterBeanDiscoveryObserves(project, javaeeType, GlobalSearchScope.allScope((Project)project));
        if (afterBeanDiscoveryObserves.size() > 0) {
            for (CdiObserves observe : afterBeanDiscoveryObserves) {
                ContainerUtil.addAllNotNull(descriptors, CdiCommonUtils.collectBeanDescriptors(observe, javaeeType));
            }
        }
        HashSet<CdiExtensionBeanDescriptor> hashSet = descriptors;
        if (hashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(57);
        }
        return hashSet;
    }

    @NotNull
    private static Set<CdiExtensionBeanDescriptor> collectBeanDescriptors(@NotNull CdiObserves observe, @NotNull JavaeeType javaeeType) {
        PsiClass aClass;
        PsiMethod method;
        if (observe == null) {
            CdiCommonUtils.$$$reportNull$$$0(58);
        }
        if (javaeeType == null) {
            CdiCommonUtils.$$$reportNull$$$0(59);
        }
        if ((method = observe.getPsiMethod()) != null && (aClass = JavaPsiFacade.getInstance((Project)method.getProject()).findClass(CdiClassesConstants.AFTER_BEAN_DISCOVERY.fqn(javaeeType), method.getResolveScope())) != null) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = aClass.findMethodsByName("addBean", true)) {
                if (psiMethod.getParameterList().getParametersCount() != 0) continue;
                return CdiCommonUtils.searchAddBeanExpressions(psiMethod, (SearchScope)new LocalSearchScope((PsiElement)method));
            }
        }
        Set<CdiExtensionBeanDescriptor> set = Collections.emptySet();
        if (set == null) {
            CdiCommonUtils.$$$reportNull$$$0(60);
        }
        return set;
    }

    @NotNull
    private static Set<CdiExtensionBeanDescriptor> searchAddBeanExpressions(@NotNull PsiMethod fireEventMethod, @NotNull SearchScope searchScope) {
        if (fireEventMethod == null) {
            CdiCommonUtils.$$$reportNull$$$0(61);
        }
        if (searchScope == null) {
            CdiCommonUtils.$$$reportNull$$$0(62);
        }
        @NotNull LinkedHashSet<CdiExtensionBeanDescriptor> set = new LinkedHashSet<CdiExtensionBeanDescriptor>();
        MethodReferencesSearch.search((PsiMethod)fireEventMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
            if (methodCallExpression != null) {
                set.add(CdiExtensionBeanDescriptor.create(methodCallExpression));
            }
            return true;
        });
        LinkedHashSet<CdiExtensionBeanDescriptor> linkedHashSet = set;
        if (linkedHashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(63);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<CdiObserves> getAfterBeanDiscoveryObserves(@NotNull Project project, @NotNull JavaeeType javaeeType, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            CdiCommonUtils.$$$reportNull$$$0(64);
        }
        if (javaeeType == null) {
            CdiCommonUtils.$$$reportNull$$$0(65);
        }
        if (scope == null) {
            CdiCommonUtils.$$$reportNull$$$0(66);
        }
        List observes = JamService.getJamService((Project)project).getJamParameterElements(CdiObserves.OBSERVES_JAM_KEY, CdiAnnoConstants.OBSERVES_ANNOTATION.fqn(javaeeType), scope);
        Collection collection = observes.stream().filter(cdiObserves -> InheritanceUtil.isInheritor((PsiType)cdiObserves.getType(), (String)CdiClassesConstants.AFTER_BEAN_DISCOVERY.fqn(javaeeType))).collect(Collectors.toSet());
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(67);
        }
        return collection;
    }

    @Nullable
    public static String getQualifierBeanAnnotation(@NotNull Project project, @Nullable String beanQualifier) {
        if (project == null) {
            CdiCommonUtils.$$$reportNull$$$0(68);
        }
        if (beanQualifier == null) {
            return null;
        }
        String targetAnnotation = CdiCustomizationManager.getQualifierBeanAnnotation(project, beanQualifier);
        if (targetAnnotation != null) {
            return targetAnnotation;
        }
        return beanQualifier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/utils/CdiCommonUtils";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 31: 
            case 38: 
            case 46: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 36: 
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassType";
                break;
            }
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annos";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaPsiFacade";
                break;
            }
            case 49: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 53: 
            case 55: 
            case 64: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 56: 
            case 59: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observe";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fireEventMethod";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotations";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterceptorBindingTypesClasses";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/utils/CdiCommonUtils";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalScopeTypesClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeTypesClasses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentTypesClasses";
                break;
            }
            case 16: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getStereotypeAnnotationClasses";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getVetoedPackages";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlternativeStereotypeAnnotationClasses";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerMethods";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerFields";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposerMethods";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getObservesMethods";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanDefiningAnnotations";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExtensionBeanDescriptors";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaeeDescriptors";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBeanDescriptors";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "searchAddBeanExpressions";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterBeanDiscoveryObserves";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBindingTypesQualifiedNames";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNormalScopeTypesClasses";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNormalScopeQualifiedNames";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getScopeTypesClasses";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getScopeQualifiedNames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentTypesClasses";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeAnnotationNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeAnnotationClasses";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVetoedPackages";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeStereotypeAnnotationClasses";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isManagedBean";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isCdiInstalled";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isDecorator";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInterceptor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isAlternative";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAlternativeAnnotated";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasAlternativeProducers";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalPsiClass";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getProviderClass";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isProxyable";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getProducerMethods";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getProducerFields";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getPsiTypeProducers";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDisposerMethods";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getObservesMethods";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isClassContainsCdiAnnotations";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "hasImplicitArchive";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "hasBeanDefinedClasses";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotatedMembers";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getBeanDefiningAnnotations";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "collectExtensionBeanDescriptors";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getJavaeeDescriptors";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "collectBeanDescriptors";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "searchAddBeanExpressions";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getAfterBeanDiscoveryObserves";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierBeanAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

