/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.model;

import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiBeansXmlSchemaProvider
extends XmlSchemaProvider {
    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            CdiBeansXmlSchemaProvider.$$$reportNull$$$0(0);
        }
        if (!"beans.xml".equals(file.getName())) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return CdiCommonUtils.isCdiInstalled(module) || CdiCommonUtils.isInjectAvailable(module);
    }

    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            CdiBeansXmlSchemaProvider.$$$reportNull$$$0(1);
        }
        if (baseFile == null) {
            CdiBeansXmlSchemaProvider.$$$reportNull$$$0(2);
        }
        if (module == null) {
            return null;
        }
        String resourceName = CdiBeansXmlSchemaProvider.getResourceName(url);
        if (resourceName == null) {
            return null;
        }
        URL resource = CdiBeansXmlSchemaProvider.class.getResource(resourceName);
        if (resource != null) {
            VirtualFile virtualFile = VfsUtil.findFileByURL((URL)resource);
            PsiFile psiFile = baseFile.getManager().findFile(virtualFile);
            return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        }
        return null;
    }

    @Nullable
    private static String getResourceName(String url) {
        if (url.endsWith("://jakarta.ee/xml/ns/jakartaee/beans_3_0.xsd")) {
            return "/schemas/beans_3_0.xsd";
        }
        if (url.startsWith("http://xmlns.jcp.org/xml/ns/javaee/beans_2_0.xsd")) {
            return "/schemas/beans_2_0.xsd";
        }
        if (url.startsWith("http://xmlns.jcp.org/xml/ns/javaee/beans_1_1.xsd")) {
            return "/schemas/beans_1_1.xsd";
        }
        if (url.startsWith("http://java.sun.com/xml/ns/javaee")) {
            return "/schemas/beans_1_0.xsd";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/model/CdiBeansXmlSchemaProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSchema";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

