/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.microprofile.starter;

import com.intellij.cdi.microprofile.starter.MicroprofileOptions;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.WebStarterProjectDownloader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;

public class MicroprofileProjectDownloader
extends WebStarterProjectDownloader<MicroprofileOptions> {
    public MicroprofileProjectDownloader(WebStarterModuleBuilder<MicroprofileOptions> builder) {
        super(builder);
    }

    protected Url buildUrl() {
        String serviceUrl = StringUtil.trimTrailing((String)this.myBuilder.getServiceUrl(), (char)'/');
        Url url = Urls.newFromEncoded((String)(serviceUrl + "/api/3/project"));
        MicroprofileOptions options = (MicroprofileOptions)this.myBuilder.getOptions();
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("artifactId", options.artifact);
        parameters.put("groupId", options.group);
        parameters.put("mpVersion", Objects.requireNonNull((WebStarterOptions.Option)options.versionsComboBoxModel.getSelected()).id);
        parameters.put("supportedServer", Objects.requireNonNull((WebStarterOptions.Option)options.serversComboBoxModel.getSelected()).id);
        url = url.addParameters(parameters);
        for (String selectedDependencyId : options.getSelectedDependenciesIds()) {
            url = url.addParameters(Collections.singletonMap("selectedSpecs", selectedDependencyId));
        }
        return url;
    }

    protected void unzip(File tempZipFile, File contentEntryDir) throws IOException {
        MicroprofileProjectDownloader.unzipSubfolder((File)tempZipFile, (File)contentEntryDir);
    }
}

