/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.microprofile.starter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.cdi.microprofile.starter.MicroprofileOptions;
import com.intellij.cdi.microprofile.starter.MicroprofileSupportMatrix;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoader;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoaderIteration;
import com.intellij.frameworks.starters.web.utils.OneActionListDataListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

public class MicroprofileOptionsDownloader
extends WebStarterOptionsLoader<MicroprofileOptions> {
    private static final Map<String, String> KNOWN_SERVER_ID_2_DISPLAY_NAME = new ContainerUtil.ImmutableMapBuilder().put((Object)"KUMULUZEE", (Object)"KumuluzEE").put((Object)"QUARKUS", (Object)"Quarkus").put((Object)"LIBERTY", (Object)"Open Liberty").put((Object)"PAYARA_MICRO", (Object)"Payara Micro").put((Object)"HELIDON", (Object)"Helidon").put((Object)"THORNTAIL_V2", (Object)"Thorntail V2").put((Object)"TOMEE", (Object)"Apache TomEE").put((Object)"WILDFLY_SWARM", (Object)"WildFly Swarm").build();
    private static final Pattern versionNameFromIdPattern = Pattern.compile("(MP)(\\d)(\\d)");

    protected MicroprofileOptions createEmptyOptionsContainer() {
        return new MicroprofileOptions();
    }

    @NotNull
    protected WebStarterOptionsLoaderIteration<MicroprofileOptions> getFirstIteration() {
        return new WebStarterOptionsLoaderIteration<MicroprofileOptions>(){

            protected RequestBuilder getPreparedRequestBuilder(String serviceUrl) {
                return HttpRequests.request((String)(serviceUrl + "/api/2/supportMatrix"));
            }

            public void parseJsonResponse(JsonElement jsonRootElement, @NotNull MicroprofileOptions options) {
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                MicroprofileOptionsDownloader.doParseOptionsDataJson(jsonRootElement, options);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/cdi/microprofile/starter/MicroprofileOptionsDownloader$1", "parseJsonResponse"));
            }
        };
    }

    private static void doParseOptionsDataJson(JsonElement rootElement, @NotNull MicroprofileOptions options) {
        if (options == null) {
            MicroprofileOptionsDownloader.$$$reportNull$$$0(0);
        }
        options.supportMatrix = MicroprofileOptionsDownloader.parseSupportMatrix(rootElement);
        List<WebStarterOptions.Option> allVersions = options.supportMatrix.allVersions;
        options.versionsComboBoxModel.add(allVersions);
        options.versionsComboBoxModel.setSelectedItem((Object)allVersions.get(allVersions.size() - 1));
        options.refreshServersComboBoxModel();
        options.versionsComboBoxModel.addListDataListener((ListDataListener)new OneActionListDataListener(options::refreshServersComboBoxModel));
    }

    private static MicroprofileSupportMatrix parseSupportMatrix(JsonElement rootElement) {
        MicroprofileSupportMatrix supportMatrix = new MicroprofileSupportMatrix();
        JsonObject jsonSpecsDescriptions = rootElement.getAsJsonObject().get("descriptions").getAsJsonObject();
        for (Map.Entry entry : jsonSpecsDescriptions.entrySet()) {
            WebStarterOptions.Option specification = MicroprofileOptionsDownloader.parseSpecification(entry);
            supportMatrix.allSpecifications.put(specification.id, specification);
        }
        JsonObject jsonVersions = rootElement.getAsJsonObject().get("configs").getAsJsonObject();
        for (Map.Entry jsonConfigEntry : jsonVersions.entrySet()) {
            String versionId = (String)jsonConfigEntry.getKey();
            supportMatrix.allVersions.add(new WebStarterOptions.Option(versionId, MicroprofileOptionsDownloader.tryParseVersionName(versionId)));
            JsonObject versionEntry = ((JsonElement)jsonConfigEntry.getValue()).getAsJsonObject();
            JsonArray jsonSupportedServers = versionEntry.get("supportedServers").getAsJsonArray();
            ArrayList<WebStarterOptions.Option> serversForVersion = new ArrayList<WebStarterOptions.Option>();
            for (JsonElement jsonServer : jsonSupportedServers) {
                String serverId = jsonServer.getAsString();
                WebStarterOptions.Option server2 = supportMatrix.allServers.get(serverId);
                if (server2 == null) {
                    String serverDisplayName = MicroprofileOptionsDownloader.generateServerDisplayName(serverId);
                    server2 = new WebStarterOptions.Option(serverId, serverDisplayName, "");
                    supportMatrix.allServers.put(serverId, server2);
                }
                serversForVersion.add(server2);
            }
            serversForVersion.sort(Comparator.comparing(server -> server.display));
            supportMatrix.version2servers.put(versionId, serversForVersion);
            JsonArray supportedSpecs = versionEntry.get("specs").getAsJsonArray();
            HashSet<WebStarterOptions.Option> specsForVersion = new HashSet<WebStarterOptions.Option>();
            for (JsonElement jsonSpec : supportedSpecs) {
                String specName = jsonSpec.getAsString();
                WebStarterOptions.Option specification = supportMatrix.allSpecifications.get(specName);
                if (specification == null) {
                    specification = new WebStarterOptions.Option(specName, specName, "");
                }
                specsForVersion.add(specification);
            }
            supportMatrix.version2specifications.put(versionId, specsForVersion);
        }
        supportMatrix.allVersions.sort((o1, o2) -> o1.id.compareToIgnoreCase(o2.id));
        return supportMatrix;
    }

    private static String tryParseVersionName(String versionId) {
        Matcher matcher = versionNameFromIdPattern.matcher(versionId);
        return matcher.matches() ? matcher.group(1) + " " + matcher.group(2) + "." + matcher.group(3) : versionId;
    }

    @NotNull
    private static WebStarterOptions.Option parseSpecification(Map.Entry<String, JsonElement> entry) {
        String key = entry.getKey();
        String value = entry.getValue().getAsString();
        boolean success = false;
        String specPresentableName = "<error>";
        String specDescription = CdiBundle.message("microprofile.spec.error.description", new Object[0]);
        int indexOfDivider = value.indexOf(45);
        if (indexOfDivider > 0 && indexOfDivider + 1 < value.length()) {
            specPresentableName = value.substring(0, indexOfDivider).trim();
            specDescription = value.substring(indexOfDivider + 1).trim();
            if (StringUtil.isNotEmpty((String)specPresentableName) && StringUtil.isNotEmpty((String)specDescription)) {
                success = true;
            }
        }
        if (!success) {
            specPresentableName = key;
            specDescription = value;
        }
        specDescription = StringUtil.capitalize((String)specDescription);
        return new WebStarterOptions.Option(key, specPresentableName, specDescription);
    }

    private static String generateServerDisplayName(String serverId) {
        String displayName = KNOWN_SERVER_ID_2_DISPLAY_NAME.get(serverId);
        if (displayName == null) {
            displayName = MicroprofileOptionsDownloader.generateDisplayTitleFromId(serverId);
        }
        return displayName;
    }

    @NotNull
    private static String generateDisplayTitleFromId(String serverId) {
        String displayName;
        CharSequence[] words = serverId.split("[ _]");
        for (int i = 0; i < words.length; ++i) {
            words[i] = StringUtil.capitalize((String)StringUtil.toLowerCase((String)words[i]));
        }
        String string = displayName = String.join((CharSequence)" ", words);
        if (string == null) {
            MicroprofileOptionsDownloader.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/microprofile/starter/MicroprofileOptionsDownloader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/microprofile/starter/MicroprofileOptionsDownloader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDisplayTitleFromId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doParseOptionsDataJson";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

