/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.microprofile.starter;

import com.intellij.cdi.microprofile.starter.MicroprofileSupportMatrix;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.ui.CollectionComboBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class MicroprofileOptions
extends WebStarterOptions {
    String group = "com.example";
    String artifact = "demo";
    final CollectionComboBoxModel<WebStarterOptions.Option> versionsComboBoxModel = new CollectionComboBoxModel();
    final CollectionComboBoxModel<WebStarterOptions.Option> serversComboBoxModel = new CollectionComboBoxModel();
    final Set<String> selectedSpecificationsIds = new HashSet<String>();
    MicroprofileSupportMatrix supportMatrix;

    public String getArtifact() {
        return this.artifact;
    }

    public List<WebStarterOptions.MultiSelectGroup> getDependenciesCategories() {
        Collection<WebStarterOptions.Option> allSpecs = this.supportMatrix.allSpecifications.values();
        return Collections.singletonList(new WebStarterOptions.MultiSelectGroup(CdiBundle.message("microprofile.dependency.group", new Object[0]), new ArrayList<WebStarterOptions.Option>(allSpecs)));
    }

    public Set<String> getSelectedDependenciesIds() {
        return this.selectedSpecificationsIds;
    }

    public void refreshServersComboBoxModel() {
        WebStarterOptions.Option selectedVersion = (WebStarterOptions.Option)this.versionsComboBoxModel.getSelected();
        if (selectedVersion == null) {
            this.serversComboBoxModel.removeAll();
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Can't refresh combobox with servers because selectedVersion==null, however shouldn't be");
            return;
        }
        WebStarterOptions.Option prevSelectedServer = (WebStarterOptions.Option)this.serversComboBoxModel.getSelected();
        this.serversComboBoxModel.removeAll();
        List<WebStarterOptions.Option> availableServers = this.supportMatrix.version2servers.get(selectedVersion.id);
        this.serversComboBoxModel.add(availableServers);
        if (this.serversComboBoxModel.contains((Object)prevSelectedServer)) {
            this.serversComboBoxModel.setSelectedItem((Object)prevSelectedServer);
        } else {
            this.serversComboBoxModel.setSelectedItem((Object)availableServers.get(0));
        }
    }
}

