/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.microprofile.starter;

import com.intellij.cdi.microprofile.starter.MicroprofileApplicationInfoStep;
import com.intellij.cdi.microprofile.starter.MicroprofileOptions;
import com.intellij.cdi.microprofile.starter.MicroprofileOptionsDownloader;
import com.intellij.cdi.microprofile.starter.MicroprofileProjectDownloader;
import com.intellij.cdi.microprofile.starter.MicroprofileSupportMatrix;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.frameworks.starters.web.WebStarterApplicationInfoStep;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.WebStarterProjectDownloader;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoader;
import com.intellij.frameworks.starters.web.utils.DependencyAvailabilityVerificationResult;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import icons.JavaeeCdiIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class MicroprofileModuleBuilder
extends WebStarterModuleBuilder<MicroprofileOptions> {
    MicroprofileModuleBuilder() {
    }

    protected WebStarterApplicationInfoStep<MicroprofileOptions> createApplicationInfoStep(WizardContext context) {
        return new MicroprofileApplicationInfoStep(this, context);
    }

    @NotNull
    public DependencyAvailabilityVerificationResult isDependencyAvailable(WebStarterOptions.Option dependency, boolean needExplanation) {
        WebStarterOptions.Option selectedVersion = (WebStarterOptions.Option)((MicroprofileOptions)this.getOptions()).versionsComboBoxModel.getSelected();
        assert (selectedVersion != null);
        String selectedVersionId = selectedVersion.id;
        MicroprofileSupportMatrix supportMatrix = ((MicroprofileOptions)this.getOptions()).supportMatrix;
        boolean isAvailable = supportMatrix.isDependencySupportedBy(selectedVersionId, dependency);
        String explanation = null;
        if (!isAvailable && needExplanation) {
            ArrayList<String> versionsThatSupport = new ArrayList<String>();
            for (WebStarterOptions.Option eachVersion : supportMatrix.allVersions) {
                if (!supportMatrix.isDependencySupportedBy(eachVersion.id, dependency)) continue;
                versionsThatSupport.add(eachVersion.id);
            }
            explanation = CdiBundle.message("message.specification.is.not.supported.by.version.but.supported.by.versions", selectedVersionId, ((Object)versionsThatSupport).toString());
        }
        return new DependencyAvailabilityVerificationResult(isAvailable, explanation);
    }

    public String getDependenciesValidWord(boolean isPlural, boolean isCapitalLetter) {
        if (isPlural) {
            if (isCapitalLetter) {
                return CdiBundle.message("word.specification.plural.capitalized", new Object[0]);
            }
            return CdiBundle.message("word.specification.plural", new Object[0]);
        }
        if (isCapitalLetter) {
            return CdiBundle.message("word.specification.capitalized", new Object[0]);
        }
        return CdiBundle.message("word.specification", new Object[0]);
    }

    public String getDefaultServiceUrl() {
        return "https://start.microprofile.io";
    }

    protected boolean isReformatAfterCreation(Project project) {
        return true;
    }

    protected WebStarterOptionsLoader<MicroprofileOptions> createOptionsDownloader() {
        return new MicroprofileOptionsDownloader();
    }

    protected WebStarterProjectDownloader<MicroprofileOptions> createProjectDownloader() {
        return new MicroprofileProjectDownloader(this);
    }

    public String getHelpId() {
        return "microprofile.project";
    }

    @NotNull
    @NonNls
    public String getBuilderId() {
        return "microprofile";
    }

    public String getDescription() {
        return CdiBundle.message("description.for.microprofile.project.starter", new Object[0]);
    }

    public String getPresentableName() {
        return CdiBundle.message("presentable.name.microprofile", new Object[0]);
    }

    public Icon getNodeIcon() {
        return JavaeeCdiIcons.Microprofile;
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) {
        Sdk sdk;
        if (modifiableRootModel == null) {
            MicroprofileModuleBuilder.$$$reportNull$$$0(0);
        }
        Sdk sdk2 = sdk = this.getModuleJdk() != null ? this.getModuleJdk() : ProjectRootManager.getInstance((Project)modifiableRootModel.getProject()).getProjectSdk();
        if (sdk != null) {
            modifiableRootModel.setSdk(sdk);
        }
        this.doAddContentEntry(modifiableRootModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableRootModel", "com/intellij/cdi/microprofile/starter/MicroprofileModuleBuilder", "setupRootModel"));
    }
}

