/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.microprofile.starter;

import com.intellij.cdi.microprofile.starter.MicroprofileOptions;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.frameworks.starters.shared.StartersValidationUtils;
import com.intellij.frameworks.starters.web.WebStarterApplicationInfoStep;
import com.intellij.frameworks.starters.web.WebStarterFormBuilder;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTextField;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class MicroprofileApplicationInfoStep
extends WebStarterApplicationInfoStep<MicroprofileOptions> {
    private JBTextField myGroupField;
    private JBTextField myArtifactField;

    public MicroprofileApplicationInfoStep(WebStarterModuleBuilder<MicroprofileOptions> builder, WizardContext wizardContext) {
        super(builder, wizardContext);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGroupField;
    }

    protected void fillAppSettingsPanel(WebStarterFormBuilder formBuilder, MicroprofileOptions options) {
        this.myGroupField = formBuilder.addTextField(CdiBundle.message("label.text.group", new Object[0]), options.group);
        this.myArtifactField = formBuilder.addTextField(CdiBundle.message("label.text.artifact", new Object[0]), options.artifact);
        ComboBox versionsComboBox = formBuilder.addComboBox(CdiBundle.message("label.mnemonic.text.version.of.something", "MicroProfile"), options.versionsComboBoxModel);
        ComboBox serversComboBox = formBuilder.addComboBox(CdiBundle.message("label.mnemonic.text.runtime.of.something", "MicroProfile"), options.serversComboBoxModel);
        versionsComboBox.setMinimumAndPreferredWidth(150);
        serversComboBox.setMinimumAndPreferredWidth(150);
        this.registerTextComponentValidation((JTextField)this.myGroupField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY, StartersValidationUtils.CHECK_NO_WHITESPACES, StartersValidationUtils.CHECK_NO_RESERVED_WORDS});
        this.registerTextComponentValidation((JTextField)this.myArtifactField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY, StartersValidationUtils.CHECK_NO_WHITESPACES, StartersValidationUtils.CHECK_NO_RESERVED_WORDS});
    }

    protected void setInitialFocus(JBLoadingPanel settingsPanel) {
        this.myGroupField.selectAll();
        IdeFocusManager.findInstanceByComponent((Component)settingsPanel).requestFocus((Component)this.myGroupField, true);
    }

    public void updateDataModel() {
        super.updateDataModel();
        MicroprofileOptions options = (MicroprofileOptions)this.myBuilder.getOptions();
        options.group = this.myGroupField.getText();
        options.artifact = this.myArtifactField.getText();
    }
}

