/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.manager;

import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.beans.FieldProducerBeanDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.MethodProducerBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdiDescriptorsFactory {
    private CdiDescriptorsFactory() {
    }

    @NotNull
    public static CdiBeanPsiClassDescriptor createCdiBeanDescriptor(PsiClass psiClass) {
        return new ManagedBeanDescriptor(psiClass);
    }

    @Nullable
    public static ProducerBeanDescriptor<? extends PsiMember> createProducerCdiBeanDescriptor(@NotNull PsiMember member) {
        if (member == null) {
            CdiDescriptorsFactory.$$$reportNull$$$0(0);
        }
        if (CdiAnnoConstants.PRODUCES_ANNOTATION.isAnnotated((PsiModifierListOwner)member, 1)) {
            if (member instanceof PsiMethod) {
                return new MethodProducerBeanDescriptor((PsiMethod)member);
            }
            if (member instanceof PsiField) {
                return new FieldProducerBeanDescriptor((PsiField)member);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/cdi/manager/CdiDescriptorsFactory", "createProducerCdiBeanDescriptor"));
    }
}

