/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.jam.interceptor;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.jam.JamElement;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ref.AnnotationChildLink;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CdiInterceptor
implements JamElement {
    public static final JamClassMeta<CdiInterceptor> META = new JamClassMeta(CdiInterceptor.class);
    private final PsiClass myClass;
    private final PsiElementRef<PsiAnnotation> myAnno;

    public CdiInterceptor(PsiClass psiClass) {
        this.myClass = psiClass;
        this.myAnno = AnnotationChildLink.createRef((PsiModifierListOwner)psiClass, (String)CdiAnnoConstants.INTERCEPTOR_ANNOTATION.fqnFromAnnotated((PsiModifierListOwner)psiClass));
    }

    public Set<PsiClass> getInterceptorBindingTypes() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getPsiElement());
        if (module == null) {
            return Collections.emptySet();
        }
        return CdiCommonUtils.getInterceptorBindingTypesClasses((PsiModifierListOwner)this.getPsiElement(), module);
    }

    @NotNull
    public PsiClass getPsiElement() {
        PsiClass psiClass = this.myClass;
        if (psiClass == null) {
            CdiInterceptor.$$$reportNull$$$0(0);
        }
        return psiClass;
    }

    @JamPsiValidity
    public abstract boolean isPsiValid();

    @Nullable
    public PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.myAnno.getPsiElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/interceptor/CdiInterceptor", "getPsiElement"));
    }
}

