/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.jam;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetUtil;
import com.intellij.psi.util.PropertyUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CdiNamedBean<T extends PsiMember & PsiNamedElement>
implements JamElement {
    private static final JamStringAttributeMeta.Single<String> NAME_VALUE_META = JamAttributeMeta.singleString((String)"value");
    private final JamAnnotationMeta myMeta;
    private final T myMember;
    private final boolean isStereotype;

    public CdiNamedBean(T psiMember, String annoName) {
        this.myMember = psiMember;
        this.myMeta = new JamAnnotationMeta(annoName);
        this.isStereotype = !CdiAnnoConstants.NAMED_ANNOTATION.javax().equals(annoName) && !CdiAnnoConstants.NAMED_ANNOTATION.jakarta().equals(annoName);
    }

    public boolean isStereotypeAnnotated() {
        return this.isStereotype;
    }

    @NotNull
    public String getName() {
        if (this.isStereotypeAnnotated()) {
            String string = this.getDefaultName();
            if (string == null) {
                CdiNamedBean.$$$reportNull$$$0(0);
            }
            return string;
        }
        String nameValue = this.getNamedStringAttributeElement().getStringValue();
        String string = StringUtil.isEmptyOrSpaces((String)nameValue) ? this.getDefaultName() : nameValue;
        if (string == null) {
            CdiNamedBean.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private JamStringAttributeElement<String> getNamedStringAttributeElement() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)this.myMeta.getAttribute(this.myMember, NAME_VALUE_META);
        if (jamStringAttributeElement == null) {
            CdiNamedBean.$$$reportNull$$$0(2);
        }
        return jamStringAttributeElement;
    }

    public abstract String getDefaultName();

    @Nullable
    public abstract PsiType getType();

    public PsiNamedElement getIdentifyingPsiElement() {
        return (PsiNamedElement)PomService.convertToPsi((Project)this.myMember.getProject(), (PomTarget)this.getPsiTarget());
    }

    public PsiTarget getPsiTarget() {
        JamStringAttributeElement<String> namedAttributeValue = this.getNamedStringAttributeElement();
        if (StringUtil.isEmptyOrSpaces((String)namedAttributeValue.getStringValue())) {
            return this.getAliasingPsiTarget();
        }
        return new JamPomTarget((JamElement)this, namedAttributeValue);
    }

    protected abstract PsiTarget getAliasingPsiTarget();

    @NotNull
    public T getPsiElement() {
        T t = this.myMember;
        if (t == null) {
            CdiNamedBean.$$$reportNull$$$0(3);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/cdi/jam/CdiNamedBean";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedStringAttributeElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class FieldMapping
    extends CdiNamedBean<PsiField> {
        public FieldMapping(PsiField psiField, String annoName) {
            super(psiField, annoName);
        }

        @Override
        public String getDefaultName() {
            return ((PsiField)this.getPsiElement()).getName();
        }

        @Override
        @Nullable
        public PsiType getType() {
            return ((PsiField)this.getPsiElement()).getType();
        }

        @Override
        protected PsiTarget getAliasingPsiTarget() {
            return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

                @NotNull
                public String getNameAlias(@NotNull String delegatePsiTargetName) {
                    if (delegatePsiTargetName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = StringUtil.decapitalize((String)delegatePsiTargetName);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @NotNull
                public AliasingPsiTarget setAliasName(@NotNull String newAliasName) {
                    if (newAliasName == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    AliasingPsiTargetUtil.renameTargets((AliasingPsiTarget)this, (String)newAliasName);
                    AliasingPsiTarget aliasingPsiTarget = super.setAliasName(newAliasName);
                    if (aliasingPsiTarget == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return aliasingPsiTarget;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "delegatePsiTargetName";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/cdi/jam/CdiNamedBean$FieldMapping$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newAliasName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/cdi/jam/CdiNamedBean$FieldMapping$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNameAlias";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "setAliasName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getNameAlias";
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "setAliasName";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
    }

    public static class MethodMapping
    extends CdiNamedBean<PsiMethod> {
        public MethodMapping(PsiMethod method, String annoName) {
            super(method, annoName);
        }

        @Override
        public String getDefaultName() {
            String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)this.getPsiElement()));
            return propertyName == null ? ((PsiMethod)this.getPsiElement()).getName() : propertyName;
        }

        @Override
        @Nullable
        public PsiType getType() {
            return ((PsiMethod)this.getPsiElement()).getReturnType();
        }

        @Override
        protected PsiTarget getAliasingPsiTarget() {
            return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

                public String getNameAlias(@NotNull String delegatePsiTargetName) {
                    String propertyName;
                    if (delegatePsiTargetName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return StringUtil.isEmptyOrSpaces((String)(propertyName = PropertyUtilBase.getPropertyName((String)delegatePsiTargetName))) ? super.getNameAlias(delegatePsiTargetName) : propertyName;
                }

                @NotNull
                public AliasingPsiTarget setAliasName(@NotNull String newAliasName) {
                    if (newAliasName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    AliasingPsiTargetUtil.renameTargets((AliasingPsiTarget)this, (String)newAliasName);
                    AliasingPsiTarget aliasingPsiTarget = super.setAliasName(newAliasName);
                    if (aliasingPsiTarget == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return aliasingPsiTarget;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "delegatePsiTargetName";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newAliasName";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/cdi/jam/CdiNamedBean$MethodMapping$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/cdi/jam/CdiNamedBean$MethodMapping$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "setAliasName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getNameAlias";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "setAliasName";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
    }

    public static class ClassMapping
    extends CdiNamedBean<PsiClass> {
        public ClassMapping(PsiClass psiClass, String annoName) {
            super(psiClass, annoName);
        }

        @Override
        public String getDefaultName() {
            return StringUtil.decapitalize((String)StringUtil.notNullize((String)((PsiClass)this.getPsiElement()).getName()));
        }

        @Override
        @NotNull
        public PsiType getType() {
            PsiClass psiClass = (PsiClass)this.getPsiElement();
            PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass);
            if (psiClassType == null) {
                ClassMapping.$$$reportNull$$$0(0);
            }
            return psiClassType;
        }

        @Override
        protected PsiTarget getAliasingPsiTarget() {
            return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

                @NotNull
                public String getNameAlias(@NotNull String delegatePsiTargetName) {
                    if (delegatePsiTargetName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = StringUtil.decapitalize((String)delegatePsiTargetName);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @NotNull
                public AliasingPsiTarget setAliasName(@NotNull String newAliasName) {
                    if (newAliasName == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    AliasingPsiTargetUtil.renameTargets((AliasingPsiTarget)this, (String)StringUtil.capitalize((String)newAliasName));
                    AliasingPsiTarget aliasingPsiTarget = super.setAliasName(newAliasName);
                    if (aliasingPsiTarget == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return aliasingPsiTarget;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "delegatePsiTargetName";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/cdi/jam/CdiNamedBean$ClassMapping$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newAliasName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/cdi/jam/CdiNamedBean$ClassMapping$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNameAlias";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "setAliasName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getNameAlias";
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "setAliasName";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/jam/CdiNamedBean$ClassMapping", "getType"));
        }
    }
}

