/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.constants.CdiClassesConstants;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CdiInjectionPointsInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass psiClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiClass == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(2);
        }
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints(psiClass);
        for (InjectionPointDescriptor injectionPoint : injectionPoints) {
            if (!CdiInjectionPointsInspection.isInjectionPointDefinedInClass(psiClass, injectionPoint)) continue;
            CdiInjectionPointsInspection.checkInjectionPointAmbiguousDependency(injectionPoint, holder);
            CdiInjectionPointsInspection.checkNewAnnotationInjectionPoint(injectionPoint, holder, module);
        }
    }

    private static boolean isInjectionPointDefinedInClass(@NotNull PsiClass psiClass, @NotNull InjectionPointDescriptor ip) {
        if (psiClass == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(3);
        }
        if (ip == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(4);
        }
        PsiModifierListOwner owner = ip.getOwner();
        return psiClass.equals(PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class));
    }

    private static void checkNewAnnotationInjectionPoint(@NotNull InjectionPointDescriptor injectionPoint, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (injectionPoint == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(6);
        }
        if (module == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(7);
        }
        JavaeeType javaee = JavaeeType.discover((Module)module, (JavaeeClass)CdiAnnoConstants.INJECT_ANNOTATION);
        PsiAnnotation newAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)injectionPoint.getOwner(), (String[])new String[]{CdiAnnoConstants.NEW_ANNOTATION.fqn(javaee)});
        if (newAnnotation != null) {
            for (PsiAnnotation psiAnnotation : injectionPoint.getQualifierAnnotations()) {
                String s = psiAnnotation.getQualifiedName();
                if (CdiAnnoConstants.NAMED_ANNOTATION.fqn(javaee).equals(s) || CdiAnnoConstants.NEW_ANNOTATION.fqn(javaee).equals(s)) continue;
                holder.registerProblem((PsiElement)newAnnotation, CdiInspectionBundle.message("CdiInspectionPointsInspection.new.annotation.with.other.qualifiers", new Object[0]), new LocalQuickFix[0]);
                break;
            }
        }
    }

    private static void checkInjectionPointAmbiguousDependency(@NotNull InjectionPointDescriptor injectionPoint, ProblemsHolder holder) {
        if (injectionPoint == null) {
            CdiInjectionPointsInspection.$$$reportNull$$$0(8);
        }
        PsiType type = injectionPoint.getType();
        PsiModifierListOwner modifierListOwner = injectionPoint.getOwner();
        if (type != null) {
            String typeCanonicalText = type.getCanonicalText();
            if (typeCanonicalText.startsWith(CdiClassesConstants.EVENT.fqn((PsiElement)modifierListOwner))) {
                return;
            }
            if (typeCanonicalText.startsWith(CdiClassesConstants.CONVERSATION_CLASS.fqn((PsiElement)modifierListOwner))) {
                return;
            }
            if (typeCanonicalText.startsWith(CdiClassesConstants.INJECTION_POINT_CLASS.fqn((PsiElement)modifierListOwner)) && injectionPoint.getQualifierAnnotations().length == 0) {
                return;
            }
            Set builtInClasses = ContainerUtil.map2Set(CdiManager.BUILD_IN_CLASSES, aClass -> aClass.fqn((PsiElement)modifierListOwner));
            for (String className : builtInClasses) {
                if (!typeCanonicalText.equals(className)) continue;
                return;
            }
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)CdiClassesConstants.ENTERPRISE_INJECT_INSTANCE.fqn((PsiElement)modifierListOwner))) {
            return;
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)CdiClassesConstants.INTERCEPTION_FACTORY.fqn((PsiElement)modifierListOwner))) {
            return;
        }
        PsiModifierListOwner owner = injectionPoint.getOwner();
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)CdiAnnoConstants.DELEGATE_ANNOTATION.fqn((PsiElement)modifierListOwner), (int)1) || AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"org.eclipse.microprofile.config.inject.ConfigProperty", (int)0)) {
            return;
        }
        Collection<CdiBeanDescriptor<?>> injectedBeans = CdiInjectionUtils.getInjectedBeans(injectionPoint);
        if (owner instanceof PsiVariable) {
            owner = ((PsiVariable)owner).getNameIdentifier();
        }
        if (owner == null) {
            return;
        }
        if (injectedBeans.size() == 0) {
            holder.registerProblem((PsiElement)owner, CdiInspectionBundle.message("CdiInspectionPointsInspection.unsatisfied.dependency", new Object[0]), new LocalQuickFix[0]);
        } else if (injectedBeans.size() > 1) {
            holder.registerProblem((PsiElement)owner, CdiInspectionBundle.message("CdiInspectionPointsInspection.ambiguous.dependency", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ip";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPoint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/highlighting/CdiInjectionPointsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInjectionPointDefinedInClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNewAnnotationInjectionPoint";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInjectionPointAmbiguousDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

