/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CdiBaseInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CdiBaseInspection.$$$reportNull$$$0(0);
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)holder.getFile()) || InspectionValidatorWrapper.isCompilationThread()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                CdiBaseInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile());
        if (module == null || !CdiCommonUtils.isCdiInstalled(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                CdiBaseInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            CdiBaseInspection.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Module module;
        if (file == null) {
            CdiBaseInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            CdiBaseInspection.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        this.checkJavaFile((PsiJavaFile)file, holder, module);
        List problemDescriptors = holder.getResults();
        return problemDescriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (javaFile == null) {
            CdiBaseInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            CdiBaseInspection.$$$reportNull$$$0(7);
        }
        if (module == null) {
            CdiBaseInspection.$$$reportNull$$$0(8);
        }
        for (PsiClass psiClass : javaFile.getClasses()) {
            this.checkClassInternal(psiClass, holder, module);
        }
    }

    private void checkClassInternal(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            CdiBaseInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            CdiBaseInspection.$$$reportNull$$$0(10);
        }
        if (module == null) {
            CdiBaseInspection.$$$reportNull$$$0(11);
        }
        this.checkClass(aClass, holder, module);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            this.checkClass(psiClass, holder, module);
        }
    }

    protected void checkClass(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            CdiBaseInspection.$$$reportNull$$$0(12);
        }
        if (holder == null) {
            CdiBaseInspection.$$$reportNull$$$0(13);
        }
        if (module == null) {
            CdiBaseInspection.$$$reportNull$$$0(14);
        }
        if (CdiCommonUtils.isManagedBean(aClass)) {
            Set<CdiBeanDescriptor<?>> descriptors = CdiManager.resolveBeanByClass(module, aClass, new PsiAnnotation[0]);
            for (CdiBeanDescriptor<?> descriptor : descriptors) {
                this.checkBeanDescriptor(descriptor, holder);
                if (!(descriptor instanceof ManagedBeanDescriptor)) continue;
                for (ProducerBeanDescriptor<?> producerBeanDescriptor : ((ManagedBeanDescriptor)descriptor).getProducerDescriptors()) {
                    this.checkBeanDescriptor(producerBeanDescriptor, holder);
                }
            }
        }
    }

    protected void checkBeanDescriptor(CdiBeanDescriptor<?> descriptor, ProblemsHolder holder) {
        if (descriptor instanceof ManagedBeanDescriptor) {
            this.checkManagedBean((ManagedBeanDescriptor)descriptor, holder);
        } else if (descriptor instanceof ProducerBeanDescriptor) {
            this.checkProducerBeanDescriptor((ProducerBeanDescriptor)descriptor, holder);
        }
    }

    protected void checkProducerBeanDescriptor(ProducerBeanDescriptor<?> producerBeanDescriptor, ProblemsHolder holder) {
    }

    protected void checkManagedBean(ManagedBeanDescriptor descriptor, ProblemsHolder holder) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiBaseInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFile";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiBaseInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkJavaFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkClassInternal";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

