/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.gutter;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.daemon.GutterName;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import icons.JavaUltimateIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdiAnnotationsLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @GutterName
    public String getName() {
        return CdiBundle.message("cdi.annotations.gutter.name", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Cdi.Cdi;
        if (icon == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (elements.isEmpty()) {
            return;
        }
        Project project = elements.get(0).getProject();
        if (CdiAnnotationsLineMarkerProvider.getToolWindow(project) == null) {
            return;
        }
        for (PsiElement psiElement : elements) {
            Module module;
            PsiElement parent;
            PsiElement grandParent;
            if (!(psiElement instanceof PsiIdentifier) || !((grandParent = (parent = psiElement.getParent()) != null ? parent.getParent() : null) instanceof PsiAnnotation) || (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement)) != null && !CdiCommonUtils.isCdiInstalled(module)) continue;
            CdiAnnotationsLineMarkerProvider.annotatePsiAnnotation(project, module, result, (PsiAnnotation)grandParent, psiElement);
        }
    }

    private static void annotatePsiAnnotation(@NotNull Project project, @Nullable Module module, Collection<? super LineMarkerInfo<?>> result, @NotNull PsiAnnotation annotation, @NotNull PsiElement psiElement) {
        if (project == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (annotation == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (psiElement == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (!(annotation.getOwner() instanceof PsiModifierList)) {
            return;
        }
        PsiModifierList modifierList = (PsiModifierList)annotation.getOwner();
        if (!(modifierList.getParent() instanceof PsiClass)) {
            return;
        }
        PsiClass owner = (PsiClass)modifierList.getParent();
        if (owner.isAnnotationType() || owner.isEnum() || owner.isRecord() || owner.isInterface()) {
            return;
        }
        String qualifiedName = annotation.getQualifiedName();
        if (CdiAnnoConstants.NAMED_ANNOTATION.isFqn(qualifiedName)) {
            result.add(CdiAnnotationsLineMarkerProvider.createLineMarker(psiElement, project));
        } else if (CdiAnnotationsLineMarkerProvider.isScopeOrStereotypeAnnotation(module, qualifiedName) && !CdiAnnoConstants.NAMED_ANNOTATION.isAnnotated((PsiModifierListOwner)owner, 0)) {
            result.add(CdiAnnotationsLineMarkerProvider.createLineMarker(psiElement, project));
        }
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createLineMarker(@NotNull PsiElement psiElement, @NotNull Project project) {
        if (psiElement == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (project == null) {
            CdiAnnotationsLineMarkerProvider.$$$reportNull$$$0(8);
        }
        return new LineMarkerInfo(psiElement, psiElement.getTextRange(), JavaUltimateIcons.Cdi.Gutter.Cdi, el -> CdiBundle.message("cdi.open.tool.window", new Object[0]), (e, elt) -> {
            ToolWindow toolWindow = CdiAnnotationsLineMarkerProvider.getToolWindow(project);
            if (toolWindow != null) {
                toolWindow.activate(null);
            }
        }, GutterIconRenderer.Alignment.RIGHT, CdiBundle.messagePointer("cdi.open.tool.window", new Object[0]));
    }

    @Nullable
    public static ToolWindow getToolWindow(Project project) {
        return ToolWindowManager.getInstance((Project)project).getToolWindow("CDI");
    }

    private static boolean isScopeOrStereotypeAnnotation(@Nullable Module module, @Nullable String qualifiedName) {
        if (qualifiedName == null) {
            return false;
        }
        if (module == null) {
            return CdiAnnoConstants.SINGLETON_ANNOTATION.isFqn(qualifiedName) || CdiAnnoConstants.MODEL_ANNOTATION.isFqn(qualifiedName) || CdiAnnoConstants.REQUEST_SCOPED_ANNOTATION.isFqn(qualifiedName) || CdiAnnoConstants.APPLICATION_SCOPED_ANNOTATION.isFqn(qualifiedName) || CdiAnnoConstants.SESSION_SCOPED_ANNOTATION.isFqn(qualifiedName) || CdiAnnoConstants.CONVERSATION_SCOPED_ANNOTATION.isFqn(qualifiedName) || CdiAnnoConstants.NORMAL_SCOPE_ANNOTATION.isFqn(qualifiedName) || CdiAnnoConstants.TRANSACTION_SCOPED_ANNOTATION.isFqn(qualifiedName);
        }
        return CdiCommonUtils.getNormalScopeQualifiedNames(module).contains(qualifiedName) || CdiCommonUtils.getStereotypeAnnotationNames(module).contains(qualifiedName) || CdiCommonUtils.getScopeQualifiedNames(module).contains(qualifiedName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/gutter/CdiAnnotationsLineMarkerProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/gutter/CdiAnnotationsLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "annotatePsiAnnotation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

