/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.diagram.managers;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class CdiDiagramVfsResolver
implements DiagramVfsResolver<CdiBeanDescriptor<?>> {
    private static final String CLASS_NAME = "class";
    private static final String FIELD_NAME = "field";
    private static final String METHOD_NAME = "method";
    private static final String SEPARATOR = "#";
    private static final String NO_FQN = "<NO QUALIFIED NAME>";

    @Nullable
    public String getQualifiedName(CdiBeanDescriptor element) {
        PsiMember psiMember;
        PsiClass containingClass;
        Object identifyingElement = element.getIdentifyingElement();
        if (identifyingElement instanceof PsiClass) {
            return ((PsiClass)identifyingElement).getQualifiedName();
        }
        if (identifyingElement instanceof PsiMember && (containingClass = (psiMember = (PsiMember)identifyingElement).getContainingClass()) != null) {
            String name = psiMember.getName();
            if (psiMember instanceof PsiField) {
                return "class=" + containingClass.getQualifiedName() + "#field=" + name;
            }
            if (psiMember instanceof PsiMethod) {
                return "class=" + containingClass.getQualifiedName() + "#method=" + name;
            }
        }
        return NO_FQN;
    }

    public CdiBeanDescriptor<?> resolveElementByFQN(String fqn, Project project) {
        if (NO_FQN.equals(fqn)) {
            return null;
        }
        if (fqn.contains(SEPARATOR)) {
            return CdiDiagramVfsResolver.resolvePsiMember(fqn, project);
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        return aClass != null ? CdiDescriptorsFactory.createCdiBeanDescriptor(aClass) : null;
    }

    @Nullable
    private static CdiBeanDescriptor<?> resolvePsiMember(String fqn, Project project) {
        PsiClass aClass;
        Map<String, String> pairs = CdiDiagramVfsResolver.split(fqn);
        String className = pairs.get(CLASS_NAME);
        if (className != null && (aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project))) != null) {
            String fieldName = pairs.get(FIELD_NAME);
            if (fieldName != null) {
                PsiField psiField = aClass.findFieldByName(fieldName, true);
                if (psiField != null) {
                    return CdiDescriptorsFactory.createProducerCdiBeanDescriptor((PsiMember)psiField);
                }
            } else {
                String method = pairs.get(METHOD_NAME);
                if (method != null) {
                    PsiMethod[] methods;
                    for (PsiMethod psiMethod : methods = aClass.findMethodsByName(method, true)) {
                        ProducerBeanDescriptor<? extends PsiMember> producerBeanDescriptor = CdiDescriptorsFactory.createProducerCdiBeanDescriptor((PsiMember)psiMethod);
                        if (producerBeanDescriptor == null) continue;
                        return producerBeanDescriptor;
                    }
                }
            }
        }
        return null;
    }

    public static Map<String, String> split(String fqn) {
        List strings = StringUtil.split((String)fqn, (String)SEPARATOR);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : strings) {
            Couple<String> pair = CdiDiagramVfsResolver.getPair(string);
            if (pair == null) continue;
            map.put((String)pair.first, (String)pair.second);
        }
        return map;
    }

    public static Couple<String> getPair(String str) {
        int i = str.indexOf("=");
        if (i > 0 && i < str.length() - 1) {
            String key = str.substring(0, i).trim();
            String value = str.substring(i + 1).trim();
            if (!StringUtil.isEmptyOrSpaces((String)key) && !StringUtil.isEmptyOrSpaces((String)value)) {
                return Couple.of((Object)key, (Object)value);
            }
        }
        return null;
    }
}

