/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.diagram.managers;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.diagram.edges.CdiInjectionPointEdge;
import com.intellij.cdi.diagram.edges.CdiProducerEdge;
import com.intellij.cdi.diagram.utils.CdiDiagramCommonUtils;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.actions.DiagramDefaultAddElementAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CdiDiagramExtras
extends DiagramExtras<CdiBeanDescriptor<?>> {
    public Object getData(@NotNull String dataId, List<DiagramNode<CdiBeanDescriptor<?>>> diagramNodes, DiagramBuilder builder) {
        if (dataId == null) {
            CdiDiagramExtras.$$$reportNull$$$0(0);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            if (diagramNodes != null && diagramNodes.size() > 0) {
                CdiBeanDescriptor wrapper = (CdiBeanDescriptor)diagramNodes.get(0).getIdentifyingElement();
                Object wrapped = wrapper.getIdentifyingElement();
                if (wrapped != null) {
                    return wrapped;
                }
            } else {
                List edges = DiagramUtils.getSelectedEdges((DiagramBuilder)builder);
                if (edges.size() == 1) {
                    DiagramEdge edge = (DiagramEdge)edges.get(0);
                    PsiModifierListOwner psiElement = null;
                    if (edge instanceof CdiInjectionPointEdge) {
                        psiElement = ((CdiInjectionPointEdge)edge).getInjectionPointDescriptor().getOwner();
                    }
                    if (edge instanceof CdiProducerEdge) {
                        psiElement = ((CdiProducerEdge)edge).getPsiMember();
                    }
                    if (psiElement != null) {
                        return psiElement;
                    }
                }
            }
        }
        return super.getData(dataId, diagramNodes, builder);
    }

    public String suggestDiagramFileName(CdiBeanDescriptor element) {
        return CdiDiagramCommonUtils.getNodeName(element);
    }

    public DiagramAddElementAction getAddElementHandler() {
        return new DiagramDefaultAddElementAction(){

            @NotNull
            protected Object convertElement(@NotNull Object element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiClass) {
                    CdiBeanPsiClassDescriptor cdiBeanPsiClassDescriptor = CdiDescriptorsFactory.createCdiBeanDescriptor((PsiClass)element);
                    if (cdiBeanPsiClassDescriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return cdiBeanPsiClassDescriptor;
                }
                Object object = super.convertElement(element);
                if (object == null) {
                    1.$$$reportNull$$$0(2);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/cdi/diagram/managers/CdiDiagramExtras$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/cdi/diagram/managers/CdiDiagramExtras$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convertElement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public DiagramDnDProvider<CdiBeanDescriptor<?>> getDnDProvider() {
        return new DiagramDnDProvider<CdiBeanDescriptor<?>>(){

            public boolean isAcceptedForDnD(Object o, Project project) {
                return o instanceof PsiClass;
            }

            public CdiBeanDescriptor<?>[] wrapToModelObject(Object o, Project project) {
                if (o instanceof PsiClass) {
                    return new CdiBeanDescriptor[]{CdiDescriptorsFactory.createCdiBeanDescriptor((PsiClass)o)};
                }
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/cdi/diagram/managers/CdiDiagramExtras", "getData"));
    }
}

