/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.diagram.managers;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.beans.CdiExtensionBeanDescriptor;
import com.intellij.cdi.beans.FieldProducerBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.beans.ManagedBeanDescriptor;
import com.intellij.cdi.beans.MethodProducerBeanDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.gutter.PsiMethodCallExpressionCellRenderer;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import icons.JavaUltimateIcons;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiDiagramElementManager
extends AbstractDiagramElementManager<CdiBeanDescriptor<?>> {
    public CdiBeanDescriptor<?> findInDataContext(DataContext context) {
        PsiClass aClass;
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        if (module != null && CdiCommonUtils.isCdiInstalled(module) && (aClass = CdiDiagramElementManager.getTargetBeanClass(context)) != null) {
            return CdiDescriptorsFactory.createCdiBeanDescriptor(aClass);
        }
        return null;
    }

    @Nullable
    private static PsiClass getTargetBeanClass(DataContext context) {
        PsiClass aClass;
        PsiClass[] classes;
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (psiClass != null) {
            return psiClass;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (psiFile instanceof PsiJavaFile && (classes = ((PsiJavaFile)psiFile).getClasses()).length == 1) {
            return classes[0];
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null && (aClass = CdiDiagramElementManager.getTargetClass(editor)) != null) {
            return aClass;
        }
        return null;
    }

    @Nullable
    private static PsiClass getTargetClass(Editor editor) {
        PsiElement element = TargetElementUtil.getInstance().findTargetElement(editor, 3, editor.getCaretModel().getOffset());
        if (element instanceof PsiClass) {
            return (PsiClass)element;
        }
        return element == null ? null : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof CdiBeanDescriptor;
    }

    public String getElementTitle(CdiBeanDescriptor element) {
        Object identifyingElement = element.getIdentifyingElement();
        if (identifyingElement instanceof PsiClass) {
            return ((PsiClass)identifyingElement).getName();
        }
        if (identifyingElement instanceof PsiMember) {
            PsiClass containingClass = ((PsiMember)identifyingElement).getContainingClass();
            return containingClass != null ? containingClass.getName() : "";
        }
        if (identifyingElement instanceof PsiMethodCallExpression) {
            return PsiMethodCallExpressionCellRenderer.elementText((PsiMethodCallExpression)identifyingElement);
        }
        return CdiBundle.message("cdi.diagram.unknown.element", new Object[0]);
    }

    public SimpleColoredText getItemName(Object obj, DiagramState presentation) {
        PsiField psiField;
        PsiType type;
        PsiMethod psiMethod;
        PsiClass psiClass;
        if (obj instanceof CdiBeanPsiClassDescriptor && (psiClass = ((CdiBeanPsiClassDescriptor)obj).getAnnotatedItem()).isValid()) {
            return new SimpleColoredText(psiClass.getName(), DEFAULT_TITLE_ATTR);
        }
        if (obj instanceof MethodProducerBeanDescriptor && (psiMethod = ((MethodProducerBeanDescriptor)obj).getAnnotatedItem()).isValid() && (type = psiMethod.getReturnType()) != null) {
            return new SimpleColoredText(type.getPresentableText(), DEFAULT_TITLE_ATTR);
        }
        if (obj instanceof FieldProducerBeanDescriptor && (psiField = ((FieldProducerBeanDescriptor)obj).getAnnotatedItem()).isValid()) {
            return new SimpleColoredText(psiField.getType().getPresentableText(), DEFAULT_TITLE_ATTR);
        }
        if (obj instanceof PsiMethod) {
            return CdiDiagramElementManager.getMethodPresentableName((PsiMethod)obj);
        }
        if (obj instanceof PsiField) {
            return CdiDiagramElementManager.getFieldPresentableName((PsiField)obj);
        }
        if (obj instanceof InjectionPointDescriptor) {
            InjectionPointDescriptor ip = (InjectionPointDescriptor)obj;
            PsiModifierListOwner owner = ip.getOwner();
            if (owner instanceof PsiField) {
                return CdiDiagramElementManager.getFieldPresentableName((PsiField)owner);
            }
            if (owner instanceof PsiParameter) {
                return CdiDiagramElementManager.getParameterPresentableName((PsiParameter)owner);
            }
        }
        return null;
    }

    private static SimpleColoredText getMethodPresentableName(PsiMethod method) {
        int style = 0;
        if (method.isDeprecated()) {
            style |= 4;
        }
        if (!method.isPhysical()) {
            style |= 2;
        }
        SimpleColoredText text = new SimpleColoredText();
        text.append(CdiDiagramElementManager.getMethodSignature(method), new SimpleTextAttributes(style, JBColor.foreground()));
        return text;
    }

    private static SimpleColoredText getParameterPresentableName(@NotNull PsiParameter psiParameter) {
        if (psiParameter == null) {
            CdiDiagramElementManager.$$$reportNull$$$0(0);
        }
        SimpleColoredText text = new SimpleColoredText();
        int style = 0;
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiParameter, PsiMethod.class);
        assert (psiMethod != null);
        text.append(psiMethod.getName(), new SimpleTextAttributes(style, JBColor.foreground()));
        text.append("(", new SimpleTextAttributes(style, JBColor.foreground()));
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            String s = parameter.getType().getPresentableText();
            if (psiParameter.equals(parameter)) {
                text.append(s, new SimpleTextAttributes(style | 1, JBColor.foreground()));
            } else {
                text.append(s, new SimpleTextAttributes(style, JBColor.foreground()));
            }
            if (i == parameters.length - 1) continue;
            text.append(", ", new SimpleTextAttributes(style, JBColor.foreground()));
        }
        text.append(")", new SimpleTextAttributes(style, JBColor.foreground()));
        return text;
    }

    private static SimpleColoredText getFieldPresentableName(@NotNull PsiField field) {
        if (field == null) {
            CdiDiagramElementManager.$$$reportNull$$$0(1);
        }
        int style = 0;
        if (field.isDeprecated()) {
            style |= 4;
        }
        if (!field.isPhysical()) {
            style |= 2;
        }
        return new SimpleColoredText(field.getName(), new SimpleTextAttributes(style, JBColor.foreground()));
    }

    @NlsSafe
    public static String getMethodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            CdiDiagramElementManager.$$$reportNull$$$0(2);
        }
        StringBuilder signature = new StringBuilder(method.getName());
        signature.append("(");
        for (PsiParameter param : method.getParameterList().getParameters()) {
            signature.append(param.getType().getPresentableText());
            signature.append(", ");
        }
        if (method.getParameterList().getParameters().length != 0) {
            signature.delete(signature.length() - 2, signature.length());
        }
        signature.append(")");
        return signature.toString();
    }

    public SimpleColoredText getItemType(Object element) {
        PsiType type = null;
        if (element instanceof PsiField) {
            type = ((PsiField)element).getType();
        } else if (element instanceof PsiMethod) {
            type = ((PsiMethod)element).getReturnType();
        } else if (element instanceof InjectionPointDescriptor) {
            PsiMethod psiMethod;
            PsiModifierListOwner owner = ((InjectionPointDescriptor)element).getOwner();
            if (owner instanceof PsiField) {
                type = ((PsiField)owner).getType();
            } else if (owner instanceof PsiParameter && (psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiMethod.class)) != null) {
                type = psiMethod.getReturnType();
            }
        }
        if (type == null) {
            return null;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        int style = 0;
        if (psiClass != null && psiClass.isDeprecated()) {
            style |= 4;
        }
        return new SimpleColoredText(type.getPresentableText(), new SimpleTextAttributes(style | 1, JBColor.foreground()));
    }

    @Nullable
    public String getNodeTooltip(CdiBeanDescriptor element) {
        if (element instanceof CdiBeanPsiClassDescriptor) {
            PsiClass psiClass = (PsiClass)((CdiBeanPsiClassDescriptor)element).getIdentifyingElement();
            @NlsSafe StringBuilder buffer = new StringBuilder();
            buffer.append("<html>");
            PsiModifierList modifierList = psiClass.getModifierList();
            if (modifierList != null) {
                for (PsiAnnotation psiAnnotation : modifierList.getAnnotations()) {
                    String fqName = psiAnnotation.getQualifiedName();
                    if (fqName == null) continue;
                    buffer.append("@");
                    buffer.append(StringUtil.getShortName((String)fqName));
                    buffer.append("<br>");
                }
            }
            buffer.append(psiClass.getQualifiedName());
            return buffer.toString();
        }
        if (element instanceof CdiExtensionBeanDescriptor) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element.getIdentifyingElement();
            @NlsSafe StringBuilder buffer = new StringBuilder();
            buffer.append("<html>");
            buffer.append("<b>");
            buffer.append(PsiMethodCallExpressionCellRenderer.elementText(callExpression));
            buffer.append("</b>");
            buffer.append("<br>");
            buffer.append(PsiMethodCallExpressionCellRenderer.containerText(callExpression));
            buffer.append("</html>");
            return buffer.toString();
        }
        return null;
    }

    public Icon getItemIcon(Object element, DiagramState presentation) {
        if (element instanceof InjectionPointDescriptor) {
            return AllIcons.Nodes.Plugin;
        }
        if (element instanceof PsiMember && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (String)CdiAnnoConstants.PRODUCES_ANNOTATION.fqn((PsiElement)((PsiMember)element)), (int)1)) {
            return JavaUltimateIcons.Cdi.BeanFactory;
        }
        return super.getItemIcon(element, presentation);
    }

    public Object[] getNodeItems(CdiBeanDescriptor parent) {
        ManagedBeanDescriptor beanDescriptor;
        PsiClass psiClass;
        HashSet<Object> children = new HashSet<Object>();
        if (parent instanceof ManagedBeanDescriptor && (psiClass = (beanDescriptor = (ManagedBeanDescriptor)parent).getAnnotatedItem()).isValid()) {
            children.addAll(beanDescriptor.getProducerFields());
            children.addAll(beanDescriptor.getProducerMethods());
            children.addAll(CdiInjectionUtils.getInjectionPoints(psiClass));
        }
        return ArrayUtil.toObjectArray(children);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/diagram/managers/CdiDiagramElementManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodSignature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

