/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.diagram;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.beans.ProducerBeanDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.constants.CdiClassesConstants;
import com.intellij.cdi.diagram.actions.CreateDependencyEdgeType;
import com.intellij.cdi.diagram.edges.CdiDiagramEdge;
import com.intellij.cdi.diagram.edges.CdiInjectionPointEdge;
import com.intellij.cdi.diagram.edges.CdiProducerEdge;
import com.intellij.cdi.diagram.managers.CdiDiagramCategoryManager;
import com.intellij.cdi.diagram.nodes.CdiDiagramNode;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.resources.CdiBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiDiagramDataModel
extends DiagramDataModel<CdiBeanDescriptor<?>> {
    private final CdiBeanDescriptor<?> myElement;
    private final Collection<DiagramNode<CdiBeanDescriptor<?>>> myNodes = new HashSet();
    private final Collection<DiagramEdge<CdiBeanDescriptor<?>>> myEdges = new HashSet();
    private final Collection<CdiBeanDescriptor<?>> myRemovedNodes = new HashSet();
    private final Collection<CdiBeanDescriptor<?>> myAddedNodes = new HashSet();

    public CdiDiagramDataModel(Project project, DiagramProvider<CdiBeanDescriptor<?>> diagramProvider, VirtualFile file, CdiBeanDescriptor<?> element) {
        super(project, diagramProvider);
        this.myElement = element;
    }

    @NotNull
    public Collection<DiagramNode<CdiBeanDescriptor<?>>> getNodes() {
        Collection<DiagramNode<CdiBeanDescriptor<?>>> collection = this.myNodes;
        if (collection == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<CdiBeanDescriptor<?>>> getEdges() {
        Collection<DiagramEdge<CdiBeanDescriptor<?>>> collection = this.myEdges;
        if (collection == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public DiagramEdge<CdiBeanDescriptor<?>> createEdge(@NotNull DiagramNode<CdiBeanDescriptor<?>> from, @NotNull DiagramNode<CdiBeanDescriptor<?>> to) {
        boolean isProducable;
        if (from == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(2);
        }
        if (to == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(3);
        }
        CdiBeanDescriptor fromDescriptor = (CdiBeanDescriptor)from.getIdentifyingElement();
        CdiBeanDescriptor toDescriptor = (CdiBeanDescriptor)to.getIdentifyingElement();
        for (DiagramEdge<CdiBeanDescriptor<?>> edge : this.myEdges) {
            if (!edge.getSource().equals(from) || !edge.getTarget().equals(to)) continue;
            return null;
        }
        boolean isInjectable = toDescriptor instanceof CdiBeanPsiClassDescriptor && !(toDescriptor.getIdentifyingElement() instanceof PsiCompiledElement);
        boolean bl = isProducable = fromDescriptor instanceof CdiBeanPsiClassDescriptor && !(fromDescriptor.getIdentifyingElement() instanceof PsiCompiledElement);
        if (isInjectable || isProducable) {
            LinkedHashSet<CreateDependencyEdgeType> types = new LinkedHashSet<CreateDependencyEdgeType>();
            if (isInjectable) {
                types.add(CreateDependencyEdgeType.INJECT_FIELD);
                types.add(CreateDependencyEdgeType.INJECT_METHOD);
            }
            if (isProducable) {
                types.add(CreateDependencyEdgeType.PRODUCE_FIELD);
                types.add(CreateDependencyEdgeType.PRODUCE_METHOD);
            }
            if (!types.isEmpty()) {
                String[] names = (String[])ContainerUtil.map2Array(types, String.class, type -> type.getName());
                int i = Messages.showChooseDialog((String)CdiBundle.message("diagram.choose.dependency.type.message", new Object[0]), (String)CdiBundle.message("diagram.choose.dependency.type.title", new Object[0]), (String[])names, (String)names[0], null);
                if (i >= 0) {
                    CdiDiagramEdge edge = null;
                    block7: for (CreateDependencyEdgeType edgeType : CreateDependencyEdgeType.values()) {
                        if (!edgeType.getName().equals(names[i])) continue;
                        switch (edgeType) {
                            case INJECT_FIELD: {
                                edge = CdiDiagramDataModel.createInjectedEdge(from, to, false);
                                continue block7;
                            }
                            case INJECT_METHOD: {
                                edge = CdiDiagramDataModel.createInjectedEdge(from, to, true);
                                continue block7;
                            }
                            case PRODUCE_FIELD: {
                                edge = CdiDiagramDataModel.createProducesEdge(from, to, false);
                                continue block7;
                            }
                            case PRODUCE_METHOD: {
                                edge = CdiDiagramDataModel.createProducesEdge(from, to, true);
                            }
                        }
                    }
                    if (edge != null) {
                        this.myEdges.add((DiagramEdge<CdiBeanDescriptor<?>>)edge);
                        return edge;
                    }
                }
                return null;
            }
        }
        return super.createEdge(from, to);
    }

    @Nullable
    private static CdiInjectionPointEdge createInjectedEdge(DiagramNode<CdiBeanDescriptor<?>> from, DiagramNode<CdiBeanDescriptor<?>> to, boolean isMethod) {
        VirtualFile file;
        PsiClass toClass;
        PsiType fromType = ((CdiBeanDescriptor)from.getIdentifyingElement()).getType();
        PsiType toType = ((CdiBeanDescriptor)to.getIdentifyingElement()).getType();
        if (fromType != null && toType instanceof PsiClassType && (toClass = ((PsiClassType)toType).resolve()) != null && (file = toClass.getContainingFile().getVirtualFile()) != null && !ReadonlyStatusHandler.getInstance((Project)toClass.getProject()).ensureFilesWritable(Collections.singletonList(file)).hasReadonlyFiles()) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)toClass.getProject()).getElementFactory();
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)toClass.getProject());
            PsiMethod psiMember = isMethod ? CdiDiagramDataModel.createInjectedMethod(toClass, fromType, elementFactory, styleManager) : CdiDiagramDataModel.createInjectedField(toClass, fromType, elementFactory, styleManager);
            return new CdiInjectionPointEdge(from, to, new InjectionPointDescriptor((PsiModifierListOwner)psiMember), isMethod);
        }
        return null;
    }

    private static CdiProducerEdge createProducesEdge(DiagramNode<CdiBeanDescriptor<?>> from, DiagramNode<CdiBeanDescriptor<?>> to, boolean isMethod) {
        PsiClass fromClass;
        PsiType fromType = ((CdiBeanDescriptor)from.getIdentifyingElement()).getType();
        PsiType toType = ((CdiBeanDescriptor)to.getIdentifyingElement()).getType();
        if (toType != null && fromType instanceof PsiClassType && (fromClass = ((PsiClassType)fromType).resolve()) != null) {
            VirtualFile file = fromClass.getContainingFile().getVirtualFile();
            Project project = fromClass.getProject();
            if (file != null && !ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(file)).hasReadonlyFiles()) {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
                PsiMember psiMember = isMethod ? CdiDiagramDataModel.createProducesMethod(fromClass, toType, elementFactory, styleManager) : CdiDiagramDataModel.createProducesField(fromClass, toType, elementFactory, styleManager);
                return new CdiProducerEdge(from, to, psiMember);
            }
        }
        return null;
    }

    private static PsiMember createProducesMethod(PsiClass containingClass, PsiType type, PsiElementFactory elementFactory, JavaCodeStyleManager manager) {
        return (PsiMember)WriteCommandAction.writeCommandAction((Project)containingClass.getProject()).compute(() -> {
            String baseName;
            String paramName = manager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type).names[0];
            String methodName = baseName = "create" + StringUtil.capitalize((String)paramName);
            int i = 1;
            while (containingClass.findMethodsByName(methodName, true).length != 0) {
                methodName = baseName + i++;
            }
            String methodText = "public " + type.getCanonicalText() + " " + methodName + "() {return null;}";
            PsiMethod psiMethod = elementFactory.createMethodFromText(methodText, (PsiElement)containingClass);
            PsiMethod newMethod = (PsiMethod)containingClass.add((PsiElement)psiMethod);
            PsiModifierList modifierList = newMethod.getModifierList();
            modifierList.setModifierProperty("public", true);
            modifierList.addAnnotation(CdiAnnoConstants.PRODUCES_ANNOTATION.fqn((PsiElement)containingClass));
            return psiMethod;
        });
    }

    private static PsiField createInjectedField(@NotNull PsiClass containingClass, @NotNull PsiType type, @NotNull PsiElementFactory elementFactory, @NotNull JavaCodeStyleManager styleManager) {
        if (containingClass == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(4);
        }
        if (type == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(5);
        }
        if (elementFactory == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(6);
        }
        if (styleManager == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(7);
        }
        return CdiDiagramDataModel.createAnnotatedField(containingClass, type, elementFactory, styleManager, CdiAnnoConstants.INJECT_ANNOTATION.fqn((PsiElement)containingClass));
    }

    private static PsiField createProducesField(@NotNull PsiClass containingClass, @NotNull PsiType type, @NotNull PsiElementFactory elementFactory, @NotNull JavaCodeStyleManager styleManager) {
        if (containingClass == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(8);
        }
        if (type == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(9);
        }
        if (elementFactory == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(10);
        }
        if (styleManager == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(11);
        }
        return CdiDiagramDataModel.createAnnotatedField(containingClass, type, elementFactory, styleManager, CdiAnnoConstants.PRODUCES_ANNOTATION.fqn((PsiElement)containingClass));
    }

    private static PsiField createAnnotatedField(PsiClass containingClass, PsiType type, PsiElementFactory elementFactory, JavaCodeStyleManager styleManager, String annotation) {
        return (PsiField)WriteCommandAction.writeCommandAction((Project)containingClass.getProject()).compute(() -> {
            Object name = styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, null, null, (PsiType)type).names[0];
            int i = 1;
            while (containingClass.findFieldByName((String)name, true) != null) {
                name = (String)name + i++;
            }
            PsiField psiField = elementFactory.createField((String)name, type);
            PsiField newField = (PsiField)containingClass.add((PsiElement)psiField);
            PsiModifierList list = newField.getModifierList();
            if (list != null) {
                list.setModifierProperty("private", true);
                list.addAnnotation(annotation);
            }
            return psiField;
        });
    }

    private static PsiMethod createInjectedMethod(@NotNull PsiClass containingClass, @NotNull PsiType type, @NotNull PsiElementFactory elementFactory, @NotNull JavaCodeStyleManager styleManager) {
        if (containingClass == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(12);
        }
        if (type == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(13);
        }
        if (elementFactory == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(14);
        }
        if (styleManager == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(15);
        }
        return (PsiMethod)WriteCommandAction.writeCommandAction((Project)containingClass.getProject()).compute(() -> {
            String paramName = styleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type).names[0];
            String methodName = "set" + StringUtil.capitalize((String)paramName);
            int i = 1;
            while (containingClass.findMethodsByName(paramName, true).length != 0) {
                methodName = methodName + i++;
            }
            PsiMethod psiMethod = elementFactory.createMethod(methodName, (PsiType)PsiType.VOID);
            PsiMethod newMethod = (PsiMethod)containingClass.add((PsiElement)psiMethod);
            newMethod.getParameterList().add((PsiElement)elementFactory.createParameter(paramName, type));
            PsiModifierList modifierList = newMethod.getModifierList();
            modifierList.setModifierProperty("public", true);
            modifierList.addAnnotation(CdiAnnoConstants.INJECT_ANNOTATION.fqn((PsiElement)containingClass));
            return psiMethod;
        });
    }

    @NotNull
    public String getNodeName(DiagramNode<CdiBeanDescriptor<?>> n) {
        String name = n.getTooltip();
        String string = StringUtil.isEmptyOrSpaces((String)name) ? "Unknown" : name;
        if (string == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(16);
        }
        return string;
    }

    public DiagramNode<CdiBeanDescriptor<?>> addElement(CdiBeanDescriptor element) {
        CdiDiagramNode node;
        if (element != null) {
            this.myAddedNodes.add(element);
            this.myRemovedNodes.remove(element);
        }
        return this.myNodes.contains((Object)(node = new CdiDiagramNode(element, this.getProvider()))) ? null : node;
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(17);
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }

    public void updateDataModel() {
        CdiDiagramNode classNode = new CdiDiagramNode(this.myElement, this.getProvider());
        MultiMap map = new MultiMap();
        Module module = ModuleUtilCore.findModuleForPsiElement(this.myElement.getIdentifyingElement());
        if (module != null) {
            this.addNodeAndDependencies(classNode, map, new DiagramState(this.getBuilder()), module);
            for (CdiBeanDescriptor<?> addedNodeDescriptor : this.myAddedNodes) {
                CdiDiagramNode addedNode = new CdiDiagramNode(addedNodeDescriptor, this.getProvider());
                this.addNodeAndDependencies(addedNode, map, new DiagramState(this.getBuilder()), module);
            }
            this.myEdges.addAll(map.values());
        }
    }

    private void addNodeAndDependencies(@NotNull CdiDiagramNode classNode, @NotNull MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor<?>>> edges, @NotNull DiagramState diagramState, @NotNull Module module) {
        if (classNode == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(18);
        }
        if (edges == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(19);
        }
        if (diagramState == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(20);
        }
        if (module == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(21);
        }
        if (this.myNodes.contains((Object)classNode)) {
            return;
        }
        if (this.myRemovedNodes.contains(classNode.getIdentifyingElement())) {
            return;
        }
        this.myNodes.add((DiagramNode<CdiBeanDescriptor<?>>)classNode);
        Object beanDescriptor = classNode.getIdentifyingElement();
        if (beanDescriptor instanceof CdiBeanPsiClassDescriptor) {
            PsiClass psiClass = ((CdiBeanPsiClassDescriptor)beanDescriptor).getAnnotatedItem();
            if (diagramState.isCategoryEnabled(CdiDiagramCategoryManager.INJECTION_POINTS)) {
                this.addInjectedNodes(module, classNode, psiClass, edges, diagramState);
                this.addOutjectedNodes(module, classNode, psiClass, edges, diagramState);
            }
            if (diagramState.isCategoryEnabled(CdiDiagramCategoryManager.PRODUCERS)) {
                this.addProduces(psiClass, classNode, module, edges, diagramState);
                this.addFactories(module, psiClass, classNode, edges, diagramState);
            }
        }
    }

    private void addFactories(Module module, PsiClass psiClass, CdiDiagramNode targetNode, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor<?>>> edges, DiagramState diagramState) {
        PsiClassType type = JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass);
        List<PsiMember> producers = CdiCommonUtils.getPsiTypeProducers(module, (PsiType)type);
        for (PsiMember producer : producers) {
            PsiClass containingClass = producer.getContainingClass();
            CdiDiagramNode sourceNode = this.createNode(CdiDescriptorsFactory.createCdiBeanDescriptor(containingClass), module);
            if (sourceNode == null) continue;
            this.addNodeAndDependencies(sourceNode, edges, diagramState, module);
            CdiDiagramDataModel.addNewEdge(edges, (PsiElement)producer, new CdiProducerEdge((DiagramNode<CdiBeanDescriptor<?>>)sourceNode, (DiagramNode<CdiBeanDescriptor<?>>)targetNode, producer));
        }
    }

    private static void addNewEdge(@NotNull MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor<?>>> edges, @NotNull PsiElement owner, @NotNull DiagramEdge<CdiBeanDescriptor<?>> edge) {
        if (edges == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(22);
        }
        if (owner == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(23);
        }
        if (edge == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(24);
        }
        Collection edgeCollection = edges.get((Object)owner);
        for (DiagramEdge existingEdge : edgeCollection) {
            if (!existingEdge.equals(edge)) continue;
            return;
        }
        edges.putValue((Object)owner, edge);
    }

    private void addProduces(@NotNull PsiClass psiClass, @NotNull CdiDiagramNode sourceNode, Module module, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor<?>>> edges, DiagramState diagramState) {
        if (psiClass == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(25);
        }
        if (sourceNode == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(26);
        }
        for (PsiField psiField : CdiCommonUtils.getProducerFields(psiClass)) {
            this.addProducesNode(sourceNode, (PsiMember)psiField, module, edges, diagramState);
        }
        for (PsiMethod psiMethod : CdiCommonUtils.getProducerMethods(psiClass)) {
            this.addProducesNode(sourceNode, (PsiMember)psiMethod, module, edges, diagramState);
        }
    }

    private void addProducesNode(CdiDiagramNode sourceNode, PsiMember psiMember, Module module, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor<?>>> edges, DiagramState diagramState) {
        ProducerBeanDescriptor<? extends PsiMember> producerDescriptor = CdiDescriptorsFactory.createProducerCdiBeanDescriptor(psiMember);
        assert (producerDescriptor != null);
        CdiDiagramNode targetNode = this.createNode(producerDescriptor, module);
        if (targetNode != null) {
            this.addNodeAndDependencies(targetNode, edges, diagramState, module);
            CdiDiagramDataModel.addNewEdge(edges, (PsiElement)psiMember, new CdiProducerEdge((DiagramNode<CdiBeanDescriptor<?>>)sourceNode, (DiagramNode<CdiBeanDescriptor<?>>)targetNode, psiMember));
        }
    }

    @Nullable
    private CdiDiagramNode createNode(CdiBeanDescriptor<?> descriptor, Module module) {
        PsiClass originalPsiClass;
        PsiType type;
        if (this.myRemovedNodes.contains(descriptor)) {
            return null;
        }
        if (descriptor instanceof CdiBeanPsiClassDescriptor) {
            return new CdiDiagramNode(descriptor, this.getProvider());
        }
        if (descriptor instanceof ProducerBeanDescriptor && !CdiDiagramDataModel.isPsiClassTypeWithGenerics(type = descriptor.getType()) && (originalPsiClass = CdiCommonUtils.getOriginalPsiClass(descriptor.getType(), module)) != null) {
            CdiBeanPsiClassDescriptor cdiBeanDescriptor = CdiDescriptorsFactory.createCdiBeanDescriptor(originalPsiClass);
            return this.myRemovedNodes.contains(cdiBeanDescriptor) ? null : new CdiDiagramNode(cdiBeanDescriptor, this.getProvider());
        }
        return new CdiDiagramNode(descriptor, this.getProvider());
    }

    private void addOutjectedNodes(Module module, CdiDiagramNode sourceNode, PsiClass psiClass, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor<?>>> edges, DiagramState diagramState) {
        if (CdiCommonUtils.isDecorator(psiClass)) {
            return;
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)module.getProject()).createType(psiClass);
        Set<InjectionPointDescriptor> allInjectionPoints = CdiInjectionUtils.getInjectionPoints(module);
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints((PsiType)psiClassType, allInjectionPoints);
        for (InjectionPointDescriptor ip : injectionPoints) {
            CdiDiagramNode targetNode;
            PsiModifierListOwner owner = ip.getOwner();
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class);
            if (containingClass == null || CdiCommonUtils.isDecorator(containingClass) && !diagramState.isCategoryEnabled(CdiDiagramCategoryManager.DECORATORS) || (targetNode = this.createNode(CdiDescriptorsFactory.createCdiBeanDescriptor(containingClass), module)) == null) continue;
            this.addNodeAndDependencies(targetNode, edges, diagramState, module);
            CdiDiagramDataModel.addNewEdge(edges, (PsiElement)owner, new CdiInjectionPointEdge((DiagramNode<CdiBeanDescriptor<?>>)sourceNode, (DiagramNode<CdiBeanDescriptor<?>>)targetNode, ip, false));
        }
    }

    private void addInjectedNodes(@NotNull Module module, @NotNull CdiDiagramNode targetNode, @NotNull PsiClass psiClass, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor<?>>> edges, DiagramState diagramState) {
        if (module == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(27);
        }
        if (targetNode == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(28);
        }
        if (psiClass == null) {
            CdiDiagramDataModel.$$$reportNull$$$0(29);
        }
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints(psiClass);
        for (InjectionPointDescriptor ip : injectionPoints) {
            if (CdiClassesConstants.INJECTION_POINT_CLASS.fqn(module).equals(ip.getType().getCanonicalText()) && ip.getQualifierAnnotations().length == 0) continue;
            Collection<CdiBeanDescriptor<?>> beanDescriptors = CdiInjectionUtils.getInjectedBeans(ip);
            if (!beanDescriptors.isEmpty()) {
                for (CdiBeanDescriptor<?> beanDescriptor : beanDescriptors) {
                    CdiDiagramNode sourceNode;
                    Object identifyingElement = beanDescriptor.getIdentifyingElement();
                    if (identifyingElement instanceof PsiClass && CdiCommonUtils.isDecorator((PsiClass)identifyingElement) || (sourceNode = this.createNode(beanDescriptor, module)) == null) continue;
                    this.addNodeAndDependencies(sourceNode, edges, diagramState, module);
                    PsiModifierListOwner owner = ip.getOwner();
                    CdiDiagramDataModel.addNewEdge(edges, (PsiElement)owner, new CdiInjectionPointEdge((DiagramNode<CdiBeanDescriptor<?>>)sourceNode, (DiagramNode<CdiBeanDescriptor<?>>)targetNode, ip, beanDescriptors.size() > 2));
                }
                continue;
            }
            this.addInjectionPointEdge(module, targetNode, ip, ip.getType(), edges, diagramState, true);
        }
    }

    private void addInjectionPointEdge(Module module, CdiDiagramNode targetNode, InjectionPointDescriptor descriptor, PsiType type, MultiMap<PsiElement, DiagramEdge<CdiBeanDescriptor<?>>> edges, DiagramState diagramState, boolean unknownBean) {
        CdiDiagramNode sourceNode;
        PsiClass sourcePsiClass = CdiCommonUtils.getOriginalPsiClass(type, module);
        if (sourcePsiClass != null && (sourceNode = this.createNode(CdiDescriptorsFactory.createCdiBeanDescriptor(sourcePsiClass), module)) != null) {
            PsiModifierListOwner owner = descriptor.getOwner();
            CdiDiagramDataModel.addNewEdge(edges, (PsiElement)owner, new CdiInjectionPointEdge((DiagramNode<CdiBeanDescriptor<?>>)sourceNode, (DiagramNode<CdiBeanDescriptor<?>>)targetNode, descriptor, unknownBean));
            this.addNodeAndDependencies(sourceNode, edges, diagramState, module);
            this.addNodeAndDependencies(targetNode, edges, diagramState, module);
        }
    }

    private static boolean isPsiClassTypeWithGenerics(PsiType type) {
        if (type instanceof PsiClassType) {
            return CdiCommonUtils.resolveGenerics((PsiClassType)type).size() > 0;
        }
        return false;
    }

    public void removeNode(DiagramNode<CdiBeanDescriptor<?>> node) {
        CdiBeanDescriptor identifyingElement = (CdiBeanDescriptor)node.getIdentifyingElement();
        this.myRemovedNodes.add(identifyingElement);
        this.myAddedNodes.remove(identifyingElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/diagram/CdiDiagramDataModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleManager";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNode";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagramState";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/diagram/CdiDiagramDataModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createInjectedField";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProducesField";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createInjectedMethod";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addNodeAndDependencies";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addNewEdge";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addProduces";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addInjectedNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

